/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.attackwarnings.AttackWarningClientboundPacket;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.buildings.monsters.DarkWatchtower;
import com.solegendary.reignofnether.building.buildings.piglins.Bastion;
import com.solegendary.reignofnether.building.buildings.piglins.CentralPortal;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.buildings.piglins.Fortress;
import com.solegendary.reignofnether.building.buildings.piglins.PortalBasic;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.building.buildings.shared.AbstractStockpile;
import com.solegendary.reignofnether.building.buildings.villagers.Watchtower;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.fogofwar.FogOfWarServerEvents;
import com.solegendary.reignofnether.fogofwar.FrozenChunk;
import com.solegendary.reignofnether.fogofwar.FrozenChunkClientboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.BlockUtils;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.tps.TPSClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.BuildRepairGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.SilverfishUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.joml.Vector3d;

public class BuildingPlacement {
    private Building building;
    public Level level;
    public BlockPos originPos;
    public Rotation rotation;
    public boolean isExploredClientside = false;
    public boolean isDestroyedServerside = false;
    public boolean isBuiltServerside = false;
    public static String structureName;
    public final boolean isCapitol;
    public boolean isBuilt;
    private static final int BASE_MS_PER_BUILD = 500;
    public int msToNextBuild = 500;
    public final float MIN_BLOCKS_PERCENT = 0.5f;
    protected int highestBlockCountReached = 2;
    protected ArrayList<BuildingBlock> scaffoldBlocks = new ArrayList();
    protected ArrayList<BuildingBlock> blocks;
    protected ArrayList<BuildingBlock> blockPlaceQueue = new ArrayList();
    public String ownerName;
    public int serverBlocksPlaced = 1;
    private int totalBlocksEverBroken = 0;
    private long ticksToExtinguish = 0L;
    private final long TICKS_TO_EXTINGUISH = 100L;
    private final long TICKS_TO_SPAWN_ANIMALS_MAX = 1800L;
    private long ticksToSpawnAnimals = 0L;
    private final int MAX_ANIMALS = 8;
    private final int ANIMAL_SPAWN_BLOCK_RANGE = 70;
    private final int ANIMAL_SPAWN_RANGE_MIN = 15;
    protected long tickAgeAfterBuilt = 0L;
    protected long tickAge = 0L;
    public final BlockPos minCorner;
    public final BlockPos maxCorner;
    public final BlockPos centrePos;
    public boolean isDiagonalBridge = false;
    public boolean selfBuilding = false;
    protected List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    protected List<Ability> abilities = new ArrayList<Ability>();
    Object2ObjectArrayMap<Ability, Float> cooldowns = new Object2ObjectArrayMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    public Mob lastAttacker = null;
    public boolean allowProdWhileBuilding = false;
    public Ability autocast;
    private ArmorStand targetStand = null;
    private EntityType<? extends Animal> lastAnimalType = null;

    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    public List<Ability> getAbilities() {
        return this.abilities;
    }

    public int getHighestBlockCountReached() {
        return this.highestBlockCountReached;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ArmorStand getTargetStand() {
        if (this.targetStand == null) {
            this.createArmourStandTarget();
        }
        return this.targetStand;
    }

    public BuildingPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        Objects.requireNonNull(building, "Building can't be null");
        this.building = building;
        this.level = level;
        this.originPos = originPos;
        this.rotation = rotation;
        this.ownerName = ownerName;
        this.blocks = blocks;
        this.isCapitol = isCapitol;
        this.cooldowns.defaultReturnValue((Object)Float.valueOf(0.0f));
        this.minCorner = new BlockPos(blocks.stream().min(Comparator.comparing(block -> block.getBlockPos().m_123341_())).get().getBlockPos().m_123341_(), blocks.stream().min(Comparator.comparing(block -> block.getBlockPos().m_123342_())).get().getBlockPos().m_123342_(), blocks.stream().min(Comparator.comparing(block -> block.getBlockPos().m_123343_())).get().getBlockPos().m_123343_());
        this.maxCorner = new BlockPos(blocks.stream().max(Comparator.comparing(block -> block.getBlockPos().m_123341_())).get().getBlockPos().m_123341_(), blocks.stream().max(Comparator.comparing(block -> block.getBlockPos().m_123342_())).get().getBlockPos().m_123342_(), blocks.stream().max(Comparator.comparing(block -> block.getBlockPos().m_123343_())).get().getBlockPos().m_123343_());
        this.centrePos = new BlockPos((int)((float)(this.minCorner.m_123341_() + this.maxCorner.m_123341_()) / 2.0f), (int)((float)(this.minCorner.m_123342_() + this.maxCorner.m_123342_()) / 2.0f), (int)((float)(this.minCorner.m_123343_() + this.maxCorner.m_123343_()) / 2.0f));
        if (this.isCapitol && !this.level.m_5776_()) {
            if (BuildingUtils.getTotalCompletedBuildingsOwned(false, this.ownerName) == 1 && !TutorialServerEvents.isEnabled() && FogOfWarServerEvents.isEnabled()) {
                PlayerServerEvents.sendMessageToAllPlayers("hud.reignofnether.placed_capitol", false, this.ownerName);
            }
            FogOfWarClientboundPacket.revealOrHidePlayer(false, this.ownerName);
        }
        for (Ability ability : building.abilities.get()) {
            this.getAbilities().add(ability);
        }
        this.updateButtons();
    }

    public float getMeleeDamageMult() {
        return this.getBuilding().getMeleeDamageMult();
    }

    public Faction getFaction() {
        return this.getBuilding().getFaction();
    }

    public void refreshBlocks() {
        for (BuildingBlock block : this.blocks) {
            if (block.isPlaced(this.level) || block.getBlockState().m_60795_()) continue;
            this.addToBlockPlaceQueue(block);
        }
    }

    public void setServerBlocksPlaced(int blocksPlaced) {
        this.serverBlocksPlaced = blocksPlaced;
        if (this.getBlocksPlaced() > this.highestBlockCountReached) {
            this.highestBlockCountReached = this.getBlocksPlaced();
        }
    }

    public void addToBlockPlaceQueue(BuildingBlock block) {
        this.blockPlaceQueue.add(block);
    }

    public ArrayList<WorkerUnit> getBuilders(Level level) {
        ArrayList<WorkerUnit> builders = new ArrayList<WorkerUnit>();
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            WorkerUnit workerUnit;
            BuildRepairGoal goal;
            if (!(entity instanceof WorkerUnit) || (goal = (workerUnit = (WorkerUnit)entity).getBuildRepairGoal()) == null || goal.getBuildingTarget() != this || !goal.isBuilding()) continue;
            builders.add(workerUnit);
        }
        return builders;
    }

    public ArrayList<BuildingBlock> getBlocks() {
        return this.blocks;
    }

    public ArrayList<BuildingBlock> getScaffoldBlocks() {
        return this.scaffoldBlocks;
    }

    public static Button getBuildButton() {
        return null;
    }

    public boolean canAfford(String ownerName) {
        if (SandboxServer.isAnyoneASandboxPlayer() && (ownerName.isEmpty() || ownerName.equals("Enemy"))) {
            return true;
        }
        if (SurvivalServerEvents.isEnabled() && "Enemy".equals(ownerName)) {
            return true;
        }
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            return resources.food >= this.building.cost.food && resources.wood >= this.building.cost.wood && resources.ore >= this.building.cost.ore;
        }
        return false;
    }

    public boolean isPosInsideBuilding(BlockPos bp) {
        return bp.m_123341_() <= this.maxCorner.m_123341_() && bp.m_123341_() >= this.minCorner.m_123341_() && bp.m_123342_() <= this.maxCorner.m_123342_() && bp.m_123342_() >= this.minCorner.m_123342_() && bp.m_123343_() <= this.maxCorner.m_123343_() && bp.m_123343_() >= this.minCorner.m_123343_();
    }

    public boolean isPosPartOfBuilding(BlockPos bp, boolean onlyPlacedBlocks) {
        for (BuildingBlock block : this.blocks) {
            if (!block.isPlaced(this.getLevel()) && onlyPlacedBlocks || !block.getBlockPos().equals((Object)bp)) continue;
            return true;
        }
        return false;
    }

    public BlockPos getClosestGroundPos(BlockPos bpTarget, int radiusOffset) {
        float minDist = 999999.0f;
        BlockPos minPos = this.minCorner;
        int minX = minPos.m_123341_() - radiusOffset;
        int minY = minPos.m_123342_();
        int minZ = minPos.m_123343_() - radiusOffset;
        BlockPos maxPos = this.maxCorner;
        int maxX = maxPos.m_123341_() + radiusOffset + 1;
        int maxZ = maxPos.m_123343_() + radiusOffset + 1;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                float dist;
                BlockPos bp = new BlockPos(x, minY, z);
                if (!(this.getBuilding() instanceof AbstractBridge) && this.isPosInsideBuilding(bp) || !((dist = (float)bpTarget.m_203198_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_())) < minDist)) continue;
                minDist = dist;
                minPos = bp;
            }
        }
        return minPos;
    }

    private boolean isFullyLoadedClientSide(ClientLevel level) {
        for (BuildingBlock block : this.blocks) {
            if (level.m_46749_(block.getBlockPos())) continue;
            return false;
        }
        return true;
    }

    public int getBlocksTotal() {
        return this.blocks.stream().filter(b -> !b.getBlockState().m_60795_()).toList().size();
    }

    public int getBlocksPlaced() {
        if (!this.getLevel().m_5776_() || this.isFullyLoadedClientSide((ClientLevel)this.getLevel())) {
            int blocksPlaced = this.blocks.stream().filter(b -> b.isPlaced(this.getLevel()) && !b.getBlockState().m_60795_()).toList().size();
            if (blocksPlaced > this.highestBlockCountReached) {
                this.highestBlockCountReached = blocksPlaced;
            }
            return blocksPlaced;
        }
        return this.serverBlocksPlaced;
    }

    public float getBlocksPlacedPercent() {
        return (float)this.getBlocksPlaced() / (float)this.getBlocksTotal();
    }

    public float getUnbuiltBlocksPlacedPercent() {
        return (float)this.getBlocksPlaced() / (float)this.highestBlockCountReached;
    }

    public int getHealth() {
        return (int)((float)this.getBlocksPlaced() / 0.5f) - this.getHighestBlockCountReached();
    }

    public int getMaxHealth() {
        return (int)((float)this.getHighestBlockCountReached() / 0.5f) - this.getHighestBlockCountReached();
    }

    public void buildNextBlock(ServerLevel level, String builderName) {
        BlockPos bp;
        if (this.isBuilt) {
            if (!ResourcesServerEvents.canAfford(builderName, ResourceName.WOOD, 1)) {
                ResourcesClientboundPacket.warnInsufficientResources(builderName, true, false, true);
                return;
            }
            ResourcesServerEvents.addSubtractResources(new Resources(builderName, 0, -1, 0));
        }
        ArrayList<BuildingBlock> unplacedBlocks = new ArrayList<BuildingBlock>(this.blocks.stream().filter(b -> !b.isPlaced(this.getLevel()) && !b.getBlockState().m_60795_()).toList());
        int minY = BuildingUtils.getMinCorner(unplacedBlocks).m_123342_();
        ArrayList<BuildingBlock> validBlocks = new ArrayList<BuildingBlock>();
        int nonFloatingBlocks = 0;
        if (!(this.getBuilding() instanceof AbstractBridge)) {
            for (BuildingBlock block : unplacedBlocks) {
                bp = block.getBlockPos();
                if (bp.m_123342_() > minY || level.m_8055_(bp.m_7495_()).m_60795_() && level.m_8055_(bp.m_122029_()).m_60795_() && level.m_8055_(bp.m_122024_()).m_60795_() && level.m_8055_(bp.m_122019_()).m_60795_() && level.m_8055_(bp.m_122012_()).m_60795_() && level.m_8055_(bp.m_7494_()).m_60795_()) continue;
                ++nonFloatingBlocks;
                validBlocks.add(block);
            }
        }
        if (nonFloatingBlocks == 0) {
            for (BuildingBlock block : unplacedBlocks) {
                bp = block.getBlockPos();
                if (bp.m_123342_() > minY && !(this.getBuilding() instanceof AbstractBridge)) continue;
                validBlocks.add(block);
            }
        }
        if (validBlocks.size() > 0) {
            if (this.getBuilding() instanceof AbstractBridge) {
                ArrayList<WorkerUnit> builders = this.getBuilders(this.level);
                BlockPos builderPos = ((LivingEntity)builders.get(new Random().nextInt(builders.size()))).m_20097_();
                validBlocks.sort(Comparator.comparing(bb -> bb.getBlockPos().m_123331_((Vec3i)builderPos)));
            }
            this.blockPlaceQueue.add((BuildingBlock)validBlocks.get(0));
        }
    }

    private void extinguishFires(ServerLevel level) {
        BlockPos minPos = this.minCorner.m_7918_(-1, -1, -1);
        BlockPos maxPos = this.maxCorner.m_7918_(1, 1, 1);
        for (int x = minPos.m_123341_(); x <= maxPos.m_123341_(); ++x) {
            for (int y = minPos.m_123342_(); y <= maxPos.m_123342_(); ++y) {
                for (int z = minPos.m_123343_(); z <= maxPos.m_123343_(); ++z) {
                    if (level.m_8055_(new BlockPos(x, y, z)).m_60734_() != Blocks.f_50083_) continue;
                    level.m_46961_(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    public boolean canDestroyBlock(BlockPos relativeBp) {
        return true;
    }

    public void destroyRandomBlocks(int amount) {
        if (this.getLevel().m_5776_()) {
            return;
        }
        if (this.building.invulnerable) {
            return;
        }
        ArrayList<BuildingBlock> placedBlocks = new ArrayList<BuildingBlock>(this.blocks.stream().filter(b -> {
            if (!(this instanceof BridgePlacement || !this.level.m_8055_(b.getBlockPos()).m_60819_().m_76178_() || this.level.m_8055_(b.getBlockPos().m_7494_()).m_60819_().m_76178_() && this.level.m_8055_(b.getBlockPos().m_122012_()).m_60819_().m_76178_() && this.level.m_8055_(b.getBlockPos().m_122019_()).m_60819_().m_76178_() && this.level.m_8055_(b.getBlockPos().m_122029_()).m_60819_().m_76178_() && this.level.m_8055_(b.getBlockPos().m_122024_()).m_60819_().m_76178_())) {
                return false;
            }
            if (!this.canDestroyBlock(b.getBlockPos().m_7918_(-this.originPos.m_123341_(), -this.originPos.m_123342_(), -this.originPos.m_123343_()))) {
                return false;
            }
            return b.isPlaced(this.getLevel());
        }).toList());
        Collections.shuffle(placedBlocks);
        for (int i = 0; i < amount && i < placedBlocks.size(); ++i) {
            BlockPos bp = placedBlocks.get(i).getBlockPos();
            this.onBlockBreak((ServerLevel)this.getLevel(), bp, false);
            if (!this.getLevel().m_8055_(bp).m_60819_().m_76178_()) {
                this.getLevel().m_46597_(bp, Blocks.f_50016_.m_49966_());
                continue;
            }
            this.getLevel().m_46961_(bp, false);
        }
        if (amount > 0) {
            AttackWarningClientboundPacket.sendWarning(this.ownerName, BuildingUtils.getCentrePos(this.getBlocks()));
        }
    }

    public boolean shouldBeDestroyed() {
        if (!this.level.m_6857_().m_61937_(this.centrePos)) {
            return true;
        }
        if (!(!this.level.m_5776_() || FogOfWarClientEvents.isBuildingInBrightChunk(this) && this.isDestroyedServerside)) {
            return false;
        }
        if (!this.blockPlaceQueue.isEmpty()) {
            return false;
        }
        if (this.getBlocksPlaced() <= 0) {
            return true;
        }
        if (this.isBuilt) {
            return this.getBlocksPlacedPercent() <= this.MIN_BLOCKS_PERCENT;
        }
        return this.totalBlocksEverBroken > 0 && this.getUnbuiltBlocksPlacedPercent() <= this.MIN_BLOCKS_PERCENT;
    }

    public void destroy(ServerLevel serverLevel) {
        this.forceChunk(false);
        this.blocks.forEach(block -> {
            if (!block.getBlockState().m_60819_().m_76178_() || block.getBlockState().m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)block.getBlockState().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                BlockState air = Blocks.f_50016_.m_49966_();
                serverLevel.m_46597_(block.getBlockPos(), air);
            }
            int x = block.getBlockPos().m_123341_();
            int y = block.getBlockPos().m_123342_();
            int z = block.getBlockPos().m_123343_();
            if (block.isPlaced((Level)serverLevel) && x % 2 == 0 && z % 2 != 0) {
                serverLevel.m_254877_(null, null, null, (double)x, (double)y, (double)z, 1.0f, false, Level.ExplosionInteraction.TNT);
            }
            serverLevel.m_46961_(block.getBlockPos(), false);
        });
        this.scaffoldBlocks.forEach(block -> {
            if (serverLevel.m_8055_(block.getBlockPos()).m_60734_() == Blocks.f_50616_) {
                serverLevel.m_46961_(block.getBlockPos(), false);
            }
        });
        if (this.scaffoldBlocks.isEmpty()) {
            for (int x = this.minCorner.m_123341_(); x <= this.maxCorner.m_123341_(); ++x) {
                for (int y = this.minCorner.m_123342_() - 3; y < this.minCorner.m_123342_(); ++y) {
                    for (int z = this.minCorner.m_123343_(); z <= this.maxCorner.m_123343_(); ++z) {
                        if (serverLevel.m_8055_(new BlockPos(x, y, z)).m_60734_() != Blocks.f_50616_) continue;
                        serverLevel.m_46961_(new BlockPos(x, y, z), false);
                    }
                }
            }
        }
        if (!this.level.m_5776_() && PlayerServerEvents.isRTSPlayer(this.ownerName)) {
            if (BuildingUtils.getTotalCompletedBuildingsOwned(false, this.ownerName) == 0 && !SandboxServer.isSandboxPlayer(this.ownerName)) {
                PlayerServerEvents.defeat(this.ownerName, Component.m_237115_((String)"server.reignofnether.lost_buildings").getString());
            } else if (this.isCapitol) {
                int numCapitolsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(this.ownerName) && b.isCapitol).toList().size();
                if (FogOfWarServerEvents.isEnabled() && numCapitolsOwned == 0) {
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.lost_capitol", false, this.ownerName, 60);
                }
            }
        }
        if (this.targetStand != null) {
            this.targetStand.m_146870_();
        }
        if (this.ownerName.isEmpty()) {
            this.awardBounty();
        }
    }

    private void awardBounty() {
        Unit unit;
        Mob mob = this.lastAttacker;
        if (mob instanceof Unit && !(unit = (Unit)mob).getOwnerName().isEmpty()) {
            ResourceCost cost = this.building.cost;
            Resources resources = new Resources(unit.getOwnerName(), (int)((float)cost.food * 0.25f), (int)((float)cost.wood * 0.25f), (int)((float)cost.ore * 0.25f));
            if (resources.getTotalValue() > 0) {
                ResourcesClientboundPacket.showFloatingText(resources, this.centrePos);
                ResourcesServerEvents.addSubtractResources(resources);
            }
        }
    }

    public void onBlockBreak(ServerLevel level, BlockPos pos, boolean breakBlocks) {
        ++this.totalBlocksEverBroken;
        Random rand = new Random();
        if (this.getFaction() == Faction.MONSTERS && ResearchServerEvents.playerHasResearch(this.ownerName, ProductionItems.RESEARCH_SILVERFISH)) {
            this.randomSilverfishSpawn(pos);
        }
        if (rand.nextFloat(1.0f) < this.building.explodeChance) {
            level.m_254877_(null, level.m_269111_().m_269264_(), null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), breakBlocks ? this.building.explodeRadius : 2.0f, this.getBlocksPlacedPercent() < this.building.fireThreshold, breakBlocks ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
        }
    }

    private void randomSilverfishSpawn(BlockPos pos) {
        Entity entity;
        Random rand = new Random();
        if (rand.nextFloat(1.0f) < 0.1f && (entity = ((EntityType)EntityRegistrar.SILVERFISH_UNIT.get()).m_20615_(this.level)) instanceof SilverfishUnit) {
            SilverfishUnit silverfishUnit = (SilverfishUnit)entity;
            ((Unit)entity).setOwnerName(this.ownerName);
            this.level.m_7967_(entity);
            BlockPos movePos = pos;
            if (pos.m_123342_() > this.originPos.m_123342_() + 4) {
                List<BlockPos> bps = this.blocks.stream().map(BuildingBlock::getBlockPos).filter(bp -> bp.m_123342_() == this.originPos.m_123342_() + 1 && (bp.m_123341_() == this.originPos.m_123341_() || bp.m_123341_() == this.maxCorner.m_123341_() || bp.m_123343_() == this.originPos.m_123343_() || bp.m_123343_() == this.maxCorner.m_123343_())).toList();
                movePos = bps.get(rand.nextInt(bps.size()));
            }
            if (!this.level.m_8055_(movePos).m_60795_()) {
                if (this.level.m_8055_(movePos.m_122012_()).m_60795_()) {
                    movePos = movePos.m_122012_();
                } else if (this.level.m_8055_(movePos.m_122019_()).m_60795_()) {
                    movePos = movePos.m_122019_();
                } else if (this.level.m_8055_(movePos.m_122029_()).m_60795_()) {
                    movePos = movePos.m_122029_();
                } else if (this.level.m_8055_(movePos.m_122024_()).m_60795_()) {
                    movePos = movePos.m_122024_();
                }
            }
            entity.m_6027_((double)((float)movePos.m_123341_() + 0.5f), (double)((float)movePos.m_123342_() + 0.5f), (double)((float)movePos.m_123343_() + 0.5f));
            silverfishUnit.setLimitedLife();
        }
    }

    public boolean isAbilityOffCooldown(UnitAction action) {
        for (Ability ability : this.abilities) {
            if (ability.action != action || !(ability.getCooldown(this) <= 0.0f)) continue;
            return true;
        }
        return false;
    }

    public void forceChunk(boolean add) {
        if (!this.level.m_5776_()) {
            BlockPos centreBp = this.centrePos;
            ChunkAccess chunk = this.level.m_46865_(centreBp);
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.level), (String)"reignofnether", (BlockPos)centreBp, (int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_, (boolean)add, (boolean)true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onBuilt() {
        BuildingPlacement buildingPlacement;
        this.isBuilt = true;
        if (!this.level.m_5776_()) {
            FrozenChunkClientboundPacket.setBuildingBuiltServerside(this.originPos);
            if (this.isCapitol && BuildingUtils.getTotalCompletedBuildingsOwned(false, this.ownerName) <= 1) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnHuntableAnimalsNearby(35);
                }
            }
        } else {
            TutorialClientEvents.updateStage();
            if (this.isCapitol && !SandboxClientEvents.isSandboxPlayer() && BuildingUtils.getTotalCompletedBuildingsOwned(this.level.m_5776_(), this.ownerName) == 1) {
                SoundClientEvents.playFactionCalmTheme(this.getFaction(), this.ownerName);
            }
        }
        if (this.level.m_5776_() && !this.isExploredClientside && !(this.getBuilding() instanceof CustomBuilding)) {
            for (BuildingBlock buildingBlock : this.blocks) {
                if (this.level.m_8055_(buildingBlock.getBlockPos()).m_60795_()) continue;
                this.level.m_46597_(buildingBlock.getBlockPos(), Blocks.f_50016_.m_49966_());
            }
        }
        if (!this.level.m_5776_() && this.ownerName.equals("Enemy") && (buildingPlacement = this) instanceof GarrisonableBuilding) {
            void var2_9;
            GarrisonableBuilding garr = (GarrisonableBuilding)((Object)buildingPlacement);
            int n = 7;
            if (this.getBuilding() instanceof DarkWatchtower || this.getBuilding() instanceof Watchtower) {
                int n2 = 3;
            } else if (this.getBuilding() instanceof Bastion) {
                int n3 = 4;
            }
            for (int i = 0; i < var2_9; ++i) {
                EntityType entityType = null;
                if (this.getFaction() == Faction.VILLAGERS) {
                    entityType = (EntityType)EntityRegistrar.PILLAGER_UNIT.get();
                } else if (this.getFaction() == Faction.MONSTERS) {
                    entityType = (EntityType)EntityRegistrar.SKELETON_UNIT.get();
                } else if (this.getFaction() == Faction.PIGLINS) {
                    entityType = (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get();
                }
                if (entityType == null) continue;
                UnitServerEvents.spawnMob((EntityType<? extends Mob>)entityType, (ServerLevel)this.level, (Vec3i)this.originPos.m_121955_((Vec3i)garr.getEntryPosition()), "Enemy");
            }
        }
    }

    public void onBlockBuilt(BlockPos bp, BlockState bs) {
    }

    public void tick(Level tickLevel) {
        float blocksTotal;
        for (Map.Entry cooldownEntry : this.cooldowns.entrySet()) {
            Ability ability = (Ability)cooldownEntry.getKey();
            float cooldown = ((Float)cooldownEntry.getValue()).floatValue();
            if (!(cooldown > 0.0f) && this.getCharges(ability) >= ability.maxCharges) continue;
            if (this.level.m_5776_()) {
                this.cooldowns.put((Object)ability, (Object)Float.valueOf((float)((double)cooldown - TPSClientEvents.getCappedTPS() / 20.0)));
            } else {
                this.cooldowns.put((Object)ability, (Object)Float.valueOf(cooldown - 1.0f));
            }
            if (!(cooldown <= 0.0f) || !ability.usesCharges() || this.getCharges(ability) >= ability.maxCharges) continue;
            this.setCharges(ability, this.getCharges(ability) + 1);
            if (this.getCharges(ability) < ability.maxCharges) {
                this.cooldowns.put((Object)ability, (Object)Float.valueOf(ability.cooldownMax));
            }
            if (this.getCharges(ability) <= ability.maxCharges) continue;
            this.setCharges(ability, ability.maxCharges);
        }
        float blocksPlaced = this.getBlocksPlaced();
        if (blocksPlaced >= (blocksTotal = (float)this.getBlocksTotal()) && !this.isBuilt) {
            this.onBuilt();
        }
        if (tickLevel.m_5776_()) {
            this.handleClientTick();
        } else {
            this.handleServerTick((ServerLevel)tickLevel, blocksPlaced, blocksTotal);
        }
        if (this.level.f_46443_ && (!FogOfWarClientEvents.isEnabled() || FogOfWarClientEvents.isInBrightChunk(this.originPos))) {
            this.isExploredClientside = true;
        }
        if (this.isCapitol && this.isBuilt) {
            ++this.ticksToSpawnAnimals;
            if (this.ticksToSpawnAnimals >= 1800L) {
                this.ticksToSpawnAnimals = 0L;
                this.spawnHuntableAnimalsNearby(70);
            }
        }
        if (this.isBuilt) {
            ++this.tickAgeAfterBuilt;
        }
        ++this.tickAge;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClientTick() {
        if (this.blockPlaceQueue.size() > 0) {
            this.blockPlaceQueue.remove(0);
        }
    }

    private void handleServerTick(ServerLevel serverLevel, float blocksPlaced, float blocksTotal) {
        ArrayList<WorkerUnit> workerUnits = this.getBuilders((Level)serverLevel);
        int builderCount = workerUnits.size();
        for (WorkerUnit workerUnit : workerUnits) {
            VillagerUnit vUnit;
            if (workerUnit instanceof VillagerUnit && (vUnit = (VillagerUnit)workerUnit).getUnitProfession() == VillagerUnitProfession.MASON) {
                builderCount = vUnit.isVeteran() ? (builderCount += 2) : ++builderCount;
            }
            if (!((Mob)workerUnit).m_21221_().containsKey(MobEffects.f_19598_)) continue;
            ++builderCount;
        }
        boolean hasFastBuildCheat = ResearchServerEvents.playerHasCheat(this.ownerName, "warpten");
        if (blocksPlaced < blocksTotal) {
            if (builderCount > 0) {
                ++this.ticksToExtinguish;
                if (this.ticksToExtinguish >= 100L) {
                    if (!(this.getBuilding() instanceof FlameSanctuary) && !(this.getBuilding() instanceof Fortress)) {
                        this.extinguishFires(serverLevel);
                    }
                    this.ticksToExtinguish = 0L;
                }
                int msPerBuild = 1500 / (builderCount + 2);
                if (!this.isBuilt) {
                    msPerBuild = (int)((float)msPerBuild * this.building.buildTimeModifier);
                    if (this.isCapitol && BuildingUtils.getTotalCompletedBuildingsOwned(false, this.ownerName) > 0) {
                        msPerBuild *= 2;
                    }
                } else {
                    msPerBuild = (int)((float)msPerBuild * this.building.repairTimeModifier);
                }
                if (this.getBuilding() instanceof PortalBasic && !BuildingServerEvents.isOnNetherBlocks(this.blocks, this.originPos, serverLevel) && !ResearchServerEvents.playerHasResearch(this.ownerName, ProductionItems.RESEARCH_ADVANCED_PORTALS)) {
                    msPerBuild = (int)((float)msPerBuild * 2.0f);
                }
                if (this.msToNextBuild > msPerBuild) {
                    this.msToNextBuild = msPerBuild;
                }
                this.msToNextBuild = hasFastBuildCheat ? (this.msToNextBuild -= 500) : (this.msToNextBuild -= 50);
                if (this.msToNextBuild <= 0) {
                    this.msToNextBuild = msPerBuild;
                    Collections.shuffle(workerUnits);
                    if (!workerUnits.isEmpty()) {
                        WorkerUnit wUnit = workerUnits.get(0);
                        String ownerName = ((Unit)((Object)wUnit)).getOwnerName();
                        int numBuildingsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(ownerName)).toList().size();
                        if (wUnit instanceof VillagerUnit) {
                            VillagerUnit vUnit = (VillagerUnit)wUnit;
                            if (numBuildingsOwned > 1) {
                                vUnit.incrementMasonExp();
                            }
                        }
                        this.buildNextBlock(serverLevel, ownerName);
                    }
                }
            } else if ((this.selfBuilding || hasFastBuildCheat) && !this.isBuilt) {
                this.buildNextBlock(serverLevel, this.ownerName);
            }
        } else {
            this.ticksToExtinguish = 0L;
        }
        if (this.blockPlaceQueue.size() > 0) {
            BuildingBlock nextBlock = this.blockPlaceQueue.get(0);
            BlockPos bp = nextBlock.getBlockPos();
            BlockState bs = nextBlock.getBlockState();
            if (this.level.m_46749_(bp)) {
                this.level.m_46597_(bp, bs);
                if (bs.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    if (this.level.m_8055_(bp.m_7495_()).m_60734_() == Blocks.f_50135_) {
                        this.level.m_46597_(bp.m_7495_(), Blocks.f_50136_.m_49966_());
                    } else if (this.level.m_8055_(bp.m_7495_()).m_60734_() == Blocks.f_50450_ || this.level.m_8055_(bp.m_7495_()).m_60734_() == BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()) {
                        this.level.m_46597_(bp.m_7495_(), Blocks.f_50652_.m_49966_());
                    }
                }
                this.level.m_46796_(2001, bp, Block.m_49956_((BlockState)bs));
                this.level.m_46796_(bs.m_60827_().m_56777_().hashCode(), bp, Block.m_49956_((BlockState)bs));
                this.blockPlaceQueue.removeIf(i -> i.equals(nextBlock));
                this.onBlockBuilt(bp, bs);
                if (this.getBlocksPlaced() > this.highestBlockCountReached) {
                    this.highestBlockCountReached = this.getBlocksPlaced();
                }
            }
        }
        if (this.isBuilt && this.tickAgeAfterBuilt % 10L == 0L && this.getBuilding().capturable) {
            this.checkIfCaptured(serverLevel);
        }
    }

    private void spawnHuntableAnimalsNearby(int range) {
        BlockPos spawnBp;
        BlockState spawnBs;
        int numNearbyChickens;
        if (this.level.m_5776_()) {
            return;
        }
        int retries = 0;
        int MAX_RETRIES = 2;
        int numNearbyAnimals = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), (float)range, Animal.class, this.level).stream().filter(ResourceSources::isHuntableAnimal).toList().size();
        if (numNearbyAnimals - (numNearbyChickens = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), (float)range, Chicken.class, this.level).stream().toList().size()) / 2 >= 8) {
            return;
        }
        int spawnAttempts = 0;
        Random random = new Random();
        do {
            BlockState bs;
            int y;
            int x = this.centrePos.m_123341_() + random.nextInt(-range / 2, range / 2);
            int z = this.centrePos.m_123343_() + random.nextInt(-range / 2, range / 2);
            for (y = this.level.m_46745_(new BlockPos(x, 0, z)).m_5885_(Heightmap.Types.WORLD_SURFACE, x, z); !(bs = this.level.m_8055_(new BlockPos(x, y, z))).m_280296_() && bs.m_60819_().m_76178_() && y > 0; --y) {
            }
            spawnBp = new BlockPos(x, y, z);
            spawnBs = this.level.m_8055_(spawnBp);
            if (++spawnAttempts <= 20) continue;
            if (retries < 2) {
                spawnAttempts = 0;
                ++retries;
                range = (int)((float)range - (float)range * 0.35f);
                continue;
            }
            ReignOfNether.LOGGER.warn("Gave up trying to find a suitable animal spawn!");
            return;
        } while (!spawnBs.m_280296_() || spawnBs.m_204336_(BlockTags.f_13035_) || spawnBs.m_60734_() == Blocks.f_50375_ || spawnBs.m_204336_(BlockTags.f_13106_) || spawnBs.m_204336_(BlockTags.f_13090_) || spawnBp.m_123331_((Vec3i)this.centrePos) < 225.0 || spawnBp.m_123331_((Vec3i)this.centrePos) > (double)(range * range) || Math.abs(spawnBp.m_123342_() - this.minCorner.m_123342_()) >= 4 || BuildingUtils.isPosInsideAnyBuilding(this.level.m_5776_(), spawnBp) || BuildingUtils.isPosInsideAnyBuilding(this.level.m_5776_(), spawnBp.m_7494_()) || !this.level.m_6857_().m_61937_(spawnBp) || spawnBs.m_204336_(BlockTags.f_13039_) || BlockUtils.isBottomSlab(spawnBs));
        EntityType animalType = null;
        int spawnQty = 1;
        if (this.getBuilding() instanceof CentralPortal && this.lastAnimalType != EntityType.f_20504_) {
            animalType = EntityType.f_20504_;
        } else {
            switch (random.nextInt(4)) {
                case 0: {
                    animalType = EntityType.f_20557_;
                    break;
                }
                case 1: {
                    animalType = EntityType.f_20510_;
                    break;
                }
                case 2: {
                    animalType = EntityType.f_20520_;
                    break;
                }
                case 3: {
                    animalType = EntityType.f_20555_;
                    spawnQty = 2;
                }
            }
        }
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)animalType, (ServerLevel)this.level, (Vec3i)spawnBp.m_7494_(), spawnQty, "");
        this.lastAnimalType = animalType;
    }

    public List<BlockPos> getRenderChunkOrigins(boolean extendedRange) {
        double addedRange = 0.0;
        if (extendedRange) {
            BuildingPlacement buildingPlacement = this;
            if (buildingPlacement instanceof NetherConvertingBuilding) {
                NetherConvertingBuilding netherConvertingBuilding = (NetherConvertingBuilding)((Object)buildingPlacement);
                double range = netherConvertingBuilding.getMaxRange();
                addedRange = 16.0 * Math.ceil(Math.abs(range / 16.0)) + 16.0;
            } else if (this.getBuilding() instanceof AbstractStockpile) {
                addedRange = 32.0;
            }
        }
        ArrayList<BlockPos> origins = new ArrayList<BlockPos>();
        BlockPos minCorner = BuildingUtils.getMinCorner(this.getBlocks()).m_7918_((int)(-addedRange / 2.0), -1, (int)(-addedRange / 2.0));
        BlockPos maxCorner = BuildingUtils.getMaxCorner(this.getBlocks()).m_7918_((int)addedRange / 2, -1, (int)addedRange / 2);
        BlockPos minOrigin = new BlockPos((int)Math.round(Math.floor((double)minCorner.m_123341_() / 16.0) * 16.0), (int)Math.round(Math.floor((double)minCorner.m_123342_() / 16.0) * 16.0), (int)Math.round(Math.floor((double)minCorner.m_123343_() / 16.0) * 16.0));
        BlockPos maxOrigin = new BlockPos((int)Math.round(Math.floor((double)maxCorner.m_123341_() / 16.0) * 16.0), (int)Math.round(Math.floor((double)maxCorner.m_123342_() / 16.0) * 16.0), (int)Math.round(Math.floor((double)maxCorner.m_123343_() / 16.0) * 16.0));
        for (int x = minOrigin.m_123341_(); x <= maxOrigin.m_123341_(); x += 16) {
            for (int y = minOrigin.m_123342_() - 16; y <= maxOrigin.m_123342_(); y += 16) {
                for (int z = minOrigin.m_123343_(); z <= maxOrigin.m_123343_(); z += 16) {
                    origins.add(new BlockPos(x, y, z));
                }
            }
        }
        return origins;
    }

    public void freezeChunks(String localPlayerName, boolean forceFakeBlocks) {
        if (!this.level.f_46443_) {
            return;
        }
        if (this.ownerName.equals(localPlayerName)) {
            return;
        }
        for (BlockPos bp : this.getRenderChunkOrigins(true)) {
            BlockPos roundedOrigin = bp.m_7918_(-bp.m_123341_() % 16, -bp.m_123342_() % 16, -bp.m_123343_() % 16);
            FrozenChunk newFrozenChunk = null;
            for (FrozenChunk frozenChunk : FogOfWarClientEvents.frozenChunks) {
                if (!roundedOrigin.equals((Object)frozenChunk.origin)) continue;
                newFrozenChunk = new FrozenChunk(roundedOrigin, this, frozenChunk);
                break;
            }
            if (newFrozenChunk == null) {
                newFrozenChunk = new FrozenChunk(roundedOrigin, this, forceFakeBlocks);
            }
            FogOfWarClientEvents.frozenChunks.add(newFrozenChunk);
        }
    }

    public void unFreezeChunks() {
        if (this.level.f_46443_) {
            for (BlockPos bp : this.getRenderChunkOrigins(true)) {
                for (FrozenChunk fc : FogOfWarClientEvents.frozenChunks) {
                    if (fc.building == null || !fc.building.originPos.equals((Object)this.originPos)) continue;
                    fc.removeOnExplore = true;
                }
            }
        }
    }

    public int getUpgradeLevel() {
        return this.getBuilding().getUpgradeLevel(this);
    }

    public Building getBuilding() {
        return this.building;
    }

    public void changeStructure(String newStructureName) {
        ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocksFromNbt(newStructureName, (LevelAccessor)this.getLevel());
        this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
        this.refreshBlocks();
    }

    private void checkIfCaptured(ServerLevel serverLevel) {
        if (PlayerServerEvents.rtsPlayers.isEmpty()) {
            return;
        }
        List nearbyUnits = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.minCorner.m_123342_(), (double)this.centrePos.m_123343_()), (float)this.getBuilding().captureRange, Mob.class, (Level)serverLevel).stream().toList();
        HashMap<String, Integer> playerPopCounts = new HashMap<String, Integer>();
        boolean ownerHasUnit = false;
        for (Mob mob : nearbyUnits) {
            if (!(mob instanceof Unit)) continue;
            Unit unit = (Unit)mob;
            if (mob instanceof WorkerUnit) continue;
            String uOwner = unit.getOwnerName();
            if (uOwner.equals(this.ownerName) && !this.ownerName.isEmpty()) {
                ownerHasUnit = true;
            }
            if (uOwner.isEmpty()) continue;
            if (!playerPopCounts.containsKey(uOwner)) {
                playerPopCounts.put(uOwner, 0);
            }
            playerPopCounts.put(uOwner, Math.max(1, unit.getCost().population) + (Integer)playerPopCounts.get(uOwner));
        }
        String highestPopPlayer = null;
        int highestPop = 0;
        if (!ownerHasUnit) {
            for (String playerName : playerPopCounts.keySet()) {
                if ((Integer)playerPopCounts.get(playerName) <= highestPop) continue;
                highestPop = (Integer)playerPopCounts.get(playerName);
                highestPopPlayer = playerName;
            }
            if (highestPop > 0 && highestPopPlayer != null) {
                this.ownerName = highestPopPlayer;
                BuildingPlacement buildingPlacement = this;
                if (buildingPlacement instanceof BeaconPlacement) {
                    BeaconPlacement beacon = (BeaconPlacement)buildingPlacement;
                    beacon.sendWarning("capture_warning");
                }
            }
        }
    }

    public String getUpgradedName() {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this.getBuilding());
        if (key == null) {
            return "Unknown";
        }
        return I18n.m_118938_((String)("buildings." + (this.getFaction() != null && this.getFaction() != Faction.NONE ? this.getFaction().toString().toLowerCase() : "neutral") + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
    }

    public float getMagicDamageMult() {
        return this.getBuilding().getMeleeDamageMult();
    }

    public void updateButtons() {
        this.abilities = this.building.getAbilities().get();
        this.abilityButtons = this.building.getAbilities().getButtons(this);
    }

    public void setCooldown(Ability abilityClass, float cooldown) {
        this.cooldowns.put((Object)abilityClass, (Object)Float.valueOf(cooldown));
    }

    public float getCooldown(Ability abilityClass) {
        return ((Float)this.cooldowns.get((Object)abilityClass)).floatValue();
    }

    public void createArmourStandTarget() {
        ArmorStand stand;
        if (this.targetStand != null && !this.targetStand.m_21224_() && !this.targetStand.m_213877_() && this.isPosInsideBuilding(this.targetStand.m_20183_())) {
            return;
        }
        List entities = this.level.m_45976_(ArmorStand.class, new AABB((double)this.minCorner.m_123341_(), (double)this.minCorner.m_123342_(), (double)this.minCorner.m_123343_(), (double)this.maxCorner.m_123341_(), (double)this.maxCorner.m_123342_(), (double)this.maxCorner.m_123343_()));
        if (!entities.isEmpty()) {
            this.targetStand = (ArmorStand)entities.get(0);
        } else if (!this.level.m_5776_() && (stand = (ArmorStand)EntityType.f_20529_.m_20615_(this.level)) != null) {
            stand.m_20242_(true);
            stand.f_19794_ = true;
            stand.m_20219_(this.centrePos.m_252807_());
            this.level.m_7967_((Entity)stand);
            this.targetStand = stand;
        }
    }

    public void setBuilding(Building building) {
        Objects.requireNonNull(building, "Building can't be null");
        this.building = building;
        for (Ability ability : this.getBuilding().getAbilities().get()) {
            this.getAbilities().add(ability);
        }
    }

    public void setCharges(Ability ability, int cooldown) {
        this.charges.put((Object)ability, (Object)cooldown);
    }

    public int getCharges(Ability ability) {
        if (!this.charges.containsKey((Object)ability)) {
            this.charges.put((Object)ability, (Object)ability.maxCharges);
        }
        return (Integer)this.charges.get((Object)ability);
    }

    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }
}

