/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Blocks;

public class SpiderLair
extends ProductionBuilding {
    public static final String buildingName = "Spider Lair";
    public static final String structureName = "spider_lair";
    public static final ResourceCost cost = ResourceCosts.SPIDER_LAIR;

    public SpiderLair() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50033_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/cobweb.png");
        this.startingBlockTypes.add(Blocks.f_152550_);
        this.startingBlockTypes.add(Blocks.f_152551_);
        this.explodeChance = 0.2f;
        this.productions.add(ProductionItems.SPIDER, Keybindings.keyQ);
        this.productions.add(ProductionItems.POISON_SPIDER, Keybindings.keyW);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/cobweb.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.SPIDER_LAIR, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.GRAVEYARD) || ResearchClient.hasCheat("modifythephasevariance"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spider_lair", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spider_lair.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spider_lair.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }
}

