/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBuildingClientEvents {
    public static final ArrayList<CustomBuilding> customBuildings = new ArrayList();
    public static final ArrayList<BlockPos> rtsStructuresToRenderBB = new ArrayList();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static CustomBuilding customBuildingMenu = null;
    private static final ArrayList<Button> renderedButtons = new ArrayList();
    private static final ArrayList<RectZone> hudZones = new ArrayList();

    public static void setCustomBuildingMenu(CustomBuilding customBuilding) {
        customBuildingMenu = customBuildingMenu != customBuilding ? customBuilding : null;
    }

    public static Building getCustomBuilding(String name) {
        for (CustomBuilding customBuilding : customBuildings) {
            if (!customBuilding.name.equals(name)) continue;
            return customBuilding;
        }
        return null;
    }

    public static void registerCustomBuilding(String playerName, String name, Vec3i structureSize, CompoundTag structureNbt) {
        if (CustomBuildingClientEvents.MC.f_91074_ == null || !playerName.isEmpty() && !CustomBuildingClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
            return;
        }
        for (CustomBuilding customBuilding : customBuildings) {
            if (!customBuilding.name.equals(name)) continue;
            CustomBuildingClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("ERROR (client): custom building '" + name + "' already exists")));
            return;
        }
        ArrayList<BuildingBlock> blocks = BuildingBlockData.getBuildingBlocksFromNbt(structureNbt);
        Block portraitBlock = Blocks.f_50272_;
        for (BuildingBlock bb : blocks) {
            BlockState bs = bb.getBlockState();
            if (bs.m_60795_() || !bs.m_60819_().m_76178_()) continue;
            portraitBlock = bs.m_60734_();
        }
        CustomBuilding building = new CustomBuilding(name, structureSize, portraitBlock, structureNbt);
        customBuildings.add(building);
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || CustomBuildingClientEvents.MC.f_91073_ == null) {
            return;
        }
        for (BlockPos bp : rtsStructuresToRenderBB) {
            BlockEntity blockEntity = CustomBuildingClientEvents.MC.f_91073_.m_7702_(bp);
            if (!(blockEntity instanceof RTSStructureBlockEntity)) continue;
            RTSStructureBlockEntity be = (RTSStructureBlockEntity)blockEntity;
            BlockPos pos = be.m_59902_();
            Vec3i size = be.m_155805_();
            MyRenderer.drawLineBox(evt.getPoseStack(), new AABB((double)(bp.m_123341_() + pos.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_()), (double)(bp.m_123341_() + pos.m_123341_() + size.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_() + size.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_() + size.m_123343_())), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        if (customBuildingMenu != null && CustomBuildingClientEvents.MC.f_91080_ instanceof TopdownGui) {
            hudZones.clear();
            renderedButtons.clear();
            int blitX = 100;
            int blitY = 40;
            int width = 290;
            int height = 100;
            MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX, blitY, width, height, -1610612736);
            Button closeButton = new Button("Close Custom Building Menu", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross_square.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> CustomBuildingClientEvents.setCustomBuildingMenu(null), null, List.of());
            closeButton.frameResource = null;
            closeButton.render(evt.getGuiGraphics(), blitX + width - Button.itemIconSize - 12, blitY + 4, evt.getMouseX(), evt.getMouseY());
            renderedButtons.add(closeButton);
            hudZones.add(new RectZone(blitX, blitY, blitX + width, blitY + height));
            evt.getGuiGraphics().m_280488_(Minecraft.m_91087_().f_91062_, "Coming soon: building customisation options!", blitX + 10, blitY + 10, -1);
        }
    }

    public static boolean isMouseOverHud(int mouseX, int mouseY) {
        for (RectZone hudZone : hudZones) {
            if (!hudZone.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        for (Button button : renderedButtons) {
            if (evt.getButton() == 0) {
                button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
                continue;
            }
            if (evt.getButton() != 1) continue;
            button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
    }
}

