/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class CustomBuildingClientboundPacket {
    public String playerName;
    public String name;
    public BlockPos structureSize;
    public CompoundTag structureNbt;

    public static void registerCustomBuilding(CustomBuilding building) {
        CustomBuildingClientboundPacket.registerCustomBuilding("", building);
    }

    public static void registerCustomBuilding(String playerName, CustomBuilding building) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CustomBuildingClientboundPacket(playerName, building.name, new BlockPos(building.structureSize), building.structureNbt));
    }

    public CustomBuildingClientboundPacket(String playerName, String name, BlockPos structureSize, CompoundTag structureNbt) {
        this.playerName = playerName;
        this.name = name;
        this.structureSize = structureSize;
        this.structureNbt = structureNbt;
    }

    public CustomBuildingClientboundPacket(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.name = buffer.m_130277_();
        this.structureSize = buffer.m_130135_();
        this.structureNbt = buffer.m_130260_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        buffer.m_130070_(this.name);
        buffer.m_130064_(this.structureSize);
        buffer.m_130079_(this.structureNbt);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CustomBuildingClientEvents.registerCustomBuilding(this.playerName, this.name, (Vec3i)this.structureSize, this.structureNbt);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

