/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingSave;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class CustomBuildingSaveData
extends SavedData {
    public final ArrayList<CustomBuildingSave> customBuildings = new ArrayList();

    private static CustomBuildingSaveData create() {
        return new CustomBuildingSaveData();
    }

    @Nonnull
    public static CustomBuildingSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return CustomBuildingSaveData.create();
        }
        return (CustomBuildingSaveData)server.m_129783_().m_8895_().m_164861_(CustomBuildingSaveData::load, CustomBuildingSaveData::create, "saved-custom-building-data");
    }

    public static CustomBuildingSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("CustomBuildingSaveData.load");
        CustomBuildingSaveData data = CustomBuildingSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("custombuildings");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag btag = (CompoundTag)ctag;
                String buildingName = btag.m_128461_("buildingName");
                Vec3i structureSize = new Vec3i(btag.m_128451_("structureSizeX"), btag.m_128451_("structureSizeY"), btag.m_128451_("structureSizeZ"));
                CompoundTag structureNbt = btag.m_128469_("structureNbt");
                data.customBuildings.add(new CustomBuildingSave(structureNbt, buildingName, structureSize));
                ReignOfNether.LOGGER.info("CustomBuildingSaveData.load: " + buildingName);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.customBuildings.forEach(b -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("buildingName", b.buildingName);
            cTag.m_128405_("structureSizeX", b.structureSize.m_123341_());
            cTag.m_128405_("structureSizeY", b.structureSize.m_123342_());
            cTag.m_128405_("structureSizeZ", b.structureSize.m_123343_());
            cTag.m_128365_("structureNbt", (Tag)b.structureNbt);
            list.add((Object)cTag);
        });
        tag.m_128365_("custombuildings", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

