/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientboundPacket;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingSave;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingSaveData;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBuildingServerEvents {
    private static final ArrayList<CustomBuilding> customBuildings = new ArrayList();

    public static Building getCustomBuilding(String name) {
        for (CustomBuilding building : customBuildings) {
            if (!building.name.equals(name)) continue;
            return building;
        }
        return null;
    }

    public static boolean createAndRegisterNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof RTSStructureBlockEntity) {
            RTSStructureBlockEntity rtsBe = (RTSStructureBlockEntity)be;
            return CustomBuildingServerEvents.createAndRegisterNewCustomBuilding(structureRL, structureName, level, pos.m_7918_(1, 0, 1), rtsBe.m_155805_());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean createAndRegisterNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos, Vec3i structureSize) {
        CustomBuilding customBuilding;
        StructureTemplateManager manager = level.m_215082_();
        Optional template = manager.m_230407_(structureRL);
        CompoundTag structureNbt = null;
        if (template.isPresent()) {
            structureNbt = ((StructureTemplate)template.get()).m_74618_(new CompoundTag());
        }
        if (structureNbt == null) return false;
        boolean buildingExists = false;
        for (BuildingPlacement existingPlacement : BuildingServerEvents.getBuildings()) {
            if (!existingPlacement.originPos.equals((Object)pos)) continue;
            buildingExists = true;
            break;
        }
        if (buildingExists) {
            PlayerServerEvents.sendMessageToAllPlayers("ERROR (server): cannot register custom building at same origin as another building");
            return false;
        }
        ArrayList<BuildingBlock> blocks = BuildingUtils.getAbsoluteBlockData(BuildingBlockData.getBuildingBlocksFromNbt(structureNbt), (LevelAccessor)level, pos, Rotation.NONE, new Vec3i(1, 0, 1));
        int numSolidBlocks = 0;
        Block portraitBlock = Blocks.f_50272_;
        for (BuildingBlock buildingBlock : blocks) {
            BlockState bs = buildingBlock.getBlockState();
            if (bs.m_60795_() || !bs.m_60819_().m_76178_()) continue;
            ++numSolidBlocks;
            portraitBlock = bs.m_60734_();
        }
        if (numSolidBlocks == 0) {
            PlayerServerEvents.sendMessageToAllPlayers("ERROR (server): cannot register custom building with no solid blocks");
            return false;
        }
        CustomBuilding building = new CustomBuilding(structureName, structureSize, portraitBlock, structureNbt);
        Iterator<CustomBuilding> iterator = customBuildings.iterator();
        do {
            if (!iterator.hasNext()) {
                customBuildings.add(building);
                BuildingPlacement buildingPlacement = new BuildingPlacement(building, (Level)level, pos, Rotation.NONE, "", blocks, false);
                BuildingServerEvents.getBuildings().add(buildingPlacement);
                CustomBuildingClientboundPacket.registerCustomBuilding(building);
                CustomBuildingServerEvents.saveBuildings(level);
                BuildingServerEvents.saveBuildings(level);
                return true;
            }
            customBuilding = iterator.next();
        } while (!customBuilding.name.equals(building.name));
        PlayerServerEvents.sendMessageToAllPlayers("ERROR (server): custom building " + building.name + " already exists");
        return false;
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            CustomBuildingServerEvents.saveBuildings(level);
        }
    }

    public static void saveBuildings(ServerLevel level) {
        CustomBuildingSaveData customBuildingData = CustomBuildingSaveData.getInstance((LevelAccessor)level);
        customBuildingData.customBuildings.clear();
        customBuildings.forEach(b -> customBuildingData.customBuildings.add(new CustomBuildingSave(b.structureNbt, b.name, b.structureSize)));
        customBuildingData.save();
        level.m_8895_().m_78151_();
    }

    public static void loadBuildings(ServerLevel level) {
        CustomBuildingSaveData customBuildingData = CustomBuildingSaveData.getInstance((LevelAccessor)level);
        customBuildingData.customBuildings.forEach(b -> {
            CustomBuilding building = new CustomBuilding(b.buildingName, b.structureSize, Blocks.f_50272_, b.structureNbt);
            customBuildings.add(building);
            ReignOfNether.LOGGER.info("loaded custom building in serverevents: |" + b.buildingName);
        });
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
        if (server == null || !server.m_6982_()) {
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(() -> CustomBuildingServerEvents.syncCustomBuildings(evt.getEntity().m_7755_().getString()));
        } else {
            CustomBuildingServerEvents.syncCustomBuildings(evt.getEntity().m_7755_().getString());
        }
    }

    private static void syncCustomBuildings(String playerName) {
        for (CustomBuilding customBuilding : customBuildings) {
            CustomBuildingClientboundPacket.registerCustomBuilding(playerName, customBuilding);
        }
    }
}

