/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ResourceCostConfigEntry {
    public static final List<ResourceCostConfigEntry> ENTRIES = new ArrayList<ResourceCostConfigEntry>();
    private ForgeConfigSpec.ConfigValue<Integer> FOOD;
    private ForgeConfigSpec.ConfigValue<Integer> WOOD;
    private ForgeConfigSpec.ConfigValue<Integer> ORE;
    private ForgeConfigSpec.ConfigValue<Integer> SECONDS;
    private ForgeConfigSpec.ConfigValue<Integer> POPULATION;
    private final int default_food;
    private final int default_wood;
    private final int default_ore;
    private final int default_seconds;
    private final int default_population;
    public final String id;
    private final String comment;

    private ResourceCostConfigEntry(int food, int wood, int ore, int seconds, int population, ResourceCost associatedCost, String comment) {
        this.default_food = food;
        this.default_wood = wood;
        this.default_ore = ore;
        this.default_seconds = seconds;
        this.default_population = population;
        this.comment = comment;
        this.id = associatedCost.id;
        ENTRIES.add(this);
    }

    public static ResourceCostConfigEntry Unit(int food, int wood, int ore, int seconds, int population, ResourceCost associatedCost, String comment) {
        return new ResourceCostConfigEntry(food, wood, ore, seconds, population, associatedCost, comment);
    }

    public static ResourceCostConfigEntry Research(int food, int wood, int ore, int seconds, ResourceCost associatedCost, String comment) {
        return new ResourceCostConfigEntry(food, wood, ore, seconds, 0, associatedCost, comment);
    }

    public static ResourceCostConfigEntry Building(int food, int wood, int ore, int supply, ResourceCost associatedCost, String comment) {
        return new ResourceCostConfigEntry(food, wood, ore, 0, supply, associatedCost, comment);
    }

    public static ResourceCostConfigEntry Enchantment(int food, int wood, int ore, ResourceCost associatedCost, String comment) {
        return new ResourceCostConfigEntry(food, wood, ore, 0, 0, associatedCost, comment);
    }

    public void define(ForgeConfigSpec.Builder builder) {
        builder.push(this.comment);
        this.FOOD = builder.define("Food cost", (Object)this.default_food);
        this.WOOD = builder.define("Wood cost", (Object)this.default_wood);
        this.ORE = builder.define("Ore cost", (Object)this.default_ore);
        this.SECONDS = builder.define("Time to create", (Object)this.default_seconds);
        this.POPULATION = builder.define("Population value", (Object)this.default_population);
        builder.pop();
    }

    public Integer getFood() {
        return (Integer)this.FOOD.get();
    }

    public Integer getWood() {
        return (Integer)this.WOOD.get();
    }

    public Integer getOre() {
        return (Integer)this.ORE.get();
    }

    public Integer getSeconds() {
        return (Integer)this.SECONDS.get();
    }

    public Integer getPopulation() {
        return (Integer)this.POPULATION.get();
    }
}

