/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.essentialpartnermod;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Draw {
    public final int mouseX;
    public final int mouseY;
    public final GuiGraphics drawContext;
    private static final List<Consumer<Draw>> deferred = new ArrayList<Consumer<Draw>>();

    public Draw(int mouseX, int mouseY, GuiGraphics drawContext) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawContext = drawContext;
    }

    public void rect(int left, int top, int right, int bottom, int color) {
        this.drawContext.m_280509_(left, top, right, bottom, color);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        this.texturedRect(texture, x, y, width, height, u, v, textureWidth, textureHeight, -1);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        this.drawContext.m_280163_(texture, x, y, (float)u, (float)v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void string(String text, int x, int y, int color) {
        this.drawContext.m_280056_(Minecraft.m_91087_().f_91062_, text, x, y, color, false);
    }

    public void string(String text, int x, int y, int color, int shadowColor) {
        this.string(text, x + 1, y + 1, shadowColor);
        this.string(text, x, y, color);
    }

    public void centredString(String text, int centreX, int y, int color, int shadowColor) {
        int width = Minecraft.m_91087_().f_91062_.m_92895_(text);
        this.string(text, centreX - width / 2, y, color, shadowColor);
    }

    public void multilineCentredString(String text, int centreX, int y, int lineSpacing, int color, int shadowColor) {
        for (String line : text.split("\n")) {
            this.centredString(line, centreX, y, color, shadowColor);
            y += lineSpacing;
        }
    }

    public static boolean hovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public boolean hovered(int x, int y, int width, int height) {
        return Draw.hovered(this.mouseX, this.mouseY, x, y, width, height);
    }

    public static void deferred(Consumer<Draw> drawer) {
        deferred.add(drawer);
    }

    public static void flushDeferred(Draw draw) {
        for (Consumer<Draw> drawConsumer : deferred) {
            drawConsumer.accept(draw);
        }
        deferred.clear();
    }
}

