/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.healthbars;

import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;

public class BarState {
    BarStateType barStateType;
    public final int entityId;
    public float amount;
    public float previousAmountDisplay;
    public float previousAmountDelay;
    public float previousAmount;
    public float lastDelay;
    private float animationSpeed = 0.0f;
    private static final float AMOUNT_INDICATOR_DELAY = 10.0f;

    public BarState(int entityId, BarStateType barStateType) {
        this.entityId = entityId;
        this.barStateType = barStateType;
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block11: {
            level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
            if (!(entity instanceof LivingEntity)) break block11;
            livingEntity = (LivingEntity)entity;
            if (!(entity instanceof HeroUnit)) ** GOTO lbl-1000
            heroUnit = (HeroUnit)entity;
            if (this.barStateType == BarStateType.MANA) {
                this.amount = Math.min(heroUnit.getMana(), heroUnit.getMaxMana());
            } else if (this.barStateType == BarStateType.HEALTH) {
                this.amount = Math.min(livingEntity.m_21223_(), livingEntity.m_21233_());
            } else if (this.barStateType == BarStateType.ABSORB) {
                this.amount = Math.min(livingEntity.m_6103_(), MiscUtil.getMaxAbsorptionAmount(livingEntity));
            }
            this.incrementTimers();
            if ((double)this.previousAmount < 0.1) {
                this.reset();
            } else if (this.previousAmount != this.amount) {
                this.handleChange();
            } else if (this.lastDelay == 0.0f) {
                this.reset();
            }
            this.updateAnimations();
        }
    }

    private void reset() {
        this.previousAmount = this.amount;
    }

    private void incrementTimers() {
        if (this.lastDelay > 0.0f) {
            this.lastDelay -= 1.0f;
        }
        if (this.previousAmountDelay > 0.0f) {
            this.previousAmountDelay -= 1.0f;
        }
    }

    private void handleChange() {
        this.lastDelay = 20.0f;
        this.previousAmount = this.amount;
    }

    private void updateAnimations() {
        if (this.previousAmountDelay > 0.0f) {
            float diff = this.previousAmountDisplay - this.amount;
            if (diff > 0.0f) {
                this.animationSpeed = diff / 10.0f;
            }
        } else if (this.previousAmountDelay < 1.0f && this.previousAmountDisplay > this.amount && this.animationSpeed > 0.0f) {
            this.previousAmountDisplay -= this.animationSpeed;
        } else {
            this.previousAmountDisplay = this.amount;
            this.previousAmountDelay = 10.0f;
        }
    }

    public static enum BarStateType {
        HEALTH,
        MANA,
        ABSORB;

    }
}

