/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.ability.abilities.CallToArmsUnit;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.attackwarnings.AttackWarningClientEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.config.ConfigClientEvents;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.ControlGroup;
import com.solegendary.reignofnether.hud.PortraitRendererBuilding;
import com.solegendary.reignofnether.hud.PortraitRendererUnit;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.buttons.ActionButtons;
import com.solegendary.reignofnether.hud.buttons.HelperButtons;
import com.solegendary.reignofnether.hud.buttons.StartButtons;
import com.solegendary.reignofnether.hud.buttons.UnitSpawnButton;
import com.solegendary.reignofnether.hud.playerdisplay.PlayerDisplayClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxActionButtons;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxMenuType;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.NonUnitClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.PoisonSpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.StrayUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.Model;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HudClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static String tempMsg = "";
    private static int tempMsgTicksLeft = 0;
    private static final int TEMP_MSG_TICKS_FADE = 50;
    private static final int TEMP_MSG_TICKS_MAX = 150;
    private static final int MAX_BUTTONS_PER_ROW = 6;
    public static final ArrayList<ControlGroup> controlGroups = new ArrayList(10);
    public static int lastSelCtrlGroupKey = -1;
    private static final ArrayList<Button> buildingButtons = new ArrayList();
    private static final ArrayList<Button> unitButtons = new ArrayList();
    private static final ArrayList<Button> productionButtons = new ArrayList();
    private static final ArrayList<Button> renderedButtons = new ArrayList();
    public static LivingEntity hudSelectedEntity = null;
    public static BuildingPlacement hudSelectedPlacement = null;
    public static PortraitRendererUnit portraitRendererUnit = new PortraitRendererUnit();
    public static PortraitRendererBuilding portraitRendererBuilding = new PortraitRendererBuilding();
    private static RectZone unitPortraitZone = null;
    private static RectZone buildingPortraitZone = null;
    public static int mouseX = 0;
    public static int mouseY = 0;
    private static int mouseLeftDownX = 0;
    private static int mouseLeftDownY = 0;
    private static final int iconBgColour = 0x64000000;
    private static final int frameBgColour = -1610612736;
    private static final ArrayList<RectZone> hudZones = new ArrayList();

    public static void setLowestCdHudEntity() {
        if (UnitClientEvents.getSelectedUnits().isEmpty() || hudSelectedEntity == null) {
            return;
        }
        List<Pair> pairs = UnitClientEvents.getSelectedUnits().stream().map(le -> {
            float totalCd = 0.0f;
            if (le instanceof Unit) {
                Unit unit = (Unit)le;
                for (Ability ability : unit.getAbilities().get()) {
                    totalCd += ability.getCooldown(unit);
                    if (!ability.isCasting(unit)) continue;
                    totalCd += 10.0f;
                }
            }
            return new Pair(le, (Object)Float.valueOf(totalCd));
        }).filter(p -> {
            String str1 = HudClientEvents.getModifiedEntityName((LivingEntity)p.getFirst());
            String str2 = HudClientEvents.getModifiedEntityName(hudSelectedEntity);
            return str1.equals(str2);
        }).sorted(Comparator.comparing(Pair::getSecond)).toList();
        if (!pairs.isEmpty()) {
            HudClientEvents.setHudSelectedEntity((LivingEntity)pairs.get(0).getFirst());
        }
    }

    public static void setHudSelectedEntity(LivingEntity entity) {
        hudSelectedEntity = entity;
    }

    public static String getModifiedEntityName(LivingEntity entity) {
        CreeperUnit cUnit;
        ItemStack itemStack;
        MilitiaUnit militiaUnit;
        if (entity == null) {
            return "";
        }
        Object name = MiscUtil.getSimpleEntityName((Entity)entity);
        if (entity.m_6162_()) {
            name = I18n.m_118938_((String)"units.neutral.reignofnether.baby", (Object[])new Object[0]) + " " + (String)name;
        }
        if (!(entity instanceof Unit)) {
            return ((String)name).toLowerCase();
        }
        if (entity instanceof MilitiaUnit && (militiaUnit = (MilitiaUnit)entity).isUsingBow()) {
            name = I18n.m_118938_((String)"units.villagers.reignofnether.militia_archer", (Object[])new Object[0]);
        }
        if ((itemStack = entity.m_6844_(EquipmentSlot.HEAD)).m_41720_() instanceof BannerItem) {
            name = (String)name + " " + I18n.m_118938_((String)"units.villagers.reignofnether.captain", (Object[])new Object[0]);
        }
        if (entity.m_20197_().size() == 1) {
            Entity passenger = (Entity)entity.m_20197_().get(0);
            if (entity instanceof RavagerUnit && passenger instanceof PillagerUnit) {
                name = I18n.m_118938_((String)"units.villagers.reignofnether.ravager_artillery", (Object[])new Object[0]);
            } else if (entity instanceof PoisonSpiderUnit && (passenger instanceof SkeletonUnit || passenger instanceof StrayUnit)) {
                name = I18n.m_118938_((String)"units.monsters.reignofnether.poison_spider_jockey", (Object[])new Object[0]);
            } else if (entity instanceof SpiderUnit && (passenger instanceof SkeletonUnit || passenger instanceof StrayUnit)) {
                name = I18n.m_118938_((String)"units.monsters.reignofnether.spider_jockey", (Object[])new Object[0]);
            } else if (entity instanceof HoglinUnit && passenger instanceof HeadhunterUnit) {
                name = I18n.m_118938_((String)"units.piglins.reignofnether.hoglin_rider", (Object[])new Object[0]);
            } else {
                String pName = MiscUtil.getSimpleEntityName((Entity)entity.m_20197_().get(0)).replace("_", " ");
                String nameCap = pName.substring(0, 1).toUpperCase() + pName.substring(1);
                name = (String)name + " & " + nameCap;
            }
        }
        if (entity instanceof VillagerUnit) {
            VillagerUnit vUnit = (VillagerUnit)entity;
            switch (vUnit.getUnitProfession()) {
                case FARMER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_farmer", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.farmer", (Object[])new Object[0]);
                    break;
                }
                case LUMBERJACK: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_lumberjack", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.lumberjack", (Object[])new Object[0]);
                    break;
                }
                case MINER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_miner", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.miner", (Object[])new Object[0]);
                    break;
                }
                case MASON: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_mason", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.mason", (Object[])new Object[0]);
                    break;
                }
                case HUNTER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_hunter", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.hunter", (Object[])new Object[0]);
                    break;
                }
                default: {
                    name = I18n.m_118938_((String)"units.villagers.reignofnether.villager", (Object[])new Object[0]);
                }
            }
        }
        if (entity instanceof CreeperUnit && (cUnit = (CreeperUnit)entity).m_7090_()) {
            name = I18n.m_118938_((String)"units.monsters.reignofnether.charged_creeper", (Object[])new Object[0]);
        }
        return name;
    }

    public static void showTemporaryMessage(String msg) {
        HudClientEvents.showTemporaryMessage(msg, 150);
    }

    public static void showTemporaryMessage(String msg, int ticks) {
        tempMsgTicksLeft = ticks;
        tempMsg = msg;
    }

    public static void removeFromControlGroups(int entityId) {
        for (ControlGroup controlGroup : controlGroups) {
            controlGroup.entityIds.removeIf(id -> id == entityId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        void var13_44;
        boolean isSelPlayer;
        void var13_42;
        LivingEntity actionButton52;
        LivingEntity livingEntity;
        Object unitName;
        if (!OrthoviewClientEvents.isEnabled() || !(evt.getScreen() instanceof TopdownGui)) {
            return;
        }
        if (HudClientEvents.MC.f_91073_ == null) {
            return;
        }
        mouseX = evt.getMouseX();
        mouseY = evt.getMouseY();
        int hudStartingXPos = Button.DEFAULT_ICON_FRAME_SIZE * 6 + Button.DEFAULT_ICON_FRAME_SIZE / 2;
        ArrayList<LivingEntity> selUnits = UnitClientEvents.getSelectedUnits();
        ArrayList<BuildingPlacement> selBuildings = BuildingClientEvents.getSelectedBuildings();
        int screenWidth = MC.m_91268_().m_85445_();
        int screenHeight = MC.m_91268_().m_85446_();
        int iconSize = 14;
        int iconFrameSize = Button.DEFAULT_ICON_FRAME_SIZE;
        int buttonsPerRow = (int)Math.ceil((float)(screenWidth - 340) / (float)iconFrameSize);
        buttonsPerRow = Math.min(buttonsPerRow, 8);
        buttonsPerRow = Math.max(buttonsPerRow, 4);
        buildingButtons.clear();
        unitButtons.clear();
        productionButtons.clear();
        renderedButtons.clear();
        hudZones.clear();
        unitPortraitZone = null;
        buildingPortraitZone = null;
        int blitX = hudStartingXPos;
        int blitY = MC.m_91268_().m_85446_();
        int blitXStart = blitX;
        if (selBuildings.size() <= 0) {
            hudSelectedPlacement = null;
        } else if (hudSelectedPlacement == null || selBuildings.size() == 1 || !selBuildings.contains(hudSelectedPlacement)) {
            hudSelectedPlacement = selBuildings.get(0);
        }
        if (hudSelectedPlacement != null) {
            BuildingPlacement buttonsRendered22;
            boolean hudSelBuildingOwned = BuildingClientEvents.getPlayerToBuildingRelationship(hudSelectedPlacement) == Relationship.OWNED || SandboxClientEvents.isSandboxPlayer();
            buildingPortraitZone = portraitRendererBuilding.render(evt.getGuiGraphics(), blitX, blitY -= HudClientEvents.portraitRendererBuilding.frameHeight, hudSelectedPlacement);
            hudZones.add(buildingPortraitZone);
            blitXStart = (blitX += HudClientEvents.portraitRendererBuilding.frameWidth + 10) + 20;
            for (BuildingPlacement building : selBuildings) {
                Object name;
                if (!hudSelBuildingOwned || buildingButtons.size() >= buttonsPerRow * 2) continue;
                Building building2 = building.getBuilding();
                if (building2 instanceof CustomBuilding) {
                    CustomBuilding customBuilding = (CustomBuilding)building2;
                    name = customBuilding.name;
                } else {
                    name = ReignOfNetherRegistries.BUILDING.m_7981_((Object)building.getBuilding()).toString();
                }
                buildingButtons.add(new Button((String)name, iconSize, building.getBuilding().icon, building, () -> hudSelectedPlacement.getBuilding() == building.getBuilding(), () -> false, () -> true, () -> {
                    if (hudSelectedPlacement.getBuilding() == building.getBuilding()) {
                        BuildingClientEvents.clearSelectedBuildings();
                        BuildingClientEvents.addSelectedBuilding(building);
                    } else {
                        hudSelectedPlacement = building;
                    }
                }, null, null));
            }
            if (buildingButtons.size() >= 2) {
                hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), (blitX += 20) - 5, (blitY += 6) - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 20, -1610612736));
                int buttonsRendered22 = 0;
                for (Button buildingButton : buildingButtons) {
                    if (buttonsRendered22 >= buttonsPerRow * 2 - 1 && selBuildings.size() > buttonsPerRow * 2) {
                        int numExtraBuildings = selBuildings.size() - buttonsPerRow * 2 + 1;
                        RectZone plusBuildingsZone = MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), buildingButton.frameResource, blitX, blitY, iconFrameSize, 0x64000000);
                        evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + numExtraBuildings, blitX + iconFrameSize / 2, blitY + 8, 0xFFFFFF);
                        if (!plusBuildingsZone.isMouseOver(mouseX, mouseY)) break;
                        ArrayList<FormattedCharSequence> tooltipLines = new ArrayList<FormattedCharSequence>();
                        int numBuildings = 0;
                        for (int i = selBuildings.size() - numExtraBuildings; i < selBuildings.size(); ++i) {
                            BuildingPlacement placement = selBuildings.get(i);
                            BuildingPlacement nextPlacement = null;
                            Building building = placement.getBuilding();
                            Object nextBuilding = null;
                            ++numBuildings;
                            if (i < selBuildings.size() - 1) {
                                nextPlacement = selBuildings.get(i + 1);
                                nextBuilding = nextPlacement.getBuilding();
                            }
                            if (building == nextBuilding) continue;
                            tooltipLines.add(FormattedCharSequence.m_13714_((String)("x" + numBuildings + " " + I18n.m_118938_((String)ReignOfNetherRegistries.BUILDING.m_7981_(nextBuilding).m_135815_(), (Object[])new Object[0])), (Style)Style.f_131099_));
                            numBuildings = 0;
                        }
                        MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipLines, mouseX, mouseY);
                        break;
                    }
                    buildingButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                    renderedButtons.add(buildingButton);
                    buildingButton.renderHealthBar(evt.getGuiGraphics().m_280168_());
                    blitX += iconFrameSize;
                    if (buttonsRendered22 == buttonsPerRow - 1) {
                        blitX = blitXStart;
                        blitY += iconFrameSize + 6;
                    }
                    ++buttonsRendered22;
                }
            } else if ((hudSelBuildingOwned || !PlayerClientEvents.isRTSPlayer()) && (buttonsRendered22 = hudSelectedPlacement) instanceof ProductionPlacement) {
                ProductionPlacement productionPlacement = (ProductionPlacement)buttonsRendered22;
                blitY = screenHeight - iconFrameSize * 2 - 5;
                for (int i = 0; i < productionPlacement.productionQueue.size(); ++i) {
                    StopProductionButton button = productionPlacement.productionQueue.get((int)i).item.getCancelButton(productionPlacement, i == 0);
                    if (!hudSelBuildingOwned) {
                        button.onLeftClick = () -> {};
                        button.onRightClick = () -> {};
                    }
                    productionButtons.add(button);
                }
                if (productionButtons.size() >= 1) {
                    hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX - 5, blitY - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 15, -1610612736));
                    ActiveProduction firstProdItem = productionPlacement.productionQueue.get(0);
                    float percentageDoneInv = firstProdItem.ticksLeft / (float)firstProdItem.item.getCost((boolean)true, (String)productionPlacement.ownerName).ticks;
                    int colour = 0xFFFFFF;
                    if (!firstProdItem.item.isBelowPopulationSupply(productionPlacement.getLevel(), productionPlacement.ownerName)) {
                        colour = 0xFF0000;
                        if (percentageDoneInv <= 0.0f) {
                            percentageDoneInv = 0.01f;
                        }
                    }
                    evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, Math.round(100.0f - percentageDoneInv * 100.0f) + "% " + HudClientEvents.productionButtons.get((int)0).name, blitX + iconFrameSize + 5, blitY + 2, colour);
                    int buttonsRendered3 = 0;
                    for (Button prodButton : productionButtons) {
                        if (buttonsRendered3 == 0) {
                            prodButton.greyPercent = 1.0f - percentageDoneInv;
                            prodButton.render(evt.getGuiGraphics(), blitX, blitY - 5, mouseX, mouseY);
                            renderedButtons.add(prodButton);
                        } else {
                            if (buttonsRendered3 >= buttonsPerRow && productionButtons.size() > buttonsPerRow + 1) {
                                int numExtraItems = productionButtons.size() - buttonsPerRow;
                                MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), prodButton.frameResource, blitX, blitY + iconFrameSize, iconFrameSize, 0x64000000);
                                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + numExtraItems, blitX + iconFrameSize / 2, blitY + iconFrameSize + 8, 0xFFFFFF);
                                break;
                            }
                            prodButton.render(evt.getGuiGraphics(), blitX, blitY + iconFrameSize, mouseX, mouseY);
                            renderedButtons.add(prodButton);
                            blitX += iconFrameSize;
                        }
                        ++buttonsRendered3;
                    }
                }
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            if (hudSelectedPlacement != null && (hudSelBuildingOwned || !PlayerClientEvents.isRTSPlayer())) {
                if (!HudClientEvents.hudSelectedPlacement.isBuilt && !HelperButtons.buildingCancelButton.isHidden.get().booleanValue()) {
                    HelperButtons.buildingCancelButton.render(evt.getGuiGraphics(), 0, screenHeight - iconFrameSize, mouseX, mouseY);
                    renderedButtons.add(HelperButtons.buildingCancelButton);
                }
                if (HudClientEvents.hudSelectedPlacement.isBuilt || HudClientEvents.hudSelectedPlacement.allowProdWhileBuilding) {
                    BuildingPlacement percentageDoneInv;
                    List<AbilityButton> list;
                    if (!HudClientEvents.hudSelectedPlacement.isBuilt) {
                        blitX += Button.DEFAULT_ICON_FRAME_SIZE;
                    }
                    if ((list = hudSelectedPlacement.getAbilityButtons().stream().filter(b -> (Boolean)b.isHidden.get() == false).toList()).size() > 0) {
                        blitY -= Button.DEFAULT_ICON_FRAME_SIZE;
                    }
                    if ((percentageDoneInv = hudSelectedPlacement) instanceof ProductionPlacement) {
                        ProductionPlacement selProdPlacement = (ProductionPlacement)percentageDoneInv;
                        List<Button> visibleProdButtons = selProdPlacement.productionButtons.stream().filter(b -> b.isHidden.get() == false).toList();
                        if (visibleProdButtons.size() > 6) {
                            blitY -= Button.DEFAULT_ICON_FRAME_SIZE;
                        }
                        int rowButtons = 0;
                        for (Button prodButton : visibleProdButtons) {
                            if (++rowButtons > 6) {
                                rowButtons = 0;
                                blitX = 0;
                                blitY += Button.DEFAULT_ICON_FRAME_SIZE;
                            }
                            prodButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                            productionButtons.add(prodButton);
                            renderedButtons.add(prodButton);
                            blitX += iconFrameSize;
                        }
                    }
                    blitY += Button.DEFAULT_ICON_FRAME_SIZE;
                    blitX = 0;
                    for (AbilityButton abilityButton : list) {
                        if (((Boolean)abilityButton.isHidden.get()).booleanValue()) continue;
                        abilityButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                        renderedButtons.add(abilityButton);
                        blitX += iconFrameSize;
                    }
                }
            }
        } else if (hudSelectedEntity != null && HudClientEvents.portraitRendererUnit.model != null && HudClientEvents.portraitRendererUnit.renderer != null) {
            Unit unit;
            Object zone;
            Objects.requireNonNull(portraitRendererUnit);
            blitY -= 60;
            String name = HudClientEvents.getModifiedEntityName(hudSelectedEntity).replace("_", " ");
            if (hudSelectedEntity.m_8077_()) {
                name = hudSelectedEntity.m_7770_().getString();
            }
            String string = name.substring(0, 1).toUpperCase() + name.substring(1);
            unitPortraitZone = portraitRendererUnit.render(evt.getGuiGraphics(), string, blitX, blitY, hudSelectedEntity);
            hudZones.add(unitPortraitZone);
            LivingEntity abilityButton = hudSelectedEntity;
            if (abilityButton instanceof HeroUnit) {
                HeroUnit heroUnit = (HeroUnit)abilityButton;
                zone = portraitRendererUnit.renderHeroLevelAndExp(evt.getGuiGraphics(), blitX + 1, blitY - 5, mouseX, mouseY, heroUnit);
                hudZones.add((RectZone)zone);
                if (((RectZone)zone).isMouseOver(mouseX, mouseY)) {
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), heroUnit.getHeroLevel() >= 10 ? List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.hero.reignofnether.max_level", (Object[])new Object[0]))) : List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.hero.reignofnether.experience", (Object[])new Object[]{heroUnit.getExpOnCurrentLevel(), heroUnit.getExpToNextlevel()})), MiscUtil.fcs(I18n.m_118938_((String)"hud.hero.reignofnether.experience_warning", (Object[])new Object[0]))), mouseX, mouseY);
                }
            }
            Objects.requireNonNull(portraitRendererUnit);
            blitX += 60;
            zone = hudSelectedEntity;
            if (zone instanceof Unit) {
                Mob mob;
                Unit unit2 = (Unit)zone;
                hudZones.add(portraitRendererUnit.renderStats(evt.getGuiGraphics(), string, blitX, blitY, mouseX, mouseY, unit2));
                blitX += HudClientEvents.portraitRendererUnit.statsWidth;
                int totalRes = Resources.getTotalResourcesFromItems(unit2.getItems()).getTotalValue();
                LivingEntity buttonsRendered3 = hudSelectedEntity;
                if (buttonsRendered3 instanceof Mob && (mob = (Mob)buttonsRendered3).m_21531_() && totalRes > 0) {
                    hudZones.add(portraitRendererUnit.renderResourcesHeld(evt.getGuiGraphics(), blitX, blitY, unit2));
                    if (UnitClientEvents.getPlayerToEntityRelationship(hudSelectedEntity) == Relationship.OWNED || AlliancesClient.canControlAlly(hudSelectedEntity)) {
                        Button returnButton = new Button("Return resources", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/chest.png"), Keybindings.keyD, () -> unit2.getReturnResourcesGoal().getBuildingTarget() != null, () -> false, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.RETURN_RESOURCES_TO_CLOSEST), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.drop_off_resources", (Object[])new Object[0]), (Style)Style.f_131099_)));
                        returnButton.render(evt.getGuiGraphics(), blitX + 10, blitY + 38, mouseX, mouseY);
                        renderedButtons.add(returnButton);
                    }
                }
            } else if (ResourceSources.isHuntableAnimal(hudSelectedEntity)) {
                hudZones.add(portraitRendererUnit.renderResourcesHeld(evt.getGuiGraphics(), blitX, blitY, (Animal)hudSelectedEntity));
                blitX += HudClientEvents.portraitRendererUnit.statsWidth;
            }
            LivingEntity totalRes = hudSelectedEntity;
            blitX = totalRes instanceof Unit && Resources.getTotalResourcesFromItems((unit = (Unit)totalRes).getItems()).getTotalValue() > 0 ? (blitX += HudClientEvents.portraitRendererUnit.statsWidth + 5) : (blitX += 15);
        }
        blitXStart = blitX;
        blitY = screenHeight - iconFrameSize * 2 - 10;
        for (LivingEntity livingEntity2 : selUnits) {
            if (UnitClientEvents.getPlayerToEntityRelationship(livingEntity2) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(livingEntity2) || unitButtons.size() >= buttonsPerRow * 2) continue;
            String unitName2 = MiscUtil.getSimpleEntityName((Entity)livingEntity2);
            String buttonImagePath = livingEntity2.m_20160_() ? "textures/mobheads/" + unitName2 + "_half.png" : "textures/mobheads/" + unitName2 + ".png";
            Button button = new Button(unitName2, iconSize, livingEntity2 instanceof Unit ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)buttonImagePath) : null, livingEntity2, () -> hudSelectedEntity == null || HudClientEvents.getModifiedEntityName(hudSelectedEntity).equals(HudClientEvents.getModifiedEntityName(livingEntity2)), () -> false, () -> true, () -> {
                if (Keybindings.shiftMod.isDown()) {
                    UnitClientEvents.getSelectedUnits().remove(hudSelectedEntity);
                } else if (HudClientEvents.getModifiedEntityName(hudSelectedEntity).equals(HudClientEvents.getModifiedEntityName(livingEntity2))) {
                    UnitClientEvents.clearSelectedUnits();
                    UnitClientEvents.addSelectedUnit(livingEntity2);
                } else {
                    HudClientEvents.setHudSelectedEntity(livingEntity2);
                }
            }, null, List.of(MiscUtil.fcs(MiscUtil.capitaliseAndSpace(HudClientEvents.getModifiedEntityName(livingEntity2)))));
            if (livingEntity2.m_20160_() && livingEntity2 instanceof Unit) {
                String passengerName = MiscUtil.getSimpleEntityName(livingEntity2.m_146895_());
                button.bgIconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)("textures/mobheads/" + passengerName + ".png"));
            }
            unitButtons.add(button);
        }
        if (unitButtons.size() >= 2) {
            hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX - 5, blitY - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 20, -1610612736));
            int buttonsRendered = 0;
            for (Button unitButton : unitButtons) {
                if (buttonsRendered >= buttonsPerRow * 2 - 1 && selUnits.size() > buttonsPerRow * 2) {
                    int numExtraUnits = selUnits.size() - buttonsPerRow * 2 + 1;
                    RectZone plusUnitsZone = MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), unitButton.frameResource, blitX, blitY, iconFrameSize, 0x64000000);
                    evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + numExtraUnits, blitX + iconFrameSize / 2, blitY + 8, 0xFFFFFF);
                    if (!plusUnitsZone.isMouseOver(mouseX, mouseY)) break;
                    ArrayList<FormattedCharSequence> tooltipLines = new ArrayList<FormattedCharSequence>();
                    int numUnits = 0;
                    for (int i = selUnits.size() - numExtraUnits; i < selUnits.size(); ++i) {
                        LivingEntity unit4 = selUnits.get(i);
                        unitName = HudClientEvents.getModifiedEntityName(unit4);
                        String nextUnitName = null;
                        ++numUnits;
                        if (i < selUnits.size() - 1) {
                            LivingEntity nextUnit = selUnits.get(i + 1);
                            nextUnitName = HudClientEvents.getModifiedEntityName(nextUnit);
                        }
                        if (((String)unitName).equals(nextUnitName)) continue;
                        tooltipLines.add(FormattedCharSequence.m_13714_((String)("x" + numUnits + " " + MiscUtil.capitaliseAndSpace((String)unitName)), (Style)Style.f_131099_));
                        numUnits = 0;
                    }
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipLines, mouseX, mouseY);
                    break;
                }
                unitButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(unitButton);
                if (unitButton.iconResource == null) {
                    Object str = unitButton.name.substring(0, 1).toUpperCase();
                    if (unitButton.name.length() > 1) {
                        str = (String)str + unitButton.name.substring(1, 2);
                    }
                    evt.getGuiGraphics().m_280364_(HudClientEvents.MC.f_91062_, MiscUtil.fcs((String)str, true), blitX + unitButton.iconSize / 2 + 4, blitY + unitButton.iconSize / 2, 0xFFFFFF);
                }
                unitButton.renderHealthBar(evt.getGuiGraphics().m_280168_());
                blitX += iconFrameSize;
                if (buttonsRendered == buttonsPerRow - 1) {
                    blitX = blitXStart;
                    blitY += iconFrameSize + 6;
                }
                ++buttonsRendered;
            }
        }
        if (SandboxClientEvents.isSandboxPlayer() && (hudSelectedEntity != null || hudSelectedPlacement != null)) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2;
            ArrayList<Button> actionButtons = new ArrayList<Button>();
            actionButtons.add(SandboxActionButtons.getSetRelationshipButton());
            if (hudSelectedPlacement != null) {
                actionButtons.add(SandboxActionButtons.removeBuildingPlacement);
            }
            if (hudSelectedEntity instanceof AttackerUnit) {
                actionButtons.add(SandboxActionButtons.setAnchor);
                actionButtons.add(SandboxActionButtons.resetToAnchor);
                actionButtons.add(SandboxActionButtons.removeAnchor);
            }
            for (Button actionButton2 : actionButtons) {
                if (actionButton2.isHidden.get().booleanValue()) continue;
                actionButton2.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(actionButton2);
                blitX += iconFrameSize;
            }
        }
        if (selUnits.size() > 0 && (UnitClientEvents.getPlayerToEntityRelationship(selUnits.get(0)) == Relationship.OWNED || !PlayerClientEvents.isRTSPlayer() || NonUnitClientEvents.canControlAllMobs() || AlliancesClient.canControlAlly(selUnits.get(0))) && (livingEntity = hudSelectedEntity) instanceof Unit) {
            Unit unit5 = (Unit)livingEntity;
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            if (hudSelectedEntity instanceof AttackerUnit) {
                arrayList.add(ActionButtons.attack);
            }
            if (hudSelectedEntity instanceof WorkerUnit) {
                arrayList.add(ActionButtons.buildRepair);
                arrayList.add(ActionButtons.gather);
            }
            if (unit5.canGarrison() && GarrisonableBuilding.getGarrison(unit5) == null) {
                arrayList.add(ActionButtons.garrison);
            } else if (GarrisonableBuilding.getGarrison(unit5) != null) {
                arrayList.add(ActionButtons.ungarrison);
            }
            if (!(hudSelectedEntity instanceof WorkerUnit)) {
                arrayList.add(ActionButtons.hold);
            }
            arrayList.add(ActionButtons.stop);
            LivingEntity plusUnitsZone = hudSelectedEntity;
            if (plusUnitsZone instanceof VillagerUnit) {
                VillagerUnit vUnit = (VillagerUnit)plusUnitsZone;
                for (Ability ability : vUnit.getAbilities().get()) {
                    if (!(ability instanceof CallToArmsUnit)) continue;
                    CallToArmsUnit callToArmsUnit = (CallToArmsUnit)ability;
                    arrayList.add(callToArmsUnit.getButton(Keybindings.keyV, vUnit));
                }
            }
            for (Button actionButton3 : arrayList) {
                LivingEntity ability;
                if (actionButton3 == ActionButtons.gather && (ability = hudSelectedEntity) instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)ability;
                    switch (workerUnit.getGatherResourceGoal().getTargetResourceName()) {
                        case NONE: {
                            actionButton3.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/no_gather.png");
                            break;
                        }
                        case FOOD: {
                            actionButton3.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/hoe.png");
                            break;
                        }
                        case WOOD: {
                            actionButton3.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/axe.png");
                            break;
                        }
                        case ORE: {
                            actionButton3.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/pickaxe.png");
                        }
                    }
                    String resourceName = UnitClientEvents.getSelectedUnitResourceTarget().toString();
                    String key = String.format("resources.reignofnether.%s", resourceName.toLowerCase(Locale.ENGLISH));
                    actionButton3.tooltipLines = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.gather_resources", (Object[])new Object[]{I18n.m_118938_((String)key, (Object[])new Object[0])}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.change_target_resource", (Object[])new Object[0]), (Style)Style.f_131099_));
                }
                actionButton3.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(actionButton3);
                blitX += iconFrameSize;
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2 - 4;
            if (TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_INTRO) && (UnitClientEvents.getPlayerToEntityRelationship(selUnits.get(0)) == Relationship.OWNED || !PlayerClientEvents.isRTSPlayer() || ResearchClient.hasCheat("wouldyoukindly")) || AlliancesClient.canControlAlly(selUnits.get(0))) {
                List<Object> abilityButtons = List.of();
                for (LivingEntity livingEntity3 : selUnits) {
                    if (livingEntity3 != hudSelectedEntity) continue;
                    abilityButtons = unit5.getAbilityButtons();
                    break;
                }
                List<Button> unitAbilities = abilityButtons.stream().filter(b -> {
                    if (!(b instanceof AbilityButton)) return true;
                    AbilityButton ab = (AbilityButton)b;
                    if (ab.ability instanceof CallToArmsUnit) return false;
                    return true;
                }).toList();
                int rowsUp = (int)Math.floor((float)(unitAbilities.size() - 1) / 6.0f);
                rowsUp = Math.max(0, rowsUp);
                if (SandboxClientEvents.isSandboxPlayer() && (hudSelectedEntity != null || hudSelectedPlacement != null)) {
                    ++rowsUp;
                }
                blitY -= iconFrameSize * rowsUp;
                int i = 0;
                for (Button button : unitAbilities) {
                    if (button instanceof AbilityButton) {
                        AbilityButton abilityButton = (AbilityButton)button;
                        unitName = abilityButton.ability;
                        if (unitName instanceof HeroAbility) {
                            HeroAbility heroAbility = (HeroAbility)unitName;
                            if (((HeroUnit)unit5).isRankUpMenuOpen() && !HeroAbility.allSkillsLearnt((HeroUnit)unit5)) {
                                Button rankUpButton = heroAbility.getRankUpButton((HeroUnit)unit5);
                                if (rankUpButton.isHidden.get().booleanValue()) continue;
                                rankUpButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                                renderedButtons.add(rankUpButton);
                                blitX += iconFrameSize;
                                if (++i % 6 != 0) continue;
                                blitX = 0;
                                blitY += iconFrameSize;
                                continue;
                            }
                        }
                    }
                    if (button.isHidden.get().booleanValue()) continue;
                    button.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                    renderedButtons.add(button);
                    blitX += iconFrameSize;
                    if (++i % 6 != 0) continue;
                    blitX = 0;
                    blitY += iconFrameSize;
                }
                LivingEntity button = hudSelectedEntity;
                if (button instanceof HeroUnit) {
                    HeroUnit hero = (HeroUnit)button;
                    Button rankUpMenuButton = HeroAbility.getRankUpMenuButton(hero);
                    if (!rankUpMenuButton.isHidden.get().booleanValue()) {
                        rankUpMenuButton.render(evt.getGuiGraphics(), 0, blitY - iconFrameSize, mouseX, mouseY);
                        renderedButtons.add(rankUpMenuButton);
                    }
                }
            }
        } else if (HudClientEvents.MC.f_91074_ != null && SandboxClientEvents.isSandboxPlayer(HudClientEvents.MC.f_91074_.m_7755_().getString()) && selUnits.isEmpty() && selBuildings.isEmpty()) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            arrayList.add(SandboxClientEvents.getCycleBuildingOrUnitsButton());
            arrayList.add(SandboxClientEvents.getToggleFactionButton());
            arrayList.add(SandboxClientEvents.getToggleRelationshipButton());
            if (SandboxClientEvents.sandboxMenuType == SandboxMenuType.UNITS) {
                arrayList.add(SandboxClientEvents.getToggleUnitCheatsButton());
            } else {
                arrayList.add(SandboxClientEvents.getToggleBuildingCheatsButton());
            }
            arrayList.add(SandboxClientEvents.getToggleNonUnitControlButton());
            for (Button actionButton4 : arrayList) {
                actionButton4.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(actionButton4);
                blitX += iconFrameSize;
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2 - 4;
            List<UnitSpawnButton> abilityButtons = switch (SandboxClientEvents.sandboxMenuType) {
                default -> throw new IncompatibleClassChangeError();
                case SandboxMenuType.UNITS -> List.copyOf(SandboxClientEvents.getUnitButtons());
                case SandboxMenuType.BUILDINGS -> List.copyOf(SandboxClientEvents.getBuildingButtons());
                case SandboxMenuType.CUSTOM_BUILDINGS -> List.copyOf(SandboxClientEvents.getCustomBuildingButtons());
            };
            List<Button> shownAbilities = abilityButtons.stream().filter(b -> {
                if (b.isHidden.get() != false) return false;
                if (!(b instanceof AbilityButton)) return true;
                AbilityButton ab = (AbilityButton)b;
                if (ab.ability instanceof CallToArmsUnit) return false;
                return true;
            }).toList();
            int rowsUp = (int)Math.floor((float)(shownAbilities.size() - 1) / 6.0f);
            rowsUp = Math.max(0, rowsUp);
            if (SandboxClientEvents.isSandboxPlayer() && (hudSelectedEntity != null || hudSelectedPlacement != null)) {
                ++rowsUp;
            }
            blitY -= iconFrameSize * rowsUp;
            int i = 0;
            for (Button button : shownAbilities) {
                if (button.isHidden.get().booleanValue()) continue;
                button.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(button);
                blitX += iconFrameSize;
                if (++i % 6 != 0) continue;
                blitX = 0;
                blitY += iconFrameSize;
            }
        } else if (!(hudSelectedEntity instanceof Unit) && !UnitClientEvents.getSelectedUnits().isEmpty() && NonUnitClientEvents.canControlAllMobs()) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            if (NonUnitClientEvents.canAttack(UnitClientEvents.getSelectedUnits().get(0))) {
                arrayList.add(ActionButtons.attack);
            }
            arrayList.add(ActionButtons.stop);
            for (Button actionButton52 : arrayList) {
                actionButton52.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(actionButton52);
                blitX += iconFrameSize;
            }
        }
        Resources resources = null;
        Object var13_38 = null;
        if (!UnitClientEvents.getSelectedUnits().isEmpty() && (actionButton52 = UnitClientEvents.getSelectedUnits().get(0)) instanceof Unit) {
            Unit unit6 = (Unit)actionButton52;
            String string = unit6.getOwnerName();
        }
        if (!BuildingClientEvents.getSelectedBuildings().isEmpty()) {
            String string = BuildingClientEvents.getSelectedBuildings().get((int)0).ownerName;
        }
        boolean alliedWithSelPlayer = HudClientEvents.MC.f_91074_ != null && AlliancesClient.isAllied(HudClientEvents.MC.f_91074_.m_7755_().getString(), (String)var13_42);
        boolean bl = isSelPlayer = HudClientEvents.MC.f_91074_ != null && HudClientEvents.MC.f_91074_.m_7755_().getString().equals(var13_42);
        if (HudClientEvents.MC.f_91074_ != null && !isSelPlayer && PlayerClientEvents.isRTSPlayer() && var13_42 == null) {
            String string = HudClientEvents.MC.f_91074_.m_7755_().getString();
            isSelPlayer = true;
        }
        if (var13_44 != null && (isSelPlayer || alliedWithSelPlayer || !PlayerClientEvents.isRTSPlayer() || SandboxClientEvents.isSandboxPlayer())) {
            resources = ResourcesClientEvents.getResources((String)var13_44);
        }
        blitX = 0;
        blitY = 0;
        if ((!PlayerClientEvents.isRTSPlayer() || alliedWithSelPlayer || SandboxClientEvents.isSandboxPlayer()) && !isSelPlayer) {
            if (resources != null) {
                evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, I18n.m_118938_((String)"hud.reignofnether.players_resources", (Object[])new Object[]{var13_44}), blitX + 5, blitY + 5, 0xFFFFFF);
            } else if (!TutorialClientEvents.isEnabled()) {
                evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, I18n.m_118938_((String)"hud.reignofnether.you_are_spectator", (Object[])new Object[0]), blitX + 5, blitY + 5, 0xFFFFFF);
                blitY += 10;
            }
            blitY += 20;
        }
        int resourceBlitYStart = blitY;
        if (resources != null && HudClientEvents.MC.f_91074_ != null) {
            for (String resourceName : new String[]{"food", "wood", "ore", "pop"}) {
                ResourceLocation rl;
                Object resValueStr = "";
                ResourceName resName = switch (resourceName) {
                    case "food" -> {
                        rl = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wheat.png");
                        resValueStr = String.valueOf(resources.food);
                        yield ResourceName.FOOD;
                    }
                    case "wood" -> {
                        rl = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wood.png");
                        resValueStr = String.valueOf(resources.wood);
                        yield ResourceName.WOOD;
                    }
                    case "ore" -> {
                        rl = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/iron_ore.png");
                        resValueStr = String.valueOf(resources.ore);
                        yield ResourceName.ORE;
                    }
                    default -> {
                        rl = PlayerColors.getPlayerColorBedIcon((String)var13_44);
                        resValueStr = UnitClientEvents.getCurrentPopulation((String)var13_44) + "/" + BuildingClientEvents.getTotalPopulationSupply((String)var13_44);
                        yield ResourceName.NONE;
                    }
                };
                hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX + iconFrameSize - 1, blitY, 49, iconFrameSize, -1610612736));
                hudZones.add(MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame.png"), blitX, blitY, iconFrameSize, 0x64000000));
                MyRenderer.renderIcon(evt.getGuiGraphics(), rl, blitX + 4, blitY + 4, iconSize);
                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, (String)resValueStr, blitX + iconFrameSize + 24, blitY + iconSize / 2 + 1, 0xFFFFFF);
                void finalSelPlayerName = var13_44;
                int numWorkersHunting = UnitClientEvents.getAllUnits().stream().filter(arg_0 -> HudClientEvents.lambda$onDrawScreen$21((String)finalSelPlayerName, arg_0)).toList().size();
                int numWorkersAssigned = 0;
                if (resName == ResourceName.NONE) {
                    numWorkersAssigned = UnitClientEvents.getAllUnits().stream().filter(arg_0 -> HudClientEvents.lambda$onDrawScreen$22((String)finalSelPlayerName, arg_0)).toList().size();
                } else {
                    for (LivingEntity le2 : UnitClientEvents.getAllUnits()) {
                        if (!(le2 instanceof Unit)) continue;
                        Unit u2 = (Unit)le2;
                        if (!(le2 instanceof WorkerUnit)) continue;
                        WorkerUnit wu = (WorkerUnit)le2;
                        if (!u2.getOwnerName().equals(finalSelPlayerName) || UnitClientEvents.idleWorkerIds.contains(le2.m_19879_())) continue;
                        boolean alreadyAssigned = false;
                        if (u2.getReturnResourcesGoal() != null) {
                            Resources res = Resources.getTotalResourcesFromItems(u2.getItems());
                            if (resName == ResourceName.FOOD && res.food > 0 || resName == ResourceName.WOOD && res.wood > 0 || resName == ResourceName.ORE && res.ore > 0) {
                                ++numWorkersAssigned;
                                alreadyAssigned = true;
                            }
                        }
                        if (alreadyAssigned || !wu.getGatherResourceGoal().getTargetResourceName().equals((Object)resName)) continue;
                        ++numWorkersAssigned;
                    }
                }
                if (resName == ResourceName.FOOD) {
                    numWorkersAssigned += numWorkersHunting;
                }
                hudZones.add(MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame.png"), blitX + 69, blitY, iconFrameSize, 0x64000000));
                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, String.valueOf(numWorkersAssigned), blitX + 69 + iconFrameSize / 2, blitY + iconSize / 2 + 1, 0xFFFFFF);
                blitY += iconFrameSize - 1;
            }
            blitY = resourceBlitYStart;
            void finalSelPlayerName = var13_44;
            for (String resourceName : new String[]{"food", "wood", "ore", "population"}) {
                String locName = I18n.m_118938_((String)("resources.reignofnether." + resourceName), (Object[])new Object[0]);
                String key = String.format("resources.reignofnether.%s", resourceName);
                List<FormattedCharSequence> tooltip = resourceName.equals("population") ? List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.max_resources", (Object[])new Object[]{I18n.m_118938_((String)key, (Object[])new Object[0]), GameruleClient.maxPopulation}), (Style)Style.f_131099_)) : List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)key, (Object[])new Object[0]), (Style)Style.f_131099_));
                if (mouseX >= blitX && mouseY >= blitY && mouseX < blitX + iconFrameSize && mouseY < blitY + iconFrameSize) {
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltip, mouseX + 5, mouseY);
                }
                if (mouseX >= blitX + 69 && mouseY >= blitY && mouseX < blitX + 69 + iconFrameSize && mouseY < blitY + iconFrameSize) {
                    List<FormattedCharSequence> tooltipWorkersAssigned;
                    if (resourceName.equals("population")) {
                        int numWorkers = UnitClientEvents.getAllUnits().stream().filter(arg_0 -> HudClientEvents.lambda$onDrawScreen$23((String)finalSelPlayerName, arg_0)).toList().size();
                        tooltipWorkersAssigned = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.total_workers", (Object[])new Object[]{numWorkers}), (Style)Style.f_131099_));
                    } else {
                        tooltipWorkersAssigned = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)("hud.reignofnether.workers_on_" + resourceName), (Object[])new Object[0]), (Style)Style.f_131099_));
                    }
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipWorkersAssigned, mouseX + 5, mouseY);
                }
                blitY += iconFrameSize - 1;
            }
        }
        if (tempMsgTicksLeft > 0 && tempMsg.length() > 0) {
            int ticksUnderFade = Math.min(tempMsgTicksLeft, 50);
            int alpha = (int)(255.0f * ((float)ticksUnderFade / 50.0f));
            evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, tempMsg, screenWidth / 2, screenHeight - iconFrameSize * 2 - 50, 0xFFFFFF + (alpha << 24));
        }
        if (tempMsgTicksLeft > 0) {
            --tempMsgTicksLeft;
        }
        blitX = 100;
        for (ControlGroup controlGroup : controlGroups) {
            controlGroup.clean();
            if (controlGroup.isEmpty()) continue;
            Button ctrlGroupButton = controlGroup.getButton();
            ctrlGroupButton.render(evt.getGuiGraphics(), blitX, 0, mouseX, mouseY);
            renderedButtons.add(ctrlGroupButton);
            blitX += iconFrameSize;
        }
        Button attackWarningButton = AttackWarningClientEvents.getWarningButton();
        if (!attackWarningButton.isHidden.get().booleanValue()) {
            attackWarningButton.render(evt.getGuiGraphics(), screenWidth - MinimapClientEvents.getMapGuiRadius() * 2 - 20 - 14, screenHeight - MinimapClientEvents.getMapGuiRadius() - 20 - 2, mouseX, mouseY);
            renderedButtons.add(attackWarningButton);
        }
        Button toggleMapSizeButton = MinimapClientEvents.getToggleSizeButton();
        if (!toggleMapSizeButton.isHidden.get().booleanValue()) {
            toggleMapSizeButton.render(evt.getGuiGraphics(), screenWidth - toggleMapSizeButton.iconSize * 2, screenHeight - toggleMapSizeButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(toggleMapSizeButton);
        }
        Button camSensitivityButton = MinimapClientEvents.getCamSensitivityButton();
        if (!camSensitivityButton.isHidden.get().booleanValue()) {
            camSensitivityButton.render(evt.getGuiGraphics(), screenWidth - camSensitivityButton.iconSize * 4, screenHeight - camSensitivityButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(camSensitivityButton);
        }
        Button mapLockButton = MinimapClientEvents.getMapLockButton();
        if (!mapLockButton.isHidden.get().booleanValue()) {
            mapLockButton.render(evt.getGuiGraphics(), screenWidth - mapLockButton.iconSize * 2, screenHeight - mapLockButton.iconSize * 4, mouseX, mouseY);
            renderedButtons.add(mapLockButton);
        }
        Button nightCirclesButton = MinimapClientEvents.getNightCirclesModeButton();
        if (!nightCirclesButton.isHidden.get().booleanValue()) {
            nightCirclesButton.render(evt.getGuiGraphics(), screenWidth - nightCirclesButton.iconSize * 4, screenHeight - nightCirclesButton.iconSize * 4, mouseX, mouseY);
            renderedButtons.add(nightCirclesButton);
        }
        Button leavesHidingButton = OrthoviewClientEvents.getLeavesHidingButton();
        if (!leavesHidingButton.isHidden.get().booleanValue()) {
            leavesHidingButton.render(evt.getGuiGraphics(), screenWidth - leavesHidingButton.iconSize * 6, screenHeight - leavesHidingButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(leavesHidingButton);
        }
        Button toggleTeamColorsButton = PlayerColors.getToggleTeamColorsButton();
        if (!toggleTeamColorsButton.isHidden.get().booleanValue()) {
            toggleTeamColorsButton.render(evt.getGuiGraphics(), screenWidth - toggleTeamColorsButton.iconSize * 6, screenHeight - toggleTeamColorsButton.iconSize * 4, mouseX, mouseY);
            renderedButtons.add(toggleTeamColorsButton);
        }
        Button rotateCW = MinimapClientEvents.getCameraRotateCWButton();
        if (!rotateCW.isHidden.get().booleanValue()) {
            rotateCW.render(evt.getGuiGraphics(), screenWidth - rotateCW.iconSize * (MinimapClientEvents.isLargeMap() ? 8 : 4), screenHeight - rotateCW.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(rotateCW);
        }
        Button rotateCCW = MinimapClientEvents.getCameraRotateCCWButton();
        if (!rotateCCW.isHidden.get().booleanValue()) {
            rotateCCW.render(evt.getGuiGraphics(), screenWidth - rotateCCW.iconSize * (MinimapClientEvents.isLargeMap() ? 10 : 6), screenHeight - rotateCCW.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(rotateCCW);
        }
        if (!PlayerClientEvents.isRTSPlayer() && !PlayerClientEvents.rtsLocked) {
            Button gamemodeButton;
            Button startPosButton = StartPosClientEvents.getPositionsButton();
            if (!startPosButton.isHidden.get().booleanValue()) {
                startPosButton.render(evt.getGuiGraphics(), screenWidth - 84, 40, mouseX, mouseY);
                renderedButtons.add(startPosButton);
            }
            Button startButton = StartPosClientEvents.getStartButton();
            if (!startButton.isHidden.get().booleanValue()) {
                startButton.render(evt.getGuiGraphics(), screenWidth - 56, 40, mouseX, mouseY);
                renderedButtons.add(startButton);
            }
            Button cancelStartButton = StartPosClientEvents.getCancelStartButton();
            if (!cancelStartButton.isHidden.get().booleanValue()) {
                cancelStartButton.render(evt.getGuiGraphics(), screenWidth - 56, 40, mouseX, mouseY);
                renderedButtons.add(cancelStartButton);
            }
            Button diffsButton = ConfigClientEvents.getDiffsButton();
            if (!diffsButton.isHidden.get().booleanValue()) {
                diffsButton.render(evt.getGuiGraphics(), screenWidth - 140, 7, mouseX, mouseY);
                renderedButtons.add(diffsButton);
            }
            if ((gamemodeButton = ClientGameModeHelper.getButton()) != null && !gamemodeButton.isHidden.get().booleanValue() && !TutorialClientEvents.isEnabled()) {
                gamemodeButton.render(evt.getGuiGraphics(), screenWidth - 112, 7, mouseX, mouseY);
                renderedButtons.add(gamemodeButton);
            }
            Button gamerulesButton = GameruleClient.getGamerulesButton();
            if (HudClientEvents.MC.f_91074_ != null && !gamerulesButton.isHidden.get().booleanValue() && !TutorialClientEvents.isEnabled()) {
                int xr = screenWidth - 112;
                int yr = 40;
                gamerulesButton.render(evt.getGuiGraphics(), xr, yr, mouseX, mouseY);
                renderedButtons.add(gamerulesButton);
                if (GameruleClient.gamerulesMenuOpen) {
                    List<Button> gameruleButtons = GameruleClient.renderGamerulesGUI(evt.getGuiGraphics(), xr, yr, mouseX, mouseY);
                    renderedButtons.addAll(gameruleButtons);
                }
            }
            if (ClientGameModeHelper.gameMode != GameMode.SANDBOX) {
                if (!StartPosClientEvents.isEnabled()) {
                    if (!StartButtons.villagerStartButton.isHidden.get().booleanValue()) {
                        StartButtons.villagerStartButton.render(evt.getGuiGraphics(), screenWidth - 84, 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.villagerStartButton);
                    }
                    if (!StartButtons.monsterStartButton.isHidden.get().booleanValue()) {
                        StartButtons.monsterStartButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.monsterStartButton);
                    }
                    if (!StartButtons.piglinStartButton.isHidden.get().booleanValue()) {
                        StartButtons.piglinStartButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.piglinStartButton);
                    }
                } else {
                    if (!StartPosClientEvents.villagerReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.villagerReadyButton.render(evt.getGuiGraphics(), screenWidth - 84, 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.villagerReadyButton);
                    }
                    if (!StartPosClientEvents.monsterReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.monsterReadyButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.monsterReadyButton);
                    }
                    if (!StartPosClientEvents.piglinReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.piglinReadyButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.piglinReadyButton);
                    }
                }
            } else if (!StartButtons.sandboxStartButton.isHidden.get().booleanValue()) {
                StartButtons.sandboxStartButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                renderedButtons.add(StartButtons.sandboxStartButton);
            }
        } else if (SurvivalClientEvents.isEnabled) {
            Button nextWaveButton = SurvivalClientEvents.getNextWaveButton();
            if (!nextWaveButton.isHidden.get().booleanValue()) {
                nextWaveButton.tooltipOffsetY = 15;
                nextWaveButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                renderedButtons.add(nextWaveButton);
            }
        } else if (SandboxClientEvents.isSandboxPlayer(HudClientEvents.MC.f_91074_.m_7755_().getString())) {
            Button exitButton = SandboxClientEvents.getExitSandboxButton();
            if (!exitButton.isHidden.get().booleanValue()) {
                exitButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 28.0f), 7, mouseX, mouseY);
                renderedButtons.add(exitButton);
            }
        }
        BeaconPlacement beacon = BuildingUtils.getBeacon(true);
        if (beacon != null) {
            Button beaconButton = HelperButtons.getBeaconButton(beacon.ownerName);
            int xi = screenWidth - 28;
            if (!PlayerDisplayClientEvents.observerButton.isHidden.get().booleanValue() || !PlayerDisplayClientEvents.diplomacyButton.isHidden.get().booleanValue()) {
                xi = screenWidth - 56;
            }
            if (!beaconButton.isHidden.get().booleanValue()) {
                beaconButton.tooltipOffsetY = 15;
                beaconButton.render(evt.getGuiGraphics(), xi, 40, mouseX, mouseY);
                renderedButtons.add(beaconButton);
            }
        }
        if (!TutorialClientEvents.helpButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.chatButton.iconSize * 2;
            int yi = 40;
            TutorialClientEvents.helpButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(TutorialClientEvents.helpButton);
        } else if (!PlayerDisplayClientEvents.observerButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - PlayerDisplayClientEvents.observerButton.iconSize * 2;
            int yi = 40;
            PlayerDisplayClientEvents.observerButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(PlayerDisplayClientEvents.observerButton);
        } else if (!PlayerDisplayClientEvents.diplomacyButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - PlayerDisplayClientEvents.diplomacyButton.iconSize * 2;
            int yi = 40;
            PlayerDisplayClientEvents.diplomacyButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(PlayerDisplayClientEvents.diplomacyButton);
        } else {
            PlayerDisplayClientEvents.resetDisplay();
        }
        if (!HelperButtons.chatButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.chatButton.iconSize * 2;
            int yi = 70;
            HelperButtons.chatButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(HelperButtons.chatButton);
        }
        if (!HelperButtons.armyButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.armyButton.iconSize * 2;
            int yi = 100;
            HelperButtons.armyButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(HelperButtons.armyButton);
        }
        if (!HelperButtons.idleWorkerButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.idleWorkerButton.iconSize * 2;
            int yi = 130;
            HelperButtons.idleWorkerButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, String.valueOf(UnitClientEvents.idleWorkerIds.size()), xi + 2, yi + HelperButtons.idleWorkerButton.iconSize - 1, 0xFFFFFF);
            renderedButtons.add(HelperButtons.idleWorkerButton);
        }
        for (Button button : renderedButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            button.renderTooltip(evt.getGuiGraphics(), mouseX, mouseY);
        }
        TutorialClientEvents.checkAndRenderNextAction(evt.getGuiGraphics(), renderedButtons);
    }

    public static boolean isMouseOverAnyButton() {
        for (Button button : renderedButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseOverAnyButtonOrHud() {
        for (RectZone hudZone : hudZones) {
            if (!hudZone.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        if (MinimapClientEvents.isPointInsideMinimap(mouseX, mouseY)) {
            return true;
        }
        if (PlayerDisplayClientEvents.isMouseOverHud(mouseX, mouseY)) {
            return true;
        }
        if (CustomBuildingClientEvents.isMouseOverHud(mouseX, mouseY)) {
            return true;
        }
        return HudClientEvents.isMouseOverAnyButton();
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        for (Button button : renderedButtons) {
            if (evt.getButton() == 0) {
                button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
                continue;
            }
            if (evt.getButton() != 1) continue;
            button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
        if (evt.getButton() == 0) {
            mouseLeftDownX = (int)evt.getMouseX();
            mouseLeftDownY = (int)evt.getMouseY();
        }
    }

    @SubscribeEvent
    public static void onKeyRelease(ScreenEvent.KeyReleased.Post evt) {
        if (HudClientEvents.MC.f_91080_ == null || !HudClientEvents.MC.f_91080_.m_96636_().getString().contains("topdowngui_container")) {
            return;
        }
        for (Button button : renderedButtons) {
            button.checkPressed(evt.getKeyCode());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled()) {
            portraitRendererUnit.tickAnimation();
        }
        if (MiscUtil.isLeftClickDown(MC)) {
            if (buildingPortraitZone != null && buildingPortraitZone.isMouseOver(mouseX, mouseY) && buildingPortraitZone.isMouseOver(mouseLeftDownX, mouseLeftDownY) && HudClientEvents.MC.f_91074_ != null && hudSelectedPlacement != null) {
                BlockPos pos = HudClientEvents.hudSelectedPlacement.centrePos;
                OrthoviewClientEvents.centreCameraOnPos(pos);
            } else if (unitPortraitZone != null && unitPortraitZone.isMouseOver(mouseX, mouseY) && unitPortraitZone.isMouseOver(mouseLeftDownX, mouseLeftDownY) && HudClientEvents.MC.f_91074_ != null) {
                OrthoviewClientEvents.centreCameraOnPos(hudSelectedEntity.m_20182_());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEntity(RenderLivingEvent.Post<? extends LivingEntity, ? extends Model> evt) {
        ArrayList<LivingEntity> units;
        if (hudSelectedEntity != null && hudSelectedEntity.m_213877_()) {
            hudSelectedEntity = null;
        }
        if ((units = UnitClientEvents.getSortedSelectedUnits()).size() <= 0) {
            HudClientEvents.setHudSelectedEntity(null);
        } else if (hudSelectedEntity == null || units.size() == 1 || !units.contains(hudSelectedEntity)) {
            HudClientEvents.setHudSelectedEntity(units.get(0));
        }
        if (hudSelectedEntity == null) {
            HudClientEvents.portraitRendererUnit.model = null;
            HudClientEvents.portraitRendererUnit.renderer = null;
        } else if (evt.getEntity() == hudSelectedEntity) {
            HudClientEvents.portraitRendererUnit.model = evt.getRenderer().m_7200_();
            HudClientEvents.portraitRendererUnit.renderer = evt.getRenderer();
        }
    }

    @SubscribeEvent
    public static void onRenderNamePlate(RenderNameTagEvent evt) {
    }

    @SubscribeEvent
    public static void onKeyPress(ScreenEvent.KeyPressed.Pre evt) {
        if (!(HudClientEvents.MC.f_91080_ instanceof TopdownGui)) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled()) {
            for (Keybinding numKey : Keybindings.nums) {
                if (numKey.key != evt.getKeyCode()) continue;
                evt.setCanceled(true);
            }
        }
        if (evt.getKeyCode() == Keybindings.deselect.key) {
            UnitClientEvents.clearSelectedUnits();
            BuildingClientEvents.clearSelectedBuildings();
            BuildingClientEvents.setBuildingToPlace(null);
        }
        if (controlGroups.size() < Keybindings.nums.length) {
            controlGroups.clear();
            for (Keybinding keybinding : Keybindings.nums) {
                controlGroups.add(new ControlGroup());
            }
        }
        for (Keybinding keybinding : Keybindings.nums) {
            int index = Integer.parseInt(keybinding.buttonLabel);
            if (index < 0 || index >= controlGroups.size() || evt.getKeyCode() != keybinding.key) continue;
            if (Keybindings.ctrlMod.isDown()) {
                controlGroups.get(index).saveFromSelected(keybinding, true);
                continue;
            }
            if (Keybindings.shiftMod.isDown()) {
                controlGroups.get(index).saveFromSelected(keybinding, false);
                continue;
            }
            if (!Keybindings.altMod.isDown()) continue;
            for (ControlGroup controlGroup : controlGroups) {
                for (LivingEntity le : UnitClientEvents.getSelectedUnits()) {
                    controlGroup.entityIds.removeIf(id -> id.intValue() == le.m_19879_());
                }
                for (BuildingPlacement bpl : BuildingClientEvents.getSelectedBuildings()) {
                    controlGroup.buildingBps.removeIf(bp -> bp.equals((Object)bpl.originPos));
                }
            }
            controlGroups.get(index).saveFromSelected(keybinding, true);
        }
        if (OrthoviewClientEvents.isEnabled() && evt.getKeyCode() == Keybindings.chat.key) {
            MC.m_91152_((Screen)new ChatScreen(""));
        }
        if (evt.getKeyCode() == Keybindings.tab.key) {
            HudClientEvents.cycleUnitSubgroups();
            HudClientEvents.cycleBuildingSubgroups();
        }
    }

    private static void cycleUnitSubgroups() {
        ArrayList<LivingEntity> selUnits = UnitClientEvents.getSortedSelectedUnits();
        List unitNames = selUnits.stream().map(HudClientEvents::getModifiedEntityName).distinct().collect(Collectors.toList());
        if (unitNames.size() <= 1 || hudSelectedEntity == null) {
            return;
        }
        boolean reversed = Keybindings.shiftMod.isDown();
        String selUnitName = HudClientEvents.getModifiedEntityName(hudSelectedEntity);
        if (reversed) {
            Collections.reverse(unitNames);
        }
        String newUnitName = "";
        boolean foundSelected = false;
        for (String uname : unitNames) {
            if (foundSelected) {
                newUnitName = uname;
                break;
            }
            if (!uname.equals(selUnitName)) continue;
            foundSelected = true;
        }
        if (newUnitName.isBlank() && !selUnits.isEmpty()) {
            if (reversed) {
                HudClientEvents.setHudSelectedEntity((LivingEntity)selUnits.get(selUnits.size() - 1));
            } else {
                HudClientEvents.setHudSelectedEntity((LivingEntity)selUnits.get(0));
            }
        } else {
            for (LivingEntity le : selUnits) {
                String bplName = HudClientEvents.getModifiedEntityName(le);
                if (!bplName.equals(newUnitName)) continue;
                HudClientEvents.setHudSelectedEntity(le);
                break;
            }
        }
    }

    private static void cycleBuildingSubgroups() {
        ArrayList<BuildingPlacement> selBuildings = BuildingClientEvents.getSelectedBuildings();
        List buildingNames = selBuildings.stream().map(b -> ReignOfNetherRegistries.BUILDING.m_7981_((Object)b.getBuilding()).toString()).distinct().sorted(Comparator.comparing(b -> b)).collect(Collectors.toList());
        if (buildingNames.size() <= 1 || hudSelectedPlacement == null) {
            return;
        }
        boolean reversed = Keybindings.shiftMod.isDown();
        String selBuildingName = ReignOfNetherRegistries.BUILDING.m_7981_((Object)hudSelectedPlacement.getBuilding()).toString();
        if (reversed) {
            Collections.reverse(buildingNames);
        }
        String newBuildingName = "";
        boolean foundSelected = false;
        for (String bname : buildingNames) {
            if (foundSelected) {
                newBuildingName = bname;
                break;
            }
            if (!bname.equals(selBuildingName)) continue;
            foundSelected = true;
        }
        if (newBuildingName.isBlank() && !selBuildings.isEmpty()) {
            hudSelectedPlacement = reversed ? (BuildingPlacement)selBuildings.get(selBuildings.size() - 1) : (BuildingPlacement)selBuildings.get(0);
        } else {
            for (BuildingPlacement bpl : selBuildings) {
                String bplName = ReignOfNetherRegistries.BUILDING.m_7981_((Object)bpl.getBuilding()).toString();
                if (!bplName.equals(newBuildingName)) continue;
                hudSelectedPlacement = bpl;
                break;
            }
        }
    }

    public static void convertControlGroups(int[] oldUnitIds, int[] newUnitIds) {
        if (HudClientEvents.MC.f_91073_ == null) {
            return;
        }
        for (ControlGroup group : controlGroups) {
            int j;
            int i;
            block1: for (i = 0; i < oldUnitIds.length; ++i) {
                for (j = 0; j < group.entityIds.size(); ++j) {
                    if (group.entityIds.get(j) != oldUnitIds[i]) continue;
                    group.entityIds.add(j, newUnitIds[i]);
                    continue block1;
                }
            }
            for (i = 0; i < oldUnitIds.length; ++i) {
                j = 0;
                while (j < oldUnitIds.length) {
                    int k = j++;
                    group.entityIds.removeIf(id -> id == oldUnitIds[k]);
                }
            }
        }
    }
}

