/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public class ClientLevelMixin {
    @Shadow
    @Final
    private Minecraft f_104565_;

    private boolean isWardenSound(SoundEvent pSoundEvent) {
        return pSoundEvent.m_11660_().m_135815_().contains("warden");
    }

    private boolean isGhastHurt(SoundEvent pSoundEvent) {
        return pSoundEvent.m_11660_().m_135815_().contains("ghast.hurt");
    }

    @Inject(method={"playSeededSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/core/Holder;Lnet/minecraft/sounds/SoundSource;FFJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playSeededSound(Player pPlayer, double pX, double pY, double pZ, Holder<SoundEvent> pSound, SoundSource pSource, float pVolume, float pPitch, long pSeed, CallbackInfo ci) {
        if (!OrthoviewClientEvents.isEnabled() || SoundClientEvents.STATIC_SOUNDS.contains(pSound.get())) {
            return;
        }
        ci.cancel();
        if (((SoundEvent)pSound.get()).equals(SoundEvents.f_215762_)) {
            return;
        }
        float volumeMult = 0.5f;
        if (this.isWardenSound((SoundEvent)pSound.get())) {
            volumeMult = 0.2f;
        } else if (this.isGhastHurt((SoundEvent)pSound.get())) {
            volumeMult = 0.1f;
        }
        this.playSoundActual(pX, pY, pZ, (SoundEvent)pSound.get(), pSource, pVolume * volumeMult, pPitch, false, pSeed);
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSound(double pX, double pY, double pZ, SoundEvent pSoundEvent, SoundSource pSoundSource, float pVolume, float pPitch, boolean pDistanceDelay, long pSeed, CallbackInfo ci) {
        if (!OrthoviewClientEvents.isEnabled() || SoundClientEvents.STATIC_SOUNDS.contains(pSoundEvent)) {
            return;
        }
        ci.cancel();
        if (pSoundEvent.equals(SoundEvents.f_215762_)) {
            return;
        }
        BlockPos bp = new BlockPos((int)pX, (int)pY, (int)pZ);
        if (SoundClientEvents.mutedBps.contains(bp)) {
            SoundClientEvents.mutedBps.remove(bp);
            return;
        }
        float volumeMult = 0.5f;
        if (this.isWardenSound(pSoundEvent)) {
            volumeMult = 0.2f;
        } else if (this.isGhastHurt(pSoundEvent)) {
            volumeMult = 0.1f;
        }
        this.playSoundActual(pX, pY, pZ, pSoundEvent, pSoundSource, pVolume * volumeMult, pPitch, false, pSeed);
    }

    private void playSoundActual(double pX, double pY, double pZ, SoundEvent pSoundEvent, SoundSource pSource, float pVolume, float pPitch, boolean pDistanceDelay, long pSeed) {
        if (!(FogOfWarClientEvents.isInBrightChunk(new BlockPos((int)(pX + 0.5), (int)(pY + 0.5), (int)(pZ + 0.5))) || pSoundEvent.m_11660_().m_135815_().contains("ui.button.click") || pSoundEvent.m_11660_().m_135827_().contains("reignofnether"))) {
            return;
        }
        Vec3 soundPos = this.getOrthoviewSoundPos(new Vec3(pX, pY, pZ));
        double d0 = this.f_104565_.f_91063_.m_109153_().m_90583_().m_82531_(soundPos.m_7096_(), soundPos.m_7098_(), soundPos.m_7094_());
        SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(pSoundEvent, pSource, pVolume, pPitch, RandomSource.m_216335_((long)pSeed), soundPos.m_7096_(), soundPos.m_7098_(), soundPos.m_7094_());
        if (pDistanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.f_104565_.m_91106_().m_120369_((SoundInstance)simplesoundinstance, (int)(d1 * 20.0));
        } else {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        }
    }

    private Vec3 getOrthoviewSoundPos(Vec3 originalPos) {
        LocalPlayer player = this.f_104565_.f_91074_;
        if (player == null) {
            return originalPos;
        }
        ArrayList<Vec3> posList = new ArrayList<Vec3>();
        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
            posList.add(entity.m_146892_());
        }
        for (BuildingPlacement building : BuildingClientEvents.getSelectedBuildings()) {
            BlockPos bp = BuildingUtils.getCentrePos(building.getBlocks());
            posList.add(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()));
        }
        List<Vec3> posListOnScreen = posList.stream().filter(vec3 -> MinimapClientEvents.isWorldXZinsideMap((int)vec3.f_82479_, (int)vec3.f_82481_)).toList();
        Vec3 newPos = new Vec3(0.0, 0.0, 0.0);
        if (posListOnScreen.size() > 0) {
            for (Vec3 pos : posListOnScreen) {
                newPos = newPos.m_82549_(pos);
            }
            double m = 1.0 / (double)posListOnScreen.size();
            newPos = newPos.m_82542_(m, m, m);
        } else {
            newPos = MiscUtil.getOrthoviewCentreWorldPos(this.f_104565_);
        }
        Vec3 diffOriginalToNew = originalPos.m_82549_(newPos.m_82542_(-1.0, -1.0, -1.0));
        return new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82549_(diffOriginalToNew);
    }

    @Shadow
    public void m_104637_(long pTime) {
    }

    @Shadow
    public void m_104746_(long pTime) {
    }

    @Inject(method={"tickTime"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickTime(CallbackInfo ci) {
        if (this.f_104565_.f_91073_ == null) {
            return;
        }
        ci.cancel();
        long timeNow = this.f_104565_.f_91073_.m_46468_();
        long targetTime = TimeClientEvents.targetClientTime;
        long targetTimePlusHalfDay = targetTime + 12000L;
        long timeDiff = 100L;
        if (OrthoviewClientEvents.isEnabled() && (timeNow > 2000L && timeNow <= 10000L || timeNow > 14000L && timeNow <= 22000L)) {
            timeDiff = 500L;
        }
        targetTime = TimeUtils.normaliseTime(targetTime);
        targetTimePlusHalfDay = TimeUtils.normaliseTime(targetTimePlusHalfDay);
        if (targetTime < 12000L && timeNow > targetTime && timeNow <= targetTimePlusHalfDay) {
            timeDiff *= -1L;
        } else if (targetTime >= 12000L && (timeNow > targetTime || timeNow <= targetTimePlusHalfDay)) {
            timeDiff *= -1L;
        }
        long timeSet = Math.abs(timeNow - targetTime) < Math.abs(timeDiff) ? targetTime : this.f_104565_.f_91073_.m_6106_().m_6793_() + timeDiff;
        timeSet = TimeUtils.normaliseTime(timeSet);
        this.m_104637_(timeSet);
        this.m_104746_(timeSet);
    }

    @Inject(method={"addDestroyBlockEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddDestroyBlockEffect(BlockPos pPos, BlockState pState, CallbackInfo ci) {
        if (!FogOfWarClientEvents.isInBrightChunk(pPos)) {
            ci.cancel();
        }
    }

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSkyColor(Vec3 pPos, float pPartialTick, CallbackInfoReturnable<Vec3> cir) {
        if (TimeClientEvents.isBloodMoonActive()) {
            cir.setReturnValue((Object)new Vec3(0.25, 0.0, 0.0));
        }
    }
}

