/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin.fogofwar;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.fogofwar.FrozenChunk;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.MiscUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.ForgeConfig;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Final
    @Shadow
    private ObjectArrayList<LevelRenderer.RenderChunkInfo> f_194297_;
    @Final
    @Shadow
    private final AtomicReference<LevelRenderer.RenderChunkStorage> f_194307_ = new AtomicReference();
    @Final
    @Shadow
    private Minecraft f_109461_;
    @Final
    @Shadow
    private RenderBuffers f_109464_;
    @Final
    @Shadow
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    @Shadow
    private ChunkRenderDispatcher f_109436_;
    @Shadow
    private ClientLevel f_109465_;
    private static final ObjectArrayList<LevelRenderer.RenderChunkInfo> lastRenderChunksInFrustum = new ObjectArrayList();
    private List<Pair<BlockPos, Integer>> chunksToReDirty = new ArrayList<Pair<BlockPos, Integer>>();
    @Shadow
    @Final
    private final AtomicBoolean f_194299_ = new AtomicBoolean(false);
    @Shadow
    @Nullable
    private PostChain f_109412_;

    private int distToChunk(ChunkPos chunkPos) {
        if (this.f_109461_.f_91074_ == null) {
            return 0;
        }
        return this.f_109461_.f_91074_.m_146902_().m_45594_(chunkPos);
    }

    @Inject(method={"applyFrustum(Lnet/minecraft/client/renderer/culling/Frustum;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyFrustum(Frustum pFrustum, CallbackInfo ci) {
        if (!FogOfWarClientEvents.isEnabled()) {
            return;
        }
        ci.cancel();
        if (!Minecraft.m_91087_().m_18695_()) {
            throw new IllegalStateException("applyFrustum called from wrong thread: " + Thread.currentThread().getName());
        }
        this.f_109461_.m_91307_().m_6180_("apply_frustum");
        this.f_194297_.clear();
        HashSet<ChunkPos> chunksToRefreshDone = new HashSet<ChunkPos>();
        int chunksDirtied = 0;
        for (LevelRenderer.RenderChunkInfo chunkInfo : this.f_194307_.get().f_194376_) {
            ChunkPos cpos;
            if (pFrustum.m_113029_(chunkInfo.f_109839_.m_202440_())) {
                this.f_194297_.add((Object)chunkInfo);
            }
            if (this.f_109461_.f_91073_ == null || !FogOfWarClientEvents.chunksToRefresh.contains(cpos = this.f_109461_.f_91073_.m_46865_(chunkInfo.f_109839_.m_112839_()).m_7697_())) continue;
            chunkInfo.f_109839_.m_112828_(true);
            chunksToRefreshDone.add(cpos);
            ++chunksDirtied;
        }
        FogOfWarClientEvents.chunksToRefresh.removeAll(chunksToRefreshDone);
        FogOfWarClientEvents.renderChunksInFrustum.clear();
        FogOfWarClientEvents.renderChunksInFrustum.addAll(this.f_194297_);
        this.f_109461_.m_91307_().m_7238_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"compileChunks(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void compileChunks(Camera pCamera, CallbackInfo ci) {
        if (OrthoviewClientEvents.hideLeavesMethod == OrthoviewClientEvents.LeafHideMethod.AROUND_UNITS_AND_CURSOR && OrthoviewClientEvents.isEnabled() && --UnitClientEvents.windowUpdateTicks <= 0) {
            UnitClientEvents.windowUpdateTicks = 5;
            Vec3 centrePos = MiscUtil.getOrthoviewCentreWorldPos(Minecraft.m_91087_());
            for (Object chunkInfo : this.f_194297_) {
                BlockPos chunkCentreBp = ((LevelRenderer.RenderChunkInfo)chunkInfo).f_109839_.m_112839_().m_7918_(8, 8, 8);
                ObjectListIterator newChunksToReDirty = new ArrayList();
                List<BlockPos> list = UnitClientEvents.windowPositions;
                synchronized (list) {
                    for (Pair<BlockPos, Integer> pair : this.chunksToReDirty) {
                        int times = (Integer)pair.getSecond();
                        if (((BlockPos)pair.getFirst()).equals((Object)((LevelRenderer.RenderChunkInfo)chunkInfo).f_109839_.m_112839_())) {
                            ((LevelRenderer.RenderChunkInfo)chunkInfo).f_109839_.m_112828_(true);
                            --times;
                        }
                        if (times <= 0) continue;
                        newChunksToReDirty.add(new Pair((Object)((BlockPos)pair.getFirst()), (Object)times));
                    }
                    this.chunksToReDirty.clear();
                    this.chunksToReDirty.addAll((Collection<Pair<BlockPos, Integer>>)newChunksToReDirty);
                    UnitClientEvents.windowPositions.forEach(arg_0 -> this.lambda$compileChunks$0(chunkCentreBp, (LevelRenderer.RenderChunkInfo)chunkInfo, arg_0));
                }
            }
        }
        if (!FogOfWarClientEvents.isEnabled()) {
            return;
        }
        ci.cancel();
        ObjectArrayList newRenderChunksInFrustum = new ObjectArrayList();
        newRenderChunksInFrustum.addAll(this.f_194297_);
        newRenderChunksInFrustum.removeAll(lastRenderChunksInFrustum);
        ArrayList<BlockPos> loadedFcOrigins = new ArrayList<BlockPos>();
        for (FrozenChunk frozenChunk : FogOfWarClientEvents.frozenChunks.stream().filter(fc -> !fc.hasFakeBlocks).toList()) {
            for (LevelRenderer.RenderChunkInfo newRenderChunk : newRenderChunksInFrustum) {
                if (!newRenderChunk.f_109839_.m_112839_().equals((Object)frozenChunk.origin) || FogOfWarClientEvents.isInBrightChunk(frozenChunk.origin) || loadedFcOrigins.contains(frozenChunk.origin) || frozenChunk.unsaved) continue;
                frozenChunk.loadBlocks();
                loadedFcOrigins.add(frozenChunk.origin);
            }
        }
        for (FrozenChunk frozenChunk : FogOfWarClientEvents.frozenChunks.stream().filter(fc -> fc.hasFakeBlocks).toList()) {
            for (LevelRenderer.RenderChunkInfo newRenderChunk : newRenderChunksInFrustum) {
                if (!newRenderChunk.f_109839_.m_112839_().equals((Object)frozenChunk.origin) || FogOfWarClientEvents.isInBrightChunk(frozenChunk.origin) || loadedFcOrigins.contains(frozenChunk.origin) || frozenChunk.unsaved) continue;
                frozenChunk.loadBlocks();
            }
        }
        this.f_109461_.m_91307_().m_6180_("populate_chunks_to_compile");
        LevelLightEngine levellightengine = this.f_109465_.m_5518_();
        RenderRegionCache renderregioncache = new RenderRegionCache();
        BlockPos blockpos = pCamera.m_90588_();
        ArrayList list = Lists.newArrayList();
        ConcurrentHashMap.KeySetView rerenderChunksToRemove = ConcurrentHashMap.newKeySet();
        Set<ChunkPos> enemyOccupiedChunks = FogOfWarClientEvents.getEnemyOccupiedChunks();
        for (LevelRenderer.RenderChunkInfo chunkInfo : this.f_194297_) {
            BlockPos originPos = chunkInfo.f_109839_.m_112839_();
            ChunkPos chunkPos = new ChunkPos(originPos);
            if (FogOfWarClientEvents.rerenderChunks.contains(chunkPos)) {
                FogOfWarClientEvents.updateChunkLighting(originPos);
                rerenderChunksToRemove.add(chunkPos);
            } else if (!FogOfWarClientEvents.isInBrightChunk(originPos)) {
                if (FogOfWarClientEvents.semiFrozenChunks.contains(originPos) || FogOfWarClientEvents.frozenChunks.stream().filter(fc -> fc.unsaved).map(fc -> fc.origin).toList().contains(originPos)) continue;
                if (OrthoviewClientEvents.isEnabled() || enemyOccupiedChunks.contains(chunkPos)) {
                    FogOfWarClientEvents.semiFrozenChunks.add(originPos);
                }
            }
            ChunkRenderDispatcher.RenderChunk renderChunk = chunkInfo.f_109839_;
            SectionPos sectionpos = SectionPos.m_123199_((BlockPos)renderChunk.m_112839_());
            if (!renderChunk.m_112841_() || !levellightengine.m_284439_(sectionpos)) continue;
            boolean flag = false;
            if (this.f_109461_.f_91066_.m_232080_().m_231551_() != PrioritizeChunkUpdates.NEARBY) {
                if (this.f_109461_.f_91066_.m_232080_().m_231551_() == PrioritizeChunkUpdates.PLAYER_AFFECTED) {
                    flag = renderChunk.m_112842_();
                }
            } else {
                BlockPos blockpos1 = renderChunk.m_112839_().m_7918_(8, 8, 8);
                boolean bl = flag = (Boolean)ForgeConfig.CLIENT.alwaysSetupTerrainOffThread.get() == false && (blockpos1.m_123331_((Vec3i)blockpos) < 768.0 || renderChunk.m_112842_());
            }
            if (flag) {
                this.f_109461_.m_91307_().m_6180_("build_near_sync");
                this.f_109436_.m_200431_(renderChunk, renderregioncache);
                renderChunk.m_112840_();
                this.f_109461_.m_91307_().m_7238_();
                continue;
            }
            list.add(renderChunk);
        }
        FogOfWarClientEvents.rerenderChunks.removeAll(rerenderChunksToRemove);
        this.f_109461_.m_91307_().m_6182_("upload");
        this.f_109436_.m_194417_();
        this.f_109461_.m_91307_().m_6182_("schedule_async_compile");
        for (ChunkRenderDispatcher.RenderChunk renderChunk1 : list) {
            renderChunk1.m_200434_(this.f_109436_, renderregioncache);
            renderChunk1.m_112840_();
        }
        this.f_109461_.m_91307_().m_7238_();
        lastRenderChunksInFrustum.clear();
        lastRenderChunksInFrustum.addAll(this.f_194297_);
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="HEAD")})
    private void setupRender(Camera pCamera, Frustum pFrustum, boolean pHasCapturedFrustum, boolean pIsSpectator, CallbackInfo ci) {
        if (!FogOfWarClientEvents.isEnabled()) {
            return;
        }
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        this.f_194299_.set(true);
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void renderLevel(PoseStack pPoseStack, float pPartialTick, long pFinishNanoTime, boolean pRenderBlockOutline, Camera pCamera, GameRenderer pGameRenderer, LightTexture pLightTexture, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        Vec3 vec3 = pCamera.m_90583_();
        double d0 = vec3.m_7096_();
        double d1 = vec3.m_7098_();
        double d2 = vec3.m_7094_();
        for (Long2ObjectMap.Entry entry : this.f_109409_.long2ObjectEntrySet()) {
            SortedSet sortedset1;
            double d5;
            double d4;
            BlockPos blockpos2 = BlockPos.m_122022_((long)entry.getLongKey());
            double d3 = (double)blockpos2.m_123341_() - d0;
            double distSqr = d3 * d3 + (d4 = (double)blockpos2.m_123342_() - d1) * d4 + (d5 = (double)blockpos2.m_123343_() - d2) * d5;
            if (!(distSqr > 1024.0) || !(distSqr < 65536.0) || (sortedset1 = (SortedSet)entry.getValue()) == null || sortedset1.isEmpty()) continue;
            int k1 = ((BlockDestructionProgress)sortedset1.last()).m_139988_();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)blockpos2.m_123341_() - d0, (double)blockpos2.m_123342_() - d1, (double)blockpos2.m_123343_() - d2);
            PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
            SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(k1)), posestack$pose.m_252922_(), posestack$pose.m_252943_(), 1.0f);
            ModelData modelData = this.f_109465_.getModelDataManager().getAt(blockpos2);
            this.f_109461_.m_91289_().renderBreakingTexture(this.f_109465_.m_8055_(blockpos2), blockpos2, (BlockAndTintGetter)this.f_109465_, pPoseStack, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
            pPoseStack.m_85849_();
        }
    }

    @Shadow
    private ParticleStatus m_109767_(boolean pDecreased) {
        return null;
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticleInternal(ParticleOptions pOptions, boolean pForce, boolean pDecreased, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, CallbackInfoReturnable<Particle> cir) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        Camera camera = this.f_109461_.f_91063_.m_109153_();
        if (this.f_109461_ != null && camera.m_90593_() && this.f_109461_.f_91061_ != null) {
            ParticleStatus particlestatus = this.m_109767_(pDecreased);
            if (pForce) {
                cir.setReturnValue((Object)this.f_109461_.f_91061_.m_107370_(pOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed));
            } else if (camera.m_90583_().m_82531_(pX, pY, pZ) > 4096.0) {
                cir.setReturnValue(null);
            } else {
                cir.setReturnValue(particlestatus == ParticleStatus.MINIMAL ? null : this.f_109461_.f_91061_.m_107370_(pOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed));
            }
        } else {
            cir.setReturnValue(null);
        }
    }

    private /* synthetic */ void lambda$compileChunks$0(BlockPos chunkCentreBp, LevelRenderer.RenderChunkInfo chunkInfo, BlockPos bp) {
        if (chunkCentreBp.m_123331_((Vec3i)bp) < 625.0) {
            chunkInfo.f_109839_.m_112828_(true);
            this.chunksToReDirty.add((Pair<BlockPos, Integer>)new Pair((Object)chunkInfo.f_109839_.m_112839_(), (Object)10));
        }
    }
}

