/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.config.ReignOfNetherClientConfigs;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MapColor;

public class PlayerColors {
    private static final HashMap<Integer, PlayerColor> mappedColors = new HashMap();
    public static final PlayerColor COLOR_RED = PlayerColor.fromName(MapColor.f_283913_.f_283805_, 10561314, "red");
    public static final PlayerColor COLOR_BLUE = PlayerColor.fromName(MapColor.f_283743_.f_283805_, 3488157, "blue");
    public static final PlayerColor COLOR_CYAN = PlayerColor.fromName(MapColor.f_283772_.f_283805_, 1411473, "cyan");
    public static final PlayerColor COLOR_PURPLE = PlayerColor.fromName(MapColor.f_283889_.f_283805_, 7940780, "purple");
    public static final PlayerColor COLOR_YELLOW = PlayerColor.fromName(MapColor.f_283832_.f_283805_, 16303655, "yellow");
    public static final PlayerColor COLOR_ORANGE = PlayerColor.fromName(MapColor.f_283750_.f_283805_, 15758867, "orange");
    public static final PlayerColor COLOR_LIME = PlayerColor.fromName(MapColor.f_283916_.f_283805_, 7387417, "lime");
    public static final PlayerColor COLOR_PINK = PlayerColor.fromName(MapColor.f_283765_.f_283805_, 15568300, "pink");
    public static final PlayerColor COLOR_MAGENTA = PlayerColor.fromName(MapColor.f_283931_.f_283805_, 12403891, "magenta");
    public static final PlayerColor COLOR_LIGHT_BLUE = PlayerColor.fromName(MapColor.f_283869_.f_283805_, 3846105, "light_blue");
    public static final PlayerColor COLOR_GREEN = PlayerColor.fromName(MapColor.f_283784_.f_283805_, 5532955, "green");
    public static final PlayerColor COLOR_BROWN = PlayerColor.fromName(MapColor.f_283748_.f_283805_, 7489320, "brown");
    public static final int PLAYER_COLOR_COUNT = PlayerColor.colourCount;
    public static final PlayerColor COLOR_LIGHT_GREY = PlayerColor.fromName(MapColor.f_283779_.f_283805_, 0x8E8E86, "light_gray");
    public static final PlayerColor COLOR_GRAY = PlayerColor.fromName(MapColor.f_283818_.f_283805_, 4080711, "gray");
    public static final PlayerColor COLOR_BLACK = PlayerColor.fromName(MapColor.f_283927_.f_283805_, 1316121, "black");
    public static final PlayerColor COLOR_WHITE = PlayerColor.fromName(MapColor.f_283811_.f_283805_, 0xE9ECEC, "white");
    public static final int PLAYER_COLOR_SPECIAL_COUNT = PlayerColor.colourCount;
    public static final PlayerColor COLOR_OWNED = new PlayerColor(-1, 0x33FF33, "owned", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/lime_wool.png"), PlayerColors.COLOR_LIME.bedIcon);
    public static final PlayerColor COLOR_FRIENDLY = new PlayerColor(-1, 0x3333FF, "friendly", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/blue_wool.png"), PlayerColors.COLOR_BLUE.bedIcon);
    public static final PlayerColor COLOR_NEUTRAL = new PlayerColor(-1, 0xFFFF19, "neutral", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/yellow_wool.png"), PlayerColors.COLOR_YELLOW.bedIcon);
    public static final PlayerColor COLOR_HOSTILE = new PlayerColor(-1, 0xFF3333, "hostile", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/red_wool.png"), PlayerColors.COLOR_RED.bedIcon);
    public static final int PLAYER_COLOR_TOTAL_COUNT = PlayerColor.colourCount;
    public static final PlayerColor[] colors = new PlayerColor[]{COLOR_RED, COLOR_BLUE, COLOR_CYAN, COLOR_PURPLE, COLOR_YELLOW, COLOR_ORANGE, COLOR_LIME, COLOR_PINK, COLOR_MAGENTA, COLOR_LIGHT_BLUE, COLOR_GREEN, COLOR_BROWN, COLOR_LIGHT_GREY, COLOR_GRAY, COLOR_BLACK, COLOR_WHITE, COLOR_OWNED, COLOR_FRIENDLY, COLOR_NEUTRAL, COLOR_HOSTILE};
    private static HashMap<String, Integer> playerColorId = new HashMap();

    public static boolean isUsingPlayerColors() {
        if (!PlayerClientEvents.isRTSPlayer()) {
            return true;
        }
        return (Boolean)ReignOfNetherClientConfigs.USE_PLAYER_COLORS.get();
    }

    public static void toggleColorMode() {
        ReignOfNetherClientConfigs.USE_PLAYER_COLORS.set((Object)((Boolean)ReignOfNetherClientConfigs.USE_PLAYER_COLORS.get() == false ? 1 : 0));
    }

    public static int getPlayerColorId(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return PlayerColors.COLOR_WHITE.id;
        }
        Integer cachedColorId = playerColorId.getOrDefault(playerName, -1);
        if (cachedColorId != -1) {
            return cachedColorId;
        }
        int mapColorId = PlayerClientEvents.getPlayerMapColorId(playerName);
        if (mapColorId > 0 && mappedColors.containsKey(mapColorId)) {
            PlayerColor color = mappedColors.get(mapColorId);
            playerColorId.put(playerName, color.id);
            return color.id;
        }
        Integer playerId = PlayerClientEvents.getPlayerIndex(playerName);
        if (playerId != null) {
            playerId = playerId % PLAYER_COLOR_COUNT;
            playerColorId.put(playerName, playerId);
            return playerId;
        }
        return PlayerColors.COLOR_WHITE.id;
    }

    public static void reset() {
        playerColorId.clear();
    }

    public static ResourceLocation getColorIcon(int colorIndex) {
        return PlayerColors.colors[colorIndex % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].blockTexture;
    }

    public static int getColorHex(int colorIndex) {
        return PlayerColors.colors[colorIndex % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
    }

    public static int getPlayerColorHex(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return PlayerColors.COLOR_WHITE.hexCode;
        }
        int colorId = PlayerColors.getPlayerColorId(playerName);
        return PlayerColors.colors[colorId].hexCode;
    }

    public static ResourceLocation getPlayerColorIcon(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return PlayerColors.COLOR_WHITE.blockTexture;
        }
        int colorId = PlayerColors.getPlayerColorId(playerName);
        return PlayerColors.colors[colorId].blockTexture;
    }

    public static ResourceLocation getPlayerColorBedIcon(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return PlayerColors.COLOR_WHITE.bedIcon;
        }
        int colorId = PlayerColors.getPlayerColorId(playerName);
        return PlayerColors.colors[colorId].bedIcon;
    }

    public static int getPlayerDisplayColorHex(String playerName) {
        if (PlayerColors.isUsingPlayerColors()) {
            return PlayerColors.getPlayerColorHex(playerName);
        }
        return PlayerColors.getPlayerAllianceColorHex(playerName);
    }

    public static int getPlayerAllianceColorHex(String playerName) {
        Relationship unitRs = UnitClientEvents.getPlayerToPlayerRelationship(playerName);
        return switch (unitRs) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_SELF.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
            case Relationship.FRIENDLY -> PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_ALLY.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
            case Relationship.NEUTRAL -> PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_NEUTRAL.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
            case Relationship.HOSTILE -> PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_ENEMY.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
        };
    }

    public static int getPlayerPortraitDisplayColorHex(String playerName) {
        if (PlayerColors.isUsingPlayerColors()) {
            return 0x90000000 | PlayerColors.getPlayerColorHex(playerName);
        }
        Relationship unitRs = UnitClientEvents.getPlayerToPlayerRelationship(playerName);
        return switch (unitRs) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> -1879048192;
            case Relationship.FRIENDLY -> 0x90000000 | PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_ALLY.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
            case Relationship.NEUTRAL -> 0x90000000 | PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_NEUTRAL.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
            case Relationship.HOSTILE -> 0x90000000 | PlayerColors.colors[((Integer)ReignOfNetherClientConfigs.PLAYER_COLOR_ENEMY.get()).intValue() % PlayerColors.PLAYER_COLOR_TOTAL_COUNT].hexCode;
        };
    }

    public static Button getToggleTeamColorsButton() {
        return new Button("Toggle alliance colours", 14, PlayerColors.isUsingPlayerColors() ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/toggle_color_mode_players.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/toggle_color_mode_relations.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !MinimapClientEvents.isLargeMap(), PlayerClientEvents::isRTSPlayer, PlayerColors::toggleColorMode, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.using_player_team_color", (Object[])new Object[0]), PlayerColors.isUsingPlayerColors()), MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.using_relation_color", (Object[])new Object[0]), !PlayerColors.isUsingPlayerColors())));
    }

    public static class PlayerColor {
        private static int colourCount = 0;
        public final int mapColorId;
        public final int id;
        public final String name;
        public final int hexCode;
        public final ResourceLocation blockTexture;
        public final ResourceLocation bedIcon;

        public PlayerColor(int mapColorId, int hexCode, String name, ResourceLocation blockTexture, ResourceLocation bedIcon) {
            this.mapColorId = mapColorId;
            this.id = colourCount++;
            this.name = name;
            this.hexCode = hexCode;
            this.blockTexture = blockTexture;
            this.bedIcon = bedIcon;
            System.out.println("Created color '" + this.name + "' with index " + this.id);
            if (this.mapColorId != -1) {
                mappedColors.put(mapColorId, this);
            }
        }

        public static PlayerColor fromName(int mapColorId, int hexCode, String name) {
            return new PlayerColor(mapColorId, hexCode, name, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)("textures/block/rts_start_block_" + name + ".png")), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)("textures/icons/beds/" + name + ".png")));
        }
    }
}

