/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.util.Faction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class SandboxServer {
    public static boolean isSandboxPlayer(String playerName) {
        for (RTSPlayer rtsPlayer : PlayerServerEvents.rtsPlayers) {
            if (rtsPlayer.faction != Faction.NONE || !playerName.equals(rtsPlayer.name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyoneASandboxPlayer() {
        for (RTSPlayer rtsPlayer : PlayerServerEvents.rtsPlayers) {
            if (rtsPlayer.faction != Faction.NONE) continue;
            return true;
        }
        return false;
    }

    public static void spawnUnit(String playerName, String unitName, BlockPos blockPos) {
        Entity entity;
        if (PlayerServerEvents.serverLevel == null) {
            return;
        }
        EntityType<? extends Mob> entityType = EntityRegistrar.getEntityType(unitName);
        if (entityType != null && (entity = UnitServerEvents.spawnMob(entityType, PlayerServerEvents.serverLevel, (Vec3i)blockPos, playerName)) instanceof Unit) {
            Unit unit = (Unit)entity;
            if (playerName.isEmpty() || playerName.equals("Enemy")) {
                unit.setAnchor(blockPos);
            }
        }
    }

    public static void setAnchor(int[] entityIds, BlockPos blockPos) {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            for (int entityId : entityIds) {
                if (entity.m_19879_() != entityId || !(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                unit.setAnchor(blockPos);
                UnitSyncClientboundPacket.sendSyncAnchorPosPacket(entity, unit.getAnchor());
            }
        }
    }

    public static void resetToAnchor(int[] entityIds) {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            for (int entityId : entityIds) {
                Unit unit;
                if (entity.m_19879_() != entityId || !(entity instanceof Unit) || !Unit.hasAnchor(unit = (Unit)entity)) continue;
                entity.m_20219_(Vec3.m_82512_((Vec3i)unit.getAnchor()).m_82520_(0.0, 0.5, 0.0));
                entity.m_21153_(entity.m_21233_());
                entity.m_21219_();
                Unit.fullResetBehaviours(unit);
            }
        }
    }

    public static void removeAnchor(int[] entityIds) {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            for (int entityId : entityIds) {
                if (entity.m_19879_() != entityId || !(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                unit.setAnchor(null);
                UnitSyncClientboundPacket.sendRemoveAnchorPosPacket(entity);
            }
        }
    }

    public static void setUnitOwner(int[] entityIds, String ownerName) {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            for (int entityId : entityIds) {
                if (entity.m_19879_() != entityId || !(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                unit.setOwnerName(ownerName);
                UnitSyncClientboundPacket.sendSyncOwnerNamePacket(unit);
            }
        }
    }

    public static void setBuildingOwner(BlockPos pos, String ownerName) {
        for (BuildingPlacement bpl : BuildingServerEvents.getBuildings()) {
            if (!bpl.originPos.equals((Object)pos)) continue;
            bpl.ownerName = ownerName;
            BuildingServerEvents.syncBuildingPlacement(pos);
        }
    }

    public static void removeBuilding(BlockPos pos) {
        BuildingServerEvents.getBuildings().removeIf(b -> {
            if (b.originPos.equals((Object)pos)) {
                BuildingServerEvents.syncBuildingPlacement(pos);
                if (b instanceof NetherConvertingBuilding) {
                    NetherConvertingBuilding ncb = (NetherConvertingBuilding)((Object)b);
                    ncb.getZone().startRestoring();
                }
                return true;
            }
            return false;
        });
    }
}

