/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.startpos;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.startpos.StartPos;
import com.solegendary.reignofnether.startpos.StartPosAction;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class StartPosClientboundPacket {
    StartPosAction action;
    Faction faction;
    BlockPos blockPos;
    String playerName;
    int colorId;

    public static void addPos(StartPos startPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.ADD, startPos.pos, startPos.faction, startPos.playerName, startPos.colorId));
    }

    public static void removePos(BlockPos pos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.REMOVE, pos, Faction.NONE, "", 0));
    }

    public static void reservePos(BlockPos pos, Faction faction, String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.RESERVE, pos, faction, playerName, 0));
    }

    public static void unreservePos(BlockPos pos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.UNRESERVE, pos, Faction.NONE, "", 0));
    }

    public static void reset() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.RESET, new BlockPos(0, 0, 0), Faction.NONE, "", 0));
    }

    public static void startGameCountdown() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.SET_GAME_STARTING, new BlockPos(0, 0, 0), Faction.NONE, "", 0));
    }

    public static void cancelStartGameCountdown() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new StartPosClientboundPacket(StartPosAction.UNSET_GAME_STARTING, new BlockPos(0, 0, 0), Faction.NONE, "", 0));
    }

    public StartPosClientboundPacket(StartPosAction action, BlockPos blockPos, Faction faction, String playerName, int colorId) {
        this.action = action;
        this.blockPos = blockPos;
        this.faction = faction;
        this.playerName = playerName;
        this.colorId = colorId;
    }

    public StartPosClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (StartPosAction)buffer.m_130066_(StartPosAction.class);
        this.blockPos = buffer.m_130135_();
        this.faction = (Faction)buffer.m_130066_(Faction.class);
        this.playerName = buffer.m_130277_();
        this.colorId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130064_(this.blockPos);
        buffer.m_130068_((Enum)this.faction);
        buffer.m_130070_(this.playerName);
        buffer.writeInt(this.colorId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            block0 : switch (this.action) {
                case ADD: {
                    StartPosClientEvents.startPoses.removeIf(sp -> sp.pos.equals((Object)this.blockPos));
                    StartPosClientEvents.startPoses.add(new StartPos(this.blockPos, this.faction, this.playerName, this.colorId));
                    break;
                }
                case REMOVE: {
                    StartPosClientEvents.startPoses.removeIf(sp -> sp.pos.equals((Object)this.blockPos));
                    break;
                }
                case RESERVE: {
                    for (StartPos startPos : StartPosClientEvents.startPoses) {
                        if (!startPos.pos.equals((Object)this.blockPos)) continue;
                        startPos.faction = this.faction;
                        startPos.playerName = this.playerName;
                        break block0;
                    }
                    break;
                }
                case UNRESERVE: {
                    for (StartPos startPos : StartPosClientEvents.startPoses) {
                        if (!startPos.pos.equals((Object)this.blockPos)) continue;
                        startPos.reset();
                        break block0;
                    }
                    break;
                }
                case RESET: {
                    StartPosClientEvents.resetAll();
                    break;
                }
                case SET_GAME_STARTING: {
                    StartPosClientEvents.isStarting = true;
                    break;
                }
                case UNSET_GAME_STARTING: {
                    StartPosClientEvents.isStarting = false;
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

