/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SurvivalServerboundPacket {
    public WaveDifficulty difficulty;
    public int waveNumber;

    public static void startSurvivalMode(WaveDifficulty mode) {
        PacketHandler.INSTANCE.sendToServer((Object)new SurvivalServerboundPacket(mode, 0));
    }

    public static void setWaveNumber(int number) {
        if (number > 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new SurvivalServerboundPacket(WaveDifficulty.BEGINNER, number));
        }
    }

    public SurvivalServerboundPacket(WaveDifficulty gameMode, int waveNumber) {
        this.difficulty = gameMode;
        this.waveNumber = waveNumber;
    }

    public SurvivalServerboundPacket(FriendlyByteBuf buffer) {
        this.difficulty = (WaveDifficulty)buffer.m_130066_(WaveDifficulty.class);
        this.waveNumber = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.difficulty);
        buffer.writeInt(this.waveNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            if (this.waveNumber <= 0) {
                SurvivalServerEvents.enable(this.difficulty);
            } else {
                SurvivalServerEvents.setWaveNumber(this.waveNumber);
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

