/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.CastSummonVexes;
import com.solegendary.reignofnether.ability.abilities.Roar;
import com.solegendary.reignofnether.ability.abilities.SonicBoom;
import com.solegendary.reignofnether.ability.abilities.ToggleShield;
import com.solegendary.reignofnether.ability.abilities.WitherCloud;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.WardenUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class WaveEnemy {
    private static final int PERIODIC_COMMAND_INTERVAL = 40;
    private static final int IDLE_COMMAND_INTERVAL = 100;
    public final Unit unit;
    private long idleTicks = 0L;
    private long ticks = 0L;
    private BlockPos lastOnPos;

    public WaveEnemy(Unit unit) {
        this.unit = unit;
        this.lastOnPos = this.getEntity().m_20097_();
    }

    public LivingEntity getEntity() {
        return (LivingEntity)this.unit;
    }

    public void tick(long ticksToAdd) {
        BlockPos onPos;
        MeleeAttackBuildingGoal mabg;
        AttackerUnit aUnit;
        Unit unit;
        boolean isAttacking;
        if (this.getEntity().m_20159_()) {
            return;
        }
        this.ticks += ticksToAdd;
        boolean bl = isAttacking = this.unit.getTargetGoal().getTarget() != null;
        if (!isAttacking && (unit = this.unit) instanceof AttackerUnit && (unit = (aUnit = (AttackerUnit)((Object)unit)).getAttackBuildingGoal()) instanceof MeleeAttackBuildingGoal && (mabg = (MeleeAttackBuildingGoal)((Object)unit)).isAttacking()) {
            isAttacking = true;
        }
        this.idleTicks = (onPos = this.getEntity().m_20097_()).equals((Object)this.lastOnPos) && !isAttacking ? (this.idleTicks += ticksToAdd) : 0L;
        this.lastOnPos = onPos;
        if (this.ticks > 0L && this.ticks == ticksToAdd * 10L) {
            this.startingCommand();
        }
        if (this.ticks > 0L && this.ticks % 40L == 0L) {
            this.periodicCommand();
        }
        if (this.idleTicks > 0L && this.idleTicks % 100L == 0L) {
            this.idleCommand();
        }
        if ((unit = this.unit) instanceof CreeperUnit) {
            BlockPos bpTarget;
            CreeperUnit creeperUnit = (CreeperUnit)unit;
            BuildingPlacement nearestBuilding = this.getNearestAttackableBuilding();
            if (nearestBuilding != null && creeperUnit.m_20238_(Vec3.m_82512_((Vec3i)(bpTarget = nearestBuilding.getClosestGroundPos(((Entity)this.unit).m_20097_(), 1)))) < 4.0) {
                creeperUnit.startToExplode();
            }
        }
        if (this.ticks > 0L && this.ticks % 20L == 0L && this.getEntity().m_20069_() && this.idleTicks > 100L && this.getEntity().m_9236_().m_8055_(this.getEntity().m_20097_()).m_60819_().m_205070_(FluidTags.f_13131_)) {
            this.getEntity().m_9236_().m_46597_(this.getEntity().m_20097_(), Blocks.f_50449_.m_49966_());
            this.getEntity().m_6027_(this.getEntity().m_20185_(), this.getEntity().m_20186_() + 0.5, this.getEntity().m_20189_());
        }
    }

    public void startingCommand() {
        SpiderUnit spiderUnit;
        Unit unit = this.unit;
        if (unit instanceof SpiderUnit && ResearchServerEvents.playerHasResearch((spiderUnit = (SpiderUnit)unit).getOwnerName(), ProductionItems.RESEARCH_SPIDER_WEBS) && spiderUnit.getWebAbility() != null) {
            spiderUnit.getWebAbility().setAutocast(true, spiderUnit);
        }
        this.attackMoveNearestBuilding();
    }

    public void periodicCommand() {
        Object target;
        Object ability;
        Object object = this.unit;
        if (object instanceof RavagerUnit) {
            RavagerUnit ravagerUnit = (RavagerUnit)object;
            object = ravagerUnit.getAbilities().get().iterator();
            while (object.hasNext()) {
                Roar roar;
                ability = (Ability)object.next();
                if (!(ability instanceof Roar) || !(roar = (Roar)ability).isOffCooldown(this.unit) || !(ravagerUnit.m_21223_() < ravagerUnit.m_21233_() / 2.0f)) continue;
                Unit.fullResetBehaviours(ravagerUnit);
                roar.use(this.getEntity().m_9236_(), this.unit, (BlockPos)null);
            }
        }
        if ((object = this.unit) instanceof WardenUnit) {
            WardenUnit wardenUnit = (WardenUnit)object;
            target = this.getNearestAttackableUnit();
            for (Ability ability2 : wardenUnit.getAbilities().get()) {
                SonicBoom boom;
                if (!(ability2 instanceof SonicBoom) || !(boom = (SonicBoom)ability2).isOffCooldown(this.unit) || target == null || !(wardenUnit.m_20280_((Entity)target) <= (double)(boom.range * boom.range))) continue;
                Unit.fullResetBehaviours(wardenUnit);
                boom.use(this.getEntity().m_9236_(), this.unit, (LivingEntity)target);
            }
        }
        if ((target = this.unit) instanceof EvokerUnit) {
            EvokerUnit evokerUnit = (EvokerUnit)target;
            target = this.getNearestAttackableUnit();
            for (Ability ability2 : evokerUnit.getAbilities().get()) {
                CastSummonVexes summon;
                if (!(ability2 instanceof CastSummonVexes) || !(summon = (CastSummonVexes)ability2).isOffCooldown(this.unit) || target == null || !(evokerUnit.m_20280_((Entity)target) <= (double)(evokerUnit.getAttackRange() * evokerUnit.getAttackRange()))) continue;
                Unit.fullResetBehaviours(evokerUnit);
                summon.use(this.getEntity().m_9236_(), this.unit, (LivingEntity)target);
            }
        }
        if ((target = this.unit) instanceof BruteUnit) {
            BruteUnit bruteUnit = (BruteUnit)target;
            target = bruteUnit.getAbilities().get().iterator();
            while (target.hasNext()) {
                MeleeAttackBuildingGoal mabg;
                RangedAttackerUnit rTarget;
                boolean shouldRaiseShield;
                ability = (Ability)target.next();
                if (!(ability instanceof ToggleShield)) continue;
                ToggleShield shield = (ToggleShield)ability;
                if (!ResearchServerEvents.playerHasResearch(bruteUnit.getOwnerName(), ProductionItems.RESEARCH_BRUTE_SHIELDS)) continue;
                LivingEntity livingEntity = bruteUnit.m_5448_();
                boolean bl = shouldRaiseShield = livingEntity instanceof RangedAttackerUnit && bruteUnit.m_20280_((Entity)(rTarget = (RangedAttackerUnit)livingEntity)) <= 36.0 || (livingEntity = bruteUnit.getAttackBuildingGoal()) instanceof MeleeAttackBuildingGoal && (mabg = (MeleeAttackBuildingGoal)livingEntity).isAttacking();
                if ((bruteUnit.isHoldingUpShield || !shouldRaiseShield) && (!bruteUnit.isHoldingUpShield || shouldRaiseShield)) continue;
                shield.use(this.getEntity().m_9236_(), this.unit, (BlockPos)null);
            }
        }
        if ((target = this.unit) instanceof WitherSkeletonUnit) {
            WitherSkeletonUnit wsUnit = (WitherSkeletonUnit)target;
            target = wsUnit.m_5448_();
            for (Ability ability2 : wsUnit.getAbilities().get()) {
                WitherCloud cloud;
                LivingEntity nearestAlly = this.getNearestNonWitherAllyUnit();
                if (!(ability2 instanceof WitherCloud) || !(cloud = (WitherCloud)ability2).isOffCooldown(this.unit) || target == null || !(wsUnit.m_20280_((Entity)target) <= 16.0) || nearestAlly != null && !(wsUnit.m_20280_((Entity)nearestAlly) > 16.0)) continue;
                cloud.use(this.getEntity().m_9236_(), this.unit, (BlockPos)null);
            }
        }
    }

    public void idleCommand() {
        AttackerUnit aUnit;
        Unit unit;
        if (this.unit instanceof CreeperUnit || (unit = this.unit) instanceof AttackerUnit && (aUnit = (AttackerUnit)((Object)unit)).canAttackBuildings()) {
            this.attackMoveNearestBuilding();
        } else {
            this.attackMoveNearestUnit();
        }
    }

    public void retaliateCommand() {
    }

    private BuildingPlacement getNearestAttackableBuilding() {
        List<BuildingPlacement> buildings = BuildingServerEvents.getBuildings().stream().filter(b -> !"Enemy".equals(b.ownerName) && !b.ownerName.isBlank() && !b.getBuilding().invulnerable).sorted(Comparator.comparing(b -> b.centrePos.m_203193_((Position)((Entity)this.unit).m_20182_()))).toList();
        Object targetBp = null;
        if (!buildings.isEmpty()) {
            return buildings.get(0);
        }
        return null;
    }

    private LivingEntity getNearestAttackableUnit() {
        List<LivingEntity> entities = UnitServerEvents.getAllUnits().stream().filter(le -> {
            Unit u;
            return le instanceof Unit && !"Enemy".equals((u = (Unit)le).getOwnerName()) && !u.getOwnerName().isBlank();
        }).sorted(Comparator.comparing(le -> le.m_20182_().m_82557_(((Entity)this.unit).m_20182_()))).toList();
        Object targetBp = null;
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    private LivingEntity getNearestAttackableWorkerUnit() {
        List<LivingEntity> entities = UnitServerEvents.getAllUnits().stream().filter(le -> {
            if (!(le instanceof Unit)) return false;
            Unit u = (Unit)le;
            if (!(le instanceof WorkerUnit)) return false;
            if ("Enemy".equals(u.getOwnerName())) return false;
            if (u.getOwnerName().isBlank()) return false;
            return true;
        }).sorted(Comparator.comparing(le -> le.m_20182_().m_82557_(((Entity)this.unit).m_20182_()))).toList();
        Object targetBp = null;
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    private LivingEntity getNearestNonWitherAllyUnit() {
        List<LivingEntity> entities = UnitServerEvents.getAllUnits().stream().filter(le -> {
            Unit u;
            return le instanceof Unit && !((u = (Unit)le) instanceof WitherSkeletonUnit) && "Enemy".equals(u.getOwnerName()) && !u.getOwnerName().isBlank();
        }).sorted(Comparator.comparing(le -> le.m_20182_().m_82557_(((Entity)this.unit).m_20182_()))).toList();
        Object targetBp = null;
        if (!entities.isEmpty()) {
            return entities.get(0);
        }
        return null;
    }

    private void attackMoveNearestBuilding() {
        this.unit.resetBehaviours();
        Entity entity = (Entity)this.unit;
        BuildingPlacement nearestBuilding = this.getNearestAttackableBuilding();
        BlockPos targetBp = null;
        if (nearestBuilding != null) {
            targetBp = nearestBuilding.getClosestGroundPos(((Entity)this.unit).m_20097_(), 1);
        }
        if (targetBp != null) {
            if (this.unit instanceof AttackerUnit) {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.ATTACK_MOVE, -1, new int[]{entity.m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            } else {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.MOVE, -1, new int[]{entity.m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            }
        }
    }

    private void attackMoveRandomBuilding() {
        this.unit.resetBehaviours();
        ArrayList<BuildingPlacement> buildings = BuildingServerEvents.getBuildings();
        Collections.shuffle(buildings);
        List<BuildingPlacement> playerBuildings = buildings.stream().filter(b -> !"Enemy".equals(b.ownerName) && !b.ownerName.isBlank()).toList();
        BlockPos targetBp = null;
        if (!playerBuildings.isEmpty()) {
            targetBp = buildings.get(0).getClosestGroundPos(((Entity)this.unit).m_20097_(), 1);
        }
        if (targetBp != null) {
            if (this.unit instanceof AttackerUnit) {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.ATTACK_MOVE, -1, new int[]{((Entity)this.unit).m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            } else {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.MOVE, -1, new int[]{((Entity)this.unit).m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            }
        }
    }

    private void attackMoveNearestUnit() {
        LivingEntity nearestWorker;
        this.unit.resetBehaviours();
        Entity entity = (Entity)this.unit;
        LivingEntity nearestUnit = this.getNearestAttackableUnit();
        if (this.unit instanceof SpiderUnit && (nearestWorker = this.getNearestAttackableWorkerUnit()) != null) {
            nearestUnit = nearestWorker;
        }
        BlockPos targetBp = null;
        if (nearestUnit != null) {
            targetBp = nearestUnit.m_20097_();
        }
        if (targetBp != null) {
            if (this.unit instanceof AttackerUnit) {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.ATTACK_MOVE, -1, new int[]{((Entity)this.unit).m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            } else {
                UnitServerEvents.addActionItem(this.unit.getOwnerName(), UnitAction.MOVE, -1, new int[]{((Entity)this.unit).m_19879_()}, targetBp, new BlockPos(0, 0, 0));
            }
        }
    }
}

