/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.building.buildings.placements.IronGolemPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.shared.AbstractFarm;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hero.HeroServerboundPacket;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.NonUnitClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitActionItem;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitActionServerboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncServerboundPacket;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.PhantomSummon;
import com.solegendary.reignofnether.unit.units.monsters.WardenUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemUnit;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.unit.units.villagers.WitchUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import com.solegendary.reignofnether.util.MyRenderer;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3d;

public class UnitClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final int WINDOW_RADIUS = 5;
    public static final int WINDOW_UPDATE_TICKS_MAX = 5;
    public static final List<ArrayList<Vec3>> unitWindowVecs = Collections.synchronizedList(new ArrayList());
    public static final List<BlockPos> windowPositions = Collections.synchronizedList(new ArrayList());
    public static int windowUpdateTicks = 5;
    public static final ArrayList<Integer> idleWorkerIds = new ArrayList();
    private static final ArrayList<LivingEntity> preselectedUnits = new ArrayList();
    private static final ArrayList<LivingEntity> selectedUnits = new ArrayList();
    private static final ArrayList<LivingEntity> allUnits = new ArrayList();
    @Nullable
    private static UnitActionItem lastClientUAIActioned = null;
    private static long lastLeftClickTime = 0L;
    private static final long DOUBLE_CLICK_TIME_MS = 500L;
    private static final int VIS_CHECK_TICKS_MAX = 10;
    private static int ticksToNextVisCheck = 10;
    public static RenderLevelStageEvent.Stage stage = RenderLevelStageEvent.Stage.AFTER_ENTITIES;

    public static ArrayList<LivingEntity> getPreselectedUnits() {
        return preselectedUnits;
    }

    public static ArrayList<LivingEntity> getSelectedUnits() {
        return selectedUnits;
    }

    public static ArrayList<LivingEntity> getSortedSelectedUnits() {
        ArrayList<LivingEntity> units = UnitClientEvents.getSelectedUnits();
        units.sort(Comparator.comparing(HudClientEvents::getModifiedEntityName));
        ArrayList heroUnits = new ArrayList();
        units.removeIf(le -> {
            if (le instanceof HeroUnit) {
                heroUnits.add(le);
                return true;
            }
            return false;
        });
        for (LivingEntity heroUnit : heroUnits) {
            units.add(0, heroUnit);
        }
        return units;
    }

    public static ArrayList<LivingEntity> getAllUnits() {
        return allUnits;
    }

    public static void addPreselectedUnit(LivingEntity unit) {
        Player player;
        if (unit instanceof Player && ((player = (Player)unit).m_5833_() || player.m_7500_())) {
            return;
        }
        if (!FogOfWarClientEvents.isInBrightChunk((Entity)unit)) {
            return;
        }
        if (unit.m_20159_()) {
            return;
        }
        preselectedUnits.add(unit);
    }

    public static void addSelectedUnit(LivingEntity unit) {
        CursorClientEvents.setLeftClickAction(null);
        if (!FogOfWarClientEvents.isInBrightChunk((Entity)unit)) {
            return;
        }
        if (unit.m_20159_()) {
            return;
        }
        selectedUnits.add(unit);
        selectedUnits.sort(Comparator.comparing(MiscUtil::getSimpleEntityName));
        selectedUnits.sort(Comparator.comparing(Entity::m_19879_));
        BuildingClientEvents.clearSelectedBuildings();
        NonUnitClientEvents.isMoveCheckpointGreen = true;
    }

    public static void clearPreselectedUnits() {
        preselectedUnits.clear();
    }

    public static void clearSelectedUnits() {
        selectedUnits.clear();
        NonUnitClientEvents.isMoveCheckpointGreen = true;
    }

    private static boolean isLeftClickAttack() {
        return CursorClientEvents.getLeftClickAction() == UnitAction.ATTACK;
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent evt) {
        if (evt.getLevel().m_5776_()) {
            selectedUnits.removeIf(e -> e.m_19879_() == evt.getEntityMounting().m_19879_());
        }
    }

    public static int getCurrentPopulation(String playerName) {
        int currentPopulation = 0;
        if (UnitClientEvents.MC.f_91073_ != null) {
            for (LivingEntity entity : allUnits) {
                Unit unit;
                if (!(entity instanceof Unit) || !(unit = (Unit)entity).getOwnerName().equals(playerName)) continue;
                currentPopulation += unit.getCost().population;
            }
            for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                if (!building.ownerName.equals(playerName)) continue;
                if (building instanceof ProductionPlacement) {
                    ProductionPlacement prodBuilding = (ProductionPlacement)building;
                    for (ActiveProduction prodItem : prodBuilding.productionQueue) {
                        currentPopulation += prodItem.item.getCost((boolean)true, (String)playerName).population;
                    }
                    continue;
                }
                if (!(building instanceof IronGolemPlacement)) continue;
                currentPopulation += ResourceCosts.IRON_GOLEM.population;
            }
        }
        return currentPopulation;
    }

    public static void sendUnitCommandManual(String playerName, UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos) {
        if (UnitClientEvents.MC.f_91074_ != null && playerName.equals(UnitClientEvents.MC.f_91074_.m_7755_().getString())) {
            UnitClientEvents.sendUnitCommandManual(action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos);
        }
    }

    public static void sendUnitCommandManual(UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos) {
        UnitClientEvents.sendUnitCommandManual(action, unitId, unitIds, preselectedBlockPos, new BlockPos(0, 0, 0));
    }

    public static void sendUnitCommandManual(UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, boolean clientside, boolean serverside) {
        UnitClientEvents.sendUnitCommandManual(action, unitId, unitIds, preselectedBlockPos, new BlockPos(0, 0, 0), clientside, serverside);
    }

    public static void sendUnitCommandManual(UnitAction action, int unitId, int[] unitIds) {
        UnitClientEvents.sendUnitCommandManual(action, unitId, unitIds, new BlockPos(0, 0, 0), new BlockPos(0, 0, 0));
    }

    public static void sendUnitCommandManual(UnitAction action, int[] unitIds) {
        UnitClientEvents.sendUnitCommandManual(action, -1, unitIds, new BlockPos(0, 0, 0), new BlockPos(0, 0, 0));
    }

    public static void sendUnitCommandManual(UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos) {
        if (UnitClientEvents.MC.f_91074_ != null) {
            UnitActionItem actionItem = new UnitActionItem(UnitClientEvents.MC.f_91074_.m_7755_().getString(), action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos);
            if (!actionItem.equals(lastClientUAIActioned)) {
                actionItem.action((Level)UnitClientEvents.MC.f_91073_);
                lastClientUAIActioned = actionItem;
            }
            PacketHandler.INSTANCE.sendToServer((Object)new UnitActionServerboundPacket(UnitClientEvents.MC.f_91074_.m_7755_().getString(), action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos, Keybindings.shiftMod.isDown()));
        }
    }

    public static void sendUnitCommandManual(UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos, boolean clientside, boolean serverside) {
        if (UnitClientEvents.MC.f_91074_ != null) {
            if (clientside) {
                UnitActionItem actionItem = new UnitActionItem(UnitClientEvents.MC.f_91074_.m_7755_().getString(), action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos);
                actionItem.action((Level)UnitClientEvents.MC.f_91073_);
            }
            if (serverside) {
                PacketHandler.INSTANCE.sendToServer((Object)new UnitActionServerboundPacket(UnitClientEvents.MC.f_91074_.m_7755_().getString(), action, unitId, unitIds, preselectedBlockPos, selectedBuildingPos, Keybindings.shiftMod.isDown()));
            }
        }
    }

    public static void sendUnitCommand(UnitAction action) {
        BlockPos bp = CursorClientEvents.getPreselectedBlockPos();
        if (action.name().toLowerCase().contains("startrts")) {
            if (action == UnitAction.STARTRTS_VILLAGERS) {
                PlayerServerboundPacket.startRTS(Faction.VILLAGERS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            } else if (action == UnitAction.STARTRTS_MONSTERS) {
                PlayerServerboundPacket.startRTS(Faction.MONSTERS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            } else if (action == UnitAction.STARTRTS_PIGLINS) {
                PlayerServerboundPacket.startRTS(Faction.PIGLINS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            }
            return;
        }
        if (action.name().toLowerCase().contains("sandbox_spawn")) {
            if (action == UnitAction.STARTRTS_VILLAGERS) {
                PlayerServerboundPacket.startRTS(Faction.VILLAGERS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            } else if (action == UnitAction.STARTRTS_MONSTERS) {
                PlayerServerboundPacket.startRTS(Faction.MONSTERS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            } else if (action == UnitAction.STARTRTS_PIGLINS) {
                PlayerServerboundPacket.startRTS(Faction.PIGLINS, Double.valueOf(bp.m_123341_()), Double.valueOf(bp.m_123342_()), Double.valueOf(bp.m_123343_()));
            }
            return;
        }
        if (UnitClientEvents.MC.f_91074_ != null) {
            int[] selUnits = selectedUnits.stream().filter(u -> {
                if (u instanceof Unit) {
                    Unit unit = (Unit)u;
                    for (Ability ability : unit.getAbilities().get()) {
                        if (!ability.isCasting(unit) || !ability.oneClickOneUse || ability.action != action) continue;
                        return false;
                    }
                }
                return true;
            }).mapToInt(Entity::m_19879_).toArray();
            String playerName = UnitClientEvents.MC.f_91074_.m_7755_().getString();
            LivingEntity livingEntity = HudClientEvents.hudSelectedEntity;
            if (livingEntity instanceof Unit) {
                Unit unit = (Unit)livingEntity;
                if (AlliancesClient.canControlAlly(HudClientEvents.hudSelectedEntity)) {
                    playerName = unit.getOwnerName();
                }
            }
            UnitActionItem actionItem = new UnitActionItem(playerName, action, preselectedUnits.size() > 0 ? preselectedUnits.get(0).m_19879_() : -1, selUnits, bp, HudClientEvents.hudSelectedPlacement != null ? HudClientEvents.hudSelectedPlacement.originPos : new BlockPos(0, 0, 0));
            actionItem.action((Level)UnitClientEvents.MC.f_91073_);
            PacketHandler.INSTANCE.sendToServer((Object)new UnitActionServerboundPacket(playerName, action, preselectedUnits.size() > 0 ? preselectedUnits.get(0).m_19879_() : -1, selUnits, bp, HudClientEvents.hudSelectedPlacement != null ? HudClientEvents.hudSelectedPlacement.originPos : new BlockPos(0, 0, 0), Keybindings.shiftMod.isDown()));
        }
    }

    private static void resolveMoveAction() {
        if (preselectedUnits.size() == 1 && !UnitClientEvents.targetingSelf()) {
            LivingEntity livingEntity = HudClientEvents.hudSelectedEntity;
            if (livingEntity instanceof WitchUnit) {
                WitchUnit witchUnit = (WitchUnit)livingEntity;
                UnitClientEvents.sendUnitCommand(UnitAction.THROW_LINGERING_REGEN_POTION);
            } else {
                UnitClientEvents.sendUnitCommand(UnitAction.FOLLOW);
            }
        } else if (!Keybindings.altMod.isDown() && selectedUnits.size() > 0 && UnitClientEvents.MC.f_91073_ != null) {
            ResourceName resName = ResourceSources.getBlockResourceName(CursorClientEvents.getPreselectedBlockPos(), (Level)UnitClientEvents.MC.f_91073_);
            boolean isGathering = HudClientEvents.hudSelectedEntity instanceof WorkerUnit && resName != ResourceName.NONE;
            UnitClientEvents.sendUnitCommand(UnitAction.MOVE);
            for (LivingEntity le : selectedUnits) {
                Unit unit;
                if (isGathering || !(le instanceof Unit) || (unit = (Unit)le).getMoveGoal() == null) continue;
                unit.getMoveGoal().lastSelectedMoveTarget = CursorClientEvents.getPreselectedBlockPos();
            }
        }
    }

    public static ResourceName getSelectedUnitResourceTarget() {
        LivingEntity entity = HudClientEvents.hudSelectedEntity;
        if (entity instanceof WorkerUnit) {
            WorkerUnit workerUnit = (WorkerUnit)entity;
            return workerUnit.getGatherResourceGoal().getTargetResourceName();
        }
        return ResourceName.NONE;
    }

    public static void syncOwnerName(int entityId, String ownerName) {
        for (LivingEntity entity : allUnits) {
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.setOwnerName(ownerName);
        }
    }

    public static void syncUnitStats(int entityId, float health, float absorb, Vec3 pos, String ownerName) {
        for (LivingEntity entity : allUnits) {
            boolean isLoadedClientside;
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null) continue;
            boolean bl = isLoadedClientside = UnitClientEvents.MC.f_91073_.m_6815_(entityId) != null;
            if (!isLoadedClientside) {
                entity.m_21153_(health);
                entity.m_146884_(pos);
            }
            entity.m_7911_(absorb);
            MinimapClientEvents.removeMinimapUnit(entityId);
            return;
        }
        MinimapClientEvents.syncMinimapUnits(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), entityId, ownerName);
    }

    public static void syncWorkerUnit(int entityId, boolean isBuilding, ResourceName gatherName, BlockPos gatherPos, int gatherTicks) {
        for (LivingEntity entity : allUnits) {
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null || !(entity instanceof WorkerUnit)) continue;
            WorkerUnit workerUnit = (WorkerUnit)entity;
            workerUnit.getBuildRepairGoal().setIsBuildingServerside(isBuilding);
            workerUnit.getGatherResourceGoal().syncFromServer(gatherName, gatherPos, gatherTicks);
        }
    }

    public static void syncUnitResources(int entityId, Resources res) {
        for (LivingEntity entity : allUnits) {
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.getItems().removeIf(i -> !ResourceSources.isPreparedFood(i.m_41720_()));
            unit.getItems().add(new ItemStack((ItemLike)Items.f_42501_, res.food));
            unit.getItems().add(new ItemStack((ItemLike)Items.f_42398_, res.wood));
            unit.getItems().add(new ItemStack((ItemLike)Items.f_41905_, res.ore));
        }
    }

    public static void syncAnchorPos(int entityId, BlockPos bp) {
        for (LivingEntity entity : allUnits) {
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.setAnchor(bp);
            break;
        }
    }

    public static void removeAnchorPos(int entityId) {
        for (LivingEntity entity : allUnits) {
            if (entity.m_19879_() != entityId || UnitClientEvents.MC.f_91073_ == null || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.setAnchor(null);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (--ticksToNextVisCheck <= 0) {
            ticksToNextVisCheck = 10;
            selectedUnits.removeIf(e -> !FogOfWarClientEvents.isInBrightChunk((Entity)e));
        }
        if (UnitClientEvents.MC.f_91074_ != null && OrthoviewClientEvents.hideLeavesMethod == OrthoviewClientEvents.LeafHideMethod.AROUND_UNITS_AND_CURSOR && OrthoviewClientEvents.isEnabled()) {
            List<BlockPos> list = windowPositions;
            synchronized (list) {
                windowPositions.clear();
                UnitClientEvents.getAllUnits().forEach(u -> {
                    if (FogOfWarClientEvents.isInBrightChunk((Entity)u)) {
                        windowPositions.add(u.m_20097_());
                    }
                });
                BlockPos cursorBp = CursorClientEvents.getPreselectedBlockPos();
                windowPositions.add(cursorBp);
                List<ArrayList<Vec3>> list2 = unitWindowVecs;
                synchronized (list2) {
                    unitWindowVecs.clear();
                    windowPositions.forEach(bp -> {
                        float dist = Math.max(120.0f, OrthoviewClientEvents.getZoom() * 2.0f);
                        if (bp.m_123331_((Vec3i)UnitClientEvents.MC.f_91074_.m_20097_()) < (double)(dist * dist)) {
                            unitWindowVecs.add(MyMath.prepIsPointInsideRect3d(Minecraft.m_91087_(), new Vector3d((double)(bp.m_123341_() - 5), (double)bp.m_123342_(), (double)(bp.m_123343_() - 5)), new Vector3d((double)(bp.m_123341_() - 5), (double)bp.m_123342_(), (double)(bp.m_123343_() + 5)), new Vector3d((double)(bp.m_123341_() + 5), (double)bp.m_123342_(), (double)(bp.m_123343_() + 5))));
                        }
                    });
                }
            }
        }
        List<Object> list = windowPositions;
        synchronized (list) {
            windowPositions.clear();
        }
        list = unitWindowVecs;
        synchronized (list) {
            unitWindowVecs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntityLeaveEvent(EntityLeaveLevelEvent evt) {
        try {
            ArrayList<Integer> arrayList = idleWorkerIds;
            synchronized (arrayList) {
                idleWorkerIds.removeIf(id -> id.intValue() == evt.getEntity().m_19879_());
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.warn("Error while trying to remove an idleWorkerId");
        }
    }

    public static void onEntityLeave(int entityId) {
        selectedUnits.removeIf(e -> e.m_19879_() == entityId);
        preselectedUnits.removeIf(e -> e.m_19879_() == entityId);
        allUnits.removeIf(e -> e.m_19879_() == entityId);
        MinimapClientEvents.removeMinimapUnit(entityId);
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent evt) {
        LivingEntity le;
        Entity entity = evt.getEntity();
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            if (evt.getLevel().f_46443_) {
                TutorialClientEvents.updateStage();
                if (selectedUnits.removeIf(e -> e.m_19879_() == entity.m_19879_())) {
                    selectedUnits.add((LivingEntity)entity);
                }
                if (preselectedUnits.removeIf(e -> e.m_19879_() == entity.m_19879_())) {
                    preselectedUnits.add((LivingEntity)entity);
                }
                allUnits.removeIf(e -> e.m_19879_() == entity.m_19879_());
                allUnits.add((LivingEntity)entity);
                unit.initialiseGoals();
                unit.setupEquipmentAndUpgradesClient();
                UnitClientEvents.addUnitPoofs(evt.getLevel(), entity);
                UnitSyncServerboundPacket.requestSyncAbilities(entity.m_19879_());
                if (entity instanceof HeroUnit) {
                    HeroServerboundPacket.requestHeroSync(entity.m_19879_());
                }
            }
        }
        if (entity instanceof LivingEntity && (ResourceSources.isHuntableAnimal(le = (LivingEntity)entity) || le instanceof PhantomSummon)) {
            UnitClientEvents.addUnitPoofs(evt.getLevel(), entity);
        }
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        block44: {
            block45: {
                block40: {
                    block42: {
                        block43: {
                            block41: {
                                if (!OrthoviewClientEvents.isEnabled()) {
                                    return;
                                }
                                if (UnitClientEvents.MC.f_91073_ == null) {
                                    return;
                                }
                                if (HudClientEvents.isMouseOverAnyButtonOrHud()) {
                                    CursorClientEvents.setLeftClickAction(null);
                                    return;
                                }
                                if (evt.getButton() != 0) break block40;
                                if (UnitClientEvents.selectedUnits.size() <= 0 || !UnitClientEvents.isLeftClickAttack()) break block41;
                                if (UnitClientEvents.preselectedUnits.size() == 1 && !UnitClientEvents.targetingSelf()) {
                                    UnitClientEvents.sendUnitCommand(UnitAction.ATTACK);
                                } else if (BuildingClientEvents.getPreselectedBuilding() != null) {
                                    UnitClientEvents.sendUnitCommand(UnitAction.ATTACK_BUILDING);
                                } else {
                                    UnitClientEvents.sendUnitCommand(UnitAction.ATTACK_MOVE);
                                }
                                break block42;
                            }
                            if (UnitClientEvents.selectedUnits.size() != 1 || UnitClientEvents.MC.f_91073_ == null || Keybindings.shiftMod.isDown() || System.currentTimeMillis() - UnitClientEvents.lastLeftClickTime >= 500L && !Keybindings.ctrlMod.isDown() || UnitClientEvents.preselectedUnits.size() <= 0 || !UnitClientEvents.selectedUnits.contains(UnitClientEvents.preselectedUnits.get(0))) break block43;
                            UnitClientEvents.lastLeftClickTime = 0L;
                            selectedUnit = UnitClientEvents.selectedUnits.get(0);
                            nearbyEntities = MiscUtil.getEntitiesWithinRange(new Vector3d(selectedUnit.m_20182_().f_82479_, selectedUnit.m_20182_().f_82480_, selectedUnit.m_20182_().f_82481_), OrthoviewClientEvents.getZoom(), UnitClientEvents.selectedUnits.get(0).getClass(), (Level)UnitClientEvents.MC.f_91073_);
                            if (UnitClientEvents.getPlayerToEntityRelationship(selectedUnit) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(selectedUnit)) break block42;
                            UnitClientEvents.clearSelectedUnits();
                            for (LivingEntity entity : nearbyEntities) {
                                v0 = bothVillagers = entity instanceof VillagerUnit != false && selectedUnit instanceof VillagerUnit != false;
                                if (!(entity instanceof VillagerUnit)) ** GOTO lbl-1000
                                vUnit1 = (VillagerUnit)entity;
                                if (!(selectedUnit instanceof VillagerUnit)) ** GOTO lbl-1000
                                vUnit2 = (VillagerUnit)selectedUnit;
                                if (vUnit1.getUnitProfession() == vUnit2.getUnitProfession()) {
                                    v1 = true;
                                } else lbl-1000:
                                // 3 sources

                                {
                                    v1 = false;
                                }
                                sameProfession = v1;
                                garrisoned1 = selectedUnit instanceof Unit != false && GarrisonableBuilding.getGarrison(unit1 = (Unit)selectedUnit) != null;
                                garrisoned2 = entity instanceof Unit != false && GarrisonableBuilding.getGarrison(unit2 = (Unit)entity) != null;
                                v2 = garrionStatusMatches = garrisoned1 != false && garrisoned2 != false || garrisoned1 == false && garrisoned2 == false;
                                if (UnitClientEvents.getPlayerToEntityRelationship(entity) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(entity) || bothVillagers && !sameProfession || !garrionStatusMatches) continue;
                                UnitClientEvents.addSelectedUnit(entity);
                            }
                            HudClientEvents.setLowestCdHudEntity();
                            break block42;
                        }
                        if (CursorClientEvents.getLeftClickAction() == UnitAction.MOVE) {
                            UnitClientEvents.resolveMoveAction();
                        } else if (CursorClientEvents.getLeftClickAction() != null && UnitClientEvents.MC.f_91074_ != null) {
                            UnitClientEvents.sendUnitCommand(CursorClientEvents.getLeftClickAction());
                        } else if (UnitClientEvents.preselectedUnits.size() == 1 && !UnitClientEvents.isLeftClickAttack()) {
                            deselected = false;
                            if (Keybindings.shiftMod.isDown()) {
                                deselected = UnitClientEvents.selectedUnits.removeIf((Predicate<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onMouseClick$14(net.minecraft.world.entity.LivingEntity ), (Lnet/minecraft/world/entity/LivingEntity;)Z)());
                            }
                            if (Keybindings.shiftMod.isDown() && !deselected && (UnitClientEvents.preselectedUnits.get(0) instanceof Unit && UnitClientEvents.getPlayerToEntityRelationship(UnitClientEvents.preselectedUnits.get(0)) == Relationship.OWNED || AlliancesClient.canControlAlly(UnitClientEvents.preselectedUnits.get(0)) || NonUnitClientEvents.canControlAllMobs())) {
                                UnitClientEvents.addSelectedUnit(UnitClientEvents.preselectedUnits.get(0));
                            } else if (!deselected) {
                                UnitClientEvents.clearSelectedUnits();
                                UnitClientEvents.addSelectedUnit(UnitClientEvents.preselectedUnits.get(0));
                            }
                        }
                    }
                    if (UnitClientEvents.selectedUnits.size() > 1) {
                        UnitClientEvents.selectedUnits.removeIf((Predicate<LivingEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onMouseClick$15(net.minecraft.world.entity.LivingEntity ), (Lnet/minecraft/world/entity/LivingEntity;)Z)());
                    }
                    UnitClientEvents.lastLeftClickTime = System.currentTimeMillis();
                    break block44;
                }
                if (evt.getButton() != 1) break block44;
                if (BuildingClientEvents.getBuildingToPlace() != null) {
                    BuildingClientEvents.setBuildingToPlace(null);
                    return;
                }
                if (UnitClientEvents.selectedUnits.size() <= 0) break block44;
                preSelBuilding = BuildingClientEvents.getPreselectedBuilding();
                if (UnitClientEvents.preselectedUnits.size() != 1 || !UnitClientEvents.canMountUnit(HudClientEvents.hudSelectedEntity, UnitClientEvents.preselectedUnits.get(0))) break block45;
                if (HudClientEvents.hudSelectedEntity instanceof PillagerUnit && UnitClientEvents.getPreselectedUnits().get(0) instanceof RavagerUnit) {
                    UnitClientEvents.sendUnitCommand(UnitAction.MOUNT_RAVAGER);
                }
                if (HudClientEvents.hudSelectedEntity instanceof HeadhunterUnit && UnitClientEvents.getPreselectedUnits().get(0) instanceof HoglinUnit) {
                    UnitClientEvents.sendUnitCommand(UnitAction.MOUNT_HOGLIN);
                }
                if (HudClientEvents.hudSelectedEntity instanceof Unit && HudClientEvents.hudSelectedEntity instanceof Skeleton && UnitClientEvents.getPreselectedUnits().get(0) instanceof RavagerUnit) {
                    UnitClientEvents.sendUnitCommand(UnitAction.MOUNT_SPIDER);
                }
                break block44;
            }
            if (!(preSelBuilding instanceof GarrisonableBuilding)) ** GOTO lbl-1000
            garr = (GarrisonableBuilding)preSelBuilding;
            if (HudClientEvents.hudSelectedEntity instanceof RangedAttackerUnit && (bothVillagers = HudClientEvents.hudSelectedEntity) instanceof Unit && (unit = (Unit)bothVillagers).canGarrison() && preSelBuilding.ownerName.equals(unit.getOwnerName())) {
                UnitClientEvents.sendUnitCommand(UnitAction.GARRISON);
            } else if (UnitClientEvents.preselectedUnits.size() == 1 && !UnitClientEvents.targetingSelf() && (HudClientEvents.hudSelectedEntity instanceof Unit || NonUnitClientEvents.canAttack(HudClientEvents.hudSelectedEntity)) && (GameruleClient.neutralAggro && UnitClientEvents.getPlayerToEntityRelationship(UnitClientEvents.preselectedUnits.get(0)) == Relationship.NEUTRAL || UnitClientEvents.getPlayerToEntityRelationship(UnitClientEvents.preselectedUnits.get(0)) == Relationship.HOSTILE || ResourceSources.isHuntableAnimal(UnitClientEvents.preselectedUnits.get(0)))) {
                var6_13 = HudClientEvents.hudSelectedEntity;
                if (var6_13 instanceof WitchUnit) {
                    witchUnit = (WitchUnit)var6_13;
                    UnitClientEvents.sendUnitCommand(UnitAction.THROW_LINGERING_HARMING_POTION);
                } else {
                    UnitClientEvents.sendUnitCommand(UnitAction.ATTACK);
                }
            } else if (HudClientEvents.hudSelectedEntity instanceof AttackerUnit && preSelBuilding != null && !preSelBuilding.getBuilding().invulnerable && !(preSelBuilding instanceof BridgePlacement) && (GameruleClient.neutralAggro && BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) == Relationship.NEUTRAL || BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) == Relationship.HOSTILE)) {
                UnitClientEvents.sendUnitCommand(UnitAction.ATTACK_BUILDING);
            } else {
                var5_11 = HudClientEvents.hudSelectedEntity;
                if (var5_11 instanceof Unit && (unit = (Unit)var5_11).getReturnResourcesGoal() != null && Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue() > 0 && preSelBuilding != null && preSelBuilding.getBuilding().canAcceptResources && preSelBuilding.isBuilt && unit.getOwnerName().equals(preSelBuilding.ownerName)) {
                    UnitClientEvents.sendUnitCommand(UnitAction.RETURN_RESOURCES);
                } else if (HudClientEvents.hudSelectedEntity instanceof WorkerUnit && preSelBuilding != null && (BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) == Relationship.OWNED || AlliancesClient.canControlAlly(HudClientEvents.hudSelectedEntity)) || preSelBuilding instanceof BridgePlacement) {
                    if (preSelBuilding.getBuilding() instanceof AbstractFarm && preSelBuilding.isBuilt) {
                        UnitClientEvents.sendUnitCommand(UnitAction.FARM);
                    } else if (BuildingUtils.isBuildingBuildable(true, preSelBuilding)) {
                        UnitClientEvents.sendUnitCommand(UnitAction.BUILD_REPAIR);
                    } else {
                        UnitClientEvents.resolveMoveAction();
                    }
                } else {
                    UnitClientEvents.resolveMoveAction();
                }
            }
        }
        CursorClientEvents.setLeftClickAction(null);
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (UnitClientEvents.MC.f_91073_ == null) {
            return;
        }
        if (evt.getStage() == stage) {
            ArrayList<LivingEntity> selectedUnits = UnitClientEvents.getSelectedUnits();
            ArrayList<LivingEntity> preselectedUnits = UnitClientEvents.getPreselectedUnits();
            HashSet<LivingEntity> unitsToDraw = new HashSet<LivingEntity>();
            unitsToDraw.addAll(selectedUnits);
            unitsToDraw.addAll(preselectedUnits);
            if (OrthoviewClientEvents.isEnabled()) {
                boolean isMouseOverAnyButtonOrHud = HudClientEvents.isMouseOverAnyButtonOrHud();
                boolean isLeftClickAttack = UnitClientEvents.isLeftClickAttack();
                boolean targetingSelf = UnitClientEvents.targetingSelf();
                boolean isRightClickDown = MiscUtil.isRightClickDown(MC);
                for (Entity entity : unitsToDraw) {
                    if (!FogOfWarClientEvents.isInBrightChunk(entity)) continue;
                    AABB entityAABB = entity.m_20191_();
                    if (entity instanceof PiglinMerchantUnit) {
                        entityAABB = entityAABB.m_82377_((double)0.6f, 0.0, (double)0.6f);
                        entityAABB.m_165893_(entityAABB.f_82292_ + (double)0.8f);
                    }
                    boolean isPreselected = preselectedUnits.contains(entity);
                    boolean isSelected = selectedUnits.contains(entity);
                    if (isPreselected && isLeftClickAttack && !targetingSelf && !isMouseOverAnyButtonOrHud) {
                        MyRenderer.drawLineBoxOutlineOnly(evt.getPoseStack(), entityAABB, 1.0f, 0.3f, 0.3f, 1.0f, false);
                        continue;
                    }
                    if (isSelected) {
                        MyRenderer.drawLineBoxOutlineOnly(evt.getPoseStack(), entityAABB, 1.0f, 1.0f, 1.0f, 1.0f, false);
                        continue;
                    }
                    if (!isPreselected || isMouseOverAnyButtonOrHud) continue;
                    MyRenderer.drawLineBoxOutlineOnly(evt.getPoseStack(), entityAABB, 1.0f, 1.0f, 1.0f, isRightClickDown ? 1.0f : 0.5f, false);
                }
            }
            List<Integer> selectedEntityIds = selectedUnits.stream().map(u -> u.m_19879_()).toList();
            for (LivingEntity entity : allUnits) {
                Unit unit;
                if (!FogOfWarClientEvents.isInBrightChunk((Entity)entity) || entity.m_20159_()) continue;
                float alpha = 0.5f;
                if (selectedEntityIds.contains(entity.m_19879_())) {
                    alpha = 1.0f;
                }
                AABB entityAABB = entity.m_20191_();
                if (entity instanceof PiglinMerchantUnit) {
                    entityAABB = entityAABB.m_82377_((double)0.6f, 0.0, (double)0.6f);
                }
                entityAABB = entityAABB.m_165893_(entityAABB.f_82289_);
                boolean bl = OrthoviewClientEvents.isEnabled();
                Color colorHex = entity instanceof Unit ? (PlayerClientEvents.isRTSPlayer((unit = (Unit)entity).getOwnerName()) ? new Color(PlayerColors.getPlayerDisplayColorHex(unit.getOwnerName())) : new Color(PlayerColors.COLOR_GRAY.hexCode, false)) : new Color(0xFFFFFF, false);
                float r = (float)colorHex.getRed() / 255.0f;
                float g = (float)colorHex.getGreen() / 255.0f;
                float b = (float)colorHex.getBlue() / 255.0f;
                if (OrthoviewClientEvents.isEnabled()) {
                    MyRenderer.drawLineBoxOutlineOnly(evt.getPoseStack(), entityAABB, 1.0f, 1.0f, 1.0f, alpha, bl);
                }
                MyRenderer.drawBoxBottom(evt.getPoseStack(), entityAABB, r, g, b, 0.5f);
            }
            for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                Unit unit;
                if (!(entity instanceof Unit) || !(unit = (Unit)entity).isEatingFood()) continue;
                MyRenderer.renderItemInFrontOfEntityFace(evt.getPoseStack(), entity, evt.getPartialTick(), new ItemStack((ItemLike)unit.getFoodBeingEaten()));
            }
        }
        if (OrthoviewClientEvents.isEnabled() && evt.getStage() == stage) {
            for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                Vec3 firstPos;
                if (!(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                float entityYOffset1 = 1.74f - ((LivingEntity)unit).m_20192_() - 1.0f;
                Vec3 lastPos = firstPos = ((LivingEntity)unit).m_146892_().m_82520_(0.0, (double)entityYOffset1, 0.0);
                for (Checkpoint cp : unit.getCheckpoints()) {
                    int n = Math.min(cp.ticksLeft, 15);
                    float a = (float)n / 15.0f * 0.5f;
                    if (cp.isForEntity()) {
                        MyRenderer.drawLine(evt.getPoseStack(), lastPos, cp.getPos(), cp.isGreen ? 0.0f : 1.0f, cp.isGreen ? 1.0f : 0.0f, 0.0f, a);
                        lastPos = cp.getPos();
                        continue;
                    }
                    MyRenderer.drawLine(evt.getPoseStack(), lastPos, cp.getPos(), cp.isGreen ? 0.0f : 1.0f, cp.isGreen ? 1.0f : 0.0f, 0.0f, a);
                    if (UnitClientEvents.MC.f_91073_.m_8055_(cp.bp.m_7918_(0, 1, 0)).m_60734_() instanceof SnowLayerBlock) {
                        AABB aabb = new AABB(cp.bp);
                        aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.13f);
                        MyRenderer.drawSolidBox(evt.getPoseStack(), aabb, Direction.UP, cp.isGreen ? 0.0f : 1.0f, cp.isGreen ? 1.0f : 0.0f, 0.0f, a, ResourceLocation.parse((String)"forge:textures/white.png"));
                    } else {
                        MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, cp.bp, cp.isGreen ? 0.0f : 1.0f, cp.isGreen ? 1.0f : 0.0f, 0.0f, a);
                    }
                    lastPos = cp.getPos();
                }
                if (!SandboxClientEvents.isSandboxPlayer() || unit.getAnchor() == null || unit.getAnchor().equals((Object)new BlockPos(0, 0, 0))) continue;
                BlockPos ap = unit.getAnchor();
                float a = MiscUtil.getOscillatingFloat(0.25, 0.75);
                Vec3 vec3 = new Vec3((double)((float)ap.m_123341_() + 0.5f), (double)((float)ap.m_123342_() + 1.0f), (double)((float)ap.m_123343_() + 0.5f));
                MyRenderer.drawLine(evt.getPoseStack(), firstPos, vec3, 1.0f, 1.0f, 0.0f, a);
                if (UnitClientEvents.MC.f_91073_.m_8055_(ap.m_7918_(0, 1, 0)).m_60734_() instanceof SnowLayerBlock) {
                    AABB aabb = new AABB(ap);
                    aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.13f);
                    MyRenderer.drawSolidBox(evt.getPoseStack(), aabb, Direction.UP, 1.0f, 1.0f, 0.0f, a, ResourceLocation.parse((String)"forge:textures/white.png"));
                    continue;
                }
                MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, ap, 1.0f, 1.0f, 0.0f, a);
            }
        }
    }

    @SubscribeEvent
    public static void onButtonPress(ScreenEvent.KeyPressed.Pre evt) {
        if (evt.getKeyCode() == 261) {
            boolean isSandboxPlayer = UnitClientEvents.MC.f_91074_ != null && SandboxClientEvents.isSandboxPlayer(UnitClientEvents.MC.f_91074_.m_7755_().getString());
            LivingEntity entity = HudClientEvents.hudSelectedEntity;
            if ((entity != null && UnitClientEvents.getPlayerToEntityRelationship(entity) == Relationship.OWNED || isSandboxPlayer) && !(entity instanceof CreeperUnit)) {
                UnitClientEvents.sendUnitCommand(UnitAction.DELETE);
            }
        }
    }

    public static boolean targetingSelf() {
        return selectedUnits.size() == 1 && preselectedUnits.size() == 1 && selectedUnits.get(0).equals((Object)preselectedUnits.get(0));
    }

    public static Relationship getPlayerToPlayerRelationship(String ownerName) {
        if (UnitClientEvents.MC.f_91073_ != null && UnitClientEvents.MC.f_91074_ != null) {
            if (ownerName == null || ownerName.isBlank()) {
                return Relationship.NEUTRAL;
            }
            String playerName = UnitClientEvents.MC.f_91074_.m_7755_().getString();
            if (playerName.equals(ownerName)) {
                return Relationship.OWNED;
            }
            if (AlliancesClient.isAllied(playerName, ownerName)) {
                return Relationship.FRIENDLY;
            }
            return Relationship.HOSTILE;
        }
        return Relationship.NEUTRAL;
    }

    public static Relationship getPlayerToEntityRelationship(LivingEntity entity) {
        if (UnitClientEvents.MC.f_91073_ != null && UnitClientEvents.MC.f_91074_ != null) {
            Unit unit;
            String playerName = UnitClientEvents.MC.f_91074_.m_7755_().getString();
            if (entity instanceof Unit && (unit = (Unit)entity).getOwnerName().isBlank()) {
                return Relationship.NEUTRAL;
            }
            if (entity instanceof Player) {
                Player playerEntity = (Player)entity;
                String entityName = playerEntity.m_7755_().getString();
                if (playerName.equals(entityName)) {
                    return Relationship.OWNED;
                }
                if (AlliancesClient.isAllied(playerName, entityName)) {
                    return Relationship.FRIENDLY;
                }
                return Relationship.HOSTILE;
            }
            if (!(entity instanceof Unit)) {
                return Relationship.NEUTRAL;
            }
            String ownerName = ((Unit)entity).getOwnerName();
            if (playerName.equals(ownerName)) {
                return Relationship.OWNED;
            }
            if (AlliancesClient.isAllied(playerName, ownerName)) {
                return Relationship.FRIENDLY;
            }
            return Relationship.HOSTILE;
        }
        return Relationship.NEUTRAL;
    }

    public static void syncConvertedUnits(String ownerName, int[] oldUnitIds, int[] newUnitIds) {
        for (int i = 0; i < oldUnitIds.length && UnitClientEvents.MC.f_91073_ != null; ++i) {
            Entity oldEntity = UnitClientEvents.MC.f_91073_.m_6815_(oldUnitIds[i]);
            Entity newEntity = UnitClientEvents.MC.f_91073_.m_6815_(newUnitIds[i]);
            if (oldEntity instanceof Unit) {
                Unit oldUnit = (Unit)oldEntity;
                if (newEntity instanceof Unit) {
                    Unit newUnit = (Unit)newEntity;
                    int j = i;
                    if (selectedUnits.removeIf(e -> e.m_19879_() == oldUnitIds[j])) {
                        selectedUnits.add((LivingEntity)newEntity);
                    }
                    HudClientEvents.convertControlGroups(oldUnitIds, newUnitIds);
                    if (oldUnit.getTargetGoal().getTarget() != null) {
                        UnitClientEvents.sendUnitCommandManual(UnitAction.ATTACK, oldUnit.getTargetGoal().getTarget().m_19879_(), new int[]{newEntity.m_19879_()});
                    }
                    if (oldUnit.getFollowTarget() != null) {
                        UnitClientEvents.sendUnitCommandManual(UnitAction.FOLLOW, oldUnit.getFollowTarget().m_19879_(), new int[]{newEntity.m_19879_()});
                    }
                    if (oldUnit.getMoveGoal().getMoveTarget() != null) {
                        UnitClientEvents.sendUnitCommandManual(UnitAction.MOVE, -1, new int[]{newEntity.m_19879_()}, oldUnit.getMoveGoal().getMoveTarget());
                    }
                    if (oldUnit.getReturnResourcesGoal() != null && oldUnit.getReturnResourcesGoal().getBuildingTarget() != null) {
                        UnitClientEvents.sendUnitCommandManual(UnitAction.RETURN_RESOURCES, -1, new int[]{newEntity.m_19879_()}, oldUnit.getReturnResourcesGoal().getBuildingTarget().originPos, new BlockPos(0, 0, 0));
                    }
                }
            }
            if (!(oldEntity instanceof AttackerUnit)) continue;
            AttackerUnit oldAUnit = (AttackerUnit)oldEntity;
            if (!(newEntity instanceof AttackerUnit)) continue;
            AttackerUnit newAUnit = (AttackerUnit)newEntity;
            if (oldAUnit.getAttackMoveTarget() == null) continue;
            UnitClientEvents.sendUnitCommandManual(UnitAction.ATTACK_MOVE, -1, new int[]{newEntity.m_19879_()}, oldAUnit.getAttackMoveTarget());
        }
        if (UnitClientEvents.MC.f_91073_ != null) {
            for (int id : oldUnitIds) {
                Entity e2 = UnitClientEvents.MC.f_91073_.m_6815_(id);
                if (!(e2 instanceof ConvertableUnit)) continue;
                ConvertableUnit cUnit = (ConvertableUnit)e2;
                cUnit.setShouldDiscard(true);
            }
        }
        UnitClientEvents.sendUnitCommandManual(UnitAction.DISCARD, oldUnitIds);
    }

    public static void syncUnitAnimation(UnitAnimationAction animAction, boolean startAnimation, int entityId, int targetId, BlockPos buildingBp) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            BruteUnit bUnit;
            GhastUnit gUnit;
            WardenUnit wUnit;
            EvokerUnit eUnit;
            if (entity instanceof EvokerUnit && (eUnit = (EvokerUnit)entity).m_19879_() == entityId) {
                if (eUnit.getCastFangsGoal() == null) continue;
                if (startAnimation) {
                    eUnit.getCastFangsGoal().startCasting();
                    continue;
                }
                eUnit.getCastFangsGoal().m_8041_();
                continue;
            }
            if (entity instanceof WardenUnit && (wUnit = (WardenUnit)entity).m_19879_() == entityId) {
                if (wUnit.getSonicBoomGoal() == null) continue;
                if (startAnimation) {
                    wUnit.startSonicBoomAnimation();
                    continue;
                }
                wUnit.stopSonicBoomAnimation();
                continue;
            }
            if (entity instanceof GhastUnit && (gUnit = (GhastUnit)entity).m_19879_() == entityId && startAnimation) {
                gUnit.showShootingFace();
                continue;
            }
            if (entity instanceof BruteUnit && (bUnit = (BruteUnit)entity).m_19879_() == entityId) {
                bUnit.isHoldingUpShield = startAnimation;
                continue;
            }
            if (entity instanceof WorkerUnit) {
                WorkerUnit wUnit2 = (WorkerUnit)entity;
                if (entity instanceof AttackerUnit) {
                    AttackerUnit aUnit = (AttackerUnit)entity;
                    if (entity.m_19879_() == entityId) {
                        if (startAnimation && UnitClientEvents.MC.f_91073_ != null) {
                            VillagerUnit vUnit;
                            if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).getUnitProfession() == VillagerUnitProfession.HUNTER && vUnit.isVeteran()) {
                                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                            } else {
                                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                            }
                            aUnit.setUnitAttackTarget((LivingEntity)UnitClientEvents.MC.f_91073_.m_6815_(targetId));
                            continue;
                        }
                        entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
                        aUnit.setUnitAttackTarget(null);
                        continue;
                    }
                }
            }
            if (!(entity instanceof VindicatorUnit) && !(entity instanceof MilitiaUnit) || entity.m_19879_() != entityId) continue;
            if (startAnimation && UnitClientEvents.MC.f_91073_ != null) {
                if (targetId > 0) {
                    ((AttackerUnit)entity).setUnitAttackTarget((LivingEntity)UnitClientEvents.MC.f_91073_.m_6815_(targetId));
                    continue;
                }
                ((AttackerUnit)entity).setAttackBuildingTarget(buildingBp);
                continue;
            }
            ((AttackerUnit)entity).setUnitAttackTarget(null);
            ((MeleeAttackBuildingGoal)((AttackerUnit)entity).getAttackBuildingGoal()).stopAttacking();
        }
    }

    public static void playKeyframeAnimation(UnitAnimationAction animAction, int entityId) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (!(entity instanceof KeyframeAnimated)) continue;
            KeyframeAnimated kfa = (KeyframeAnimated)entity;
            if (entity.m_19879_() != entityId) continue;
            kfa.playSingleAnimation(animAction);
            return;
        }
    }

    public static void playAttackAnimation(int entityId) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (entity.m_19879_() != entityId || !(entity instanceof IronGolemUnit) && !(entity instanceof HoglinUnit) && !(entity instanceof ZoglinUnit) && !(entity instanceof RavagerUnit) && !(entity instanceof WardenUnit)) continue;
            entity.m_7822_((byte)4);
        }
    }

    public static void syncIdleWorkers(int[] idleWorkerIds) {
        if (UnitClientEvents.MC.f_91073_ == null) {
            return;
        }
        UnitClientEvents.idleWorkerIds.clear();
        for (int id : idleWorkerIds) {
            for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                if (entity.m_19879_() != id || !(entity instanceof WorkerUnit)) continue;
                WorkerUnit unit = (WorkerUnit)entity;
                if (UnitClientEvents.getPlayerToEntityRelationship(entity) != Relationship.OWNED) continue;
                UnitClientEvents.idleWorkerIds.add(id);
            }
        }
    }

    public static void addUnitPoofs(Level level, Entity entity) {
        MiscUtil.addParticleExplosion(ParticleTypes.f_123759_, 35, level, entity.m_20182_());
    }

    public static void makeVillagerVeteran(int unitId) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (!(entity instanceof VillagerUnit)) continue;
            VillagerUnit vUnit = (VillagerUnit)entity;
            if (unitId != entity.m_19879_()) continue;
            vUnit.isVeteran = true;
        }
    }

    public static boolean canMountUnit(LivingEntity passenger, LivingEntity vehicle) {
        if (!(passenger instanceof Unit) || !(vehicle instanceof Unit)) {
            return false;
        }
        if (!((Unit)passenger).getOwnerName().equals(((Unit)vehicle).getOwnerName())) {
            return false;
        }
        if (HudClientEvents.hudSelectedEntity instanceof PillagerUnit && UnitClientEvents.getPreselectedUnits().get(0) instanceof RavagerUnit && ResearchClient.hasResearch(ProductionItems.RESEARCH_RAVAGER_CAVALRY)) {
            return true;
        }
        if (HudClientEvents.hudSelectedEntity instanceof HeadhunterUnit && UnitClientEvents.getPreselectedUnits().get(0) instanceof HoglinUnit && ResearchClient.hasResearch(ProductionItems.RESEARCH_HOGLIN_CAVALRY)) {
            return true;
        }
        return HudClientEvents.hudSelectedEntity instanceof Unit && HudClientEvents.hudSelectedEntity instanceof Skeleton && UnitClientEvents.getPreselectedUnits().get(0) instanceof RavagerUnit && ResearchClient.hasResearch(ProductionItems.RESEARCH_SPIDER_JOCKEYS);
    }

    public static List<LivingEntity> getMilitaryUnitsOnScreen() {
        ArrayList<Vec3> uvwpFull = MyMath.prepIsPointInsideRect3d(MC, 0, 0, 0, MC.m_91268_().m_85446_(), MC.m_91268_().m_85445_(), MC.m_91268_().m_85446_());
        ArrayList<LivingEntity> units = new ArrayList<LivingEntity>();
        for (LivingEntity entity : MiscUtil.getEntitiesWithinRange(CursorClientEvents.getCursorWorldPos(), 100.0f, LivingEntity.class, (Level)UnitClientEvents.MC.f_91073_)) {
            if (!MyMath.isPointInsideRect3d(uvwpFull, entity.m_20191_().m_82399_()) || entity.m_19879_() == UnitClientEvents.MC.f_91074_.m_19879_() || entity instanceof WorkerUnit || !(entity instanceof AttackerUnit) || GarrisonableBuilding.getGarrison((Unit)entity) != null || UnitClientEvents.getPlayerToEntityRelationship(entity) != Relationship.OWNED) continue;
            units.add(entity);
        }
        return units;
    }

    public static void syncUnitEatingFood(int unitId, int itemId) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (unitId != entity.m_19879_() || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            unit.getItems().add(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7942_(itemId)));
            break;
        }
    }

    public static void syncMobEffect(int entityId, int effectId, int amplifier, int duration) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            MobEffect effect = MobEffect.m_19453_((int)effectId);
            if (effect == null || entityId != entity.m_19879_() || !(entity instanceof Unit)) continue;
            if (duration > 0) {
                entity.m_7292_(new MobEffectInstance(effect, duration, amplifier));
                continue;
            }
            if (entity.m_21124_(effect) == null) continue;
            entity.m_21195_(effect);
        }
    }

    private static /* synthetic */ boolean lambda$onMouseClick$15(LivingEntity e) {
        return UnitClientEvents.getPlayerToEntityRelationship(e) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(e) || e.m_19879_() == UnitClientEvents.MC.f_91074_.m_19879_();
    }

    private static /* synthetic */ boolean lambda$onMouseClick$14(LivingEntity id) {
        return id.equals((Object)preselectedUnits.get(0));
    }
}

