/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.solegendary.reignofnether.unit.modelling.animations.NecromancerAnimations;
import com.solegendary.reignofnether.unit.modelling.models.KeyframeHierarchicalModel;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public class NecromancerModel<T extends Entity>
extends KeyframeHierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"necromancer_layer"), "main");
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart legL;
    private final ModelPart legR;
    private final ModelPart armR;
    private final ModelPart armL;
    private final ModelPart pads;
    private final ModelPart cape;
    private final ModelPart staff;

    public NecromancerModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.head = this.main.m_171324_("head");
        this.body = this.main.m_171324_("body");
        this.legL = this.main.m_171324_("legL");
        this.legR = this.main.m_171324_("legR");
        this.armR = this.main.m_171324_("armR");
        this.armL = this.main.m_171324_("armL");
        this.pads = this.main.m_171324_("pads");
        this.cape = this.main.m_171324_("cape");
        this.staff = this.main.m_171324_("staff");
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.main;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)1.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -11.5f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(12, 32).m_171488_(-4.0f, 0.5f, -2.0f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.5f, (float)1.0f));
        PartDefinition legL = main.m_171599_("legL", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)1.0f));
        PartDefinition legR = main.m_171599_("legR", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)1.0f));
        PartDefinition armR = main.m_171599_("armR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)-23.0f, (float)1.0f));
        PartDefinition armR_r1 = armR.m_171599_("armR_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1396f));
        PartDefinition armL = main.m_171599_("armL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)-22.0f, (float)1.0f));
        PartDefinition armL_r1 = armL.m_171599_("armL_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)-1.0455f, (float)0.0756f, (float)-0.0437f));
        PartDefinition pads = main.m_171599_("pads", CubeListBuilder.m_171558_().m_171514_(42, 32).m_171488_(-9.0f, -3.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(42, 44).m_171488_(4.0f, -3.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)1.0f));
        PartDefinition cape = main.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-8.0f, -1.0f, -1.0f, 16.0f, 23.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-23.0f, (float)-0.4f));
        PartDefinition staff = main.m_171599_("staff", CubeListBuilder.m_171558_().m_171514_(66, 41).m_171488_(-0.5f, -1.875f, -0.5f, 1.0f, 21.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(65, 32).m_171488_(-1.5f, -3.875f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(73, 47).m_171488_(-2.5f, -2.875f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(73, 47).m_171488_(1.5f, -2.875f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(73, 47).m_171488_(-0.5f, -2.875f, -2.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(73, 47).m_171488_(-0.5f, -2.875f, 1.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)-19.125f, (float)-6.5f));
        PartDefinition crep6_r1 = staff.m_171599_("crep6_r1", CubeListBuilder.m_171558_().m_171514_(73, 47).m_171488_(0.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.875f, (float)-1.5f, (float)-1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition crep5_r1 = staff.m_171599_("crep5_r1", CubeListBuilder.m_171558_().m_171514_(73, 47).m_171488_(0.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-0.875f, (float)0.5f, (float)0.0f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)64);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AttributeInstance ms;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        NecromancerUnit necromancer = (NecromancerUnit)entity;
        if (necromancer.animateScale > 0.0f && necromancer.animateScaleReducing) {
            necromancer.animateScale -= 0.02f;
        }
        if (necromancer.animateScale <= 0.0f) {
            necromancer.animateScale = 1.0f;
            necromancer.activeAnimDef = null;
            necromancer.activeAnimState = null;
            necromancer.animateScaleReducing = false;
            necromancer.stopAllAnimations();
        }
        if ((ms = necromancer.m_21051_(Attributes.f_22279_)) == null) {
            return;
        }
        float speed = (float)ms.m_22135_() * 10.0f;
        if (necromancer.activeAnimDef != null && necromancer.activeAnimState != null && necromancer.animateTicks > 0) {
            this.restartThenAnimate(necromancer, necromancer.activeAnimState, necromancer.activeAnimDef, ageInTicks, necromancer.animateScale);
        } else if (!entity.m_20072_() && limbSwingAmount > 0.001f) {
            this.restart(necromancer, necromancer.walkAnimState, NecromancerAnimations.WALK, ageInTicks);
            this.m_267799_(NecromancerAnimations.WALK, limbSwing, limbSwingAmount, speed, speed);
        } else {
            this.restartThenAnimate(necromancer, necromancer.idleAnimState, NecromancerAnimations.IDLE, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

