/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BeaconSyncClientboundPacket {
    private final UnitAction action;
    private final BlockPos beaconPos;
    private final boolean activate;

    public static void syncBeacon(UnitAction action, BlockPos beaconPos, boolean activate) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BeaconSyncClientboundPacket(action, beaconPos, activate));
    }

    public BeaconSyncClientboundPacket(UnitAction action, BlockPos beaconPos, boolean activate) {
        this.action = action;
        this.beaconPos = beaconPos;
        this.activate = activate;
    }

    public BeaconSyncClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (UnitAction)buffer.m_130066_(UnitAction.class);
        this.beaconPos = buffer.m_130135_();
        this.activate = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130064_(this.beaconPos);
        buffer.writeBoolean(this.activate);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            BuildingClientEvents.syncBeacon(this.action, this.beaconPos, this.activate);
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

