/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitIdleWorkerClientBoundPacket {
    private final int[] oldUnitIds;

    public static void sendIdleWorkerPacket() {
        int[] idleIds = UnitServerEvents.getAllUnits().stream().filter(u -> {
            WorkerUnit wu;
            return u instanceof WorkerUnit && WorkerUnit.isIdle(wu = (WorkerUnit)u);
        }).mapToInt(Entity::m_19879_).toArray();
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitIdleWorkerClientBoundPacket(idleIds));
    }

    public UnitIdleWorkerClientBoundPacket(int[] oldUnitIds) {
        this.oldUnitIds = oldUnitIds;
    }

    public UnitIdleWorkerClientBoundPacket(FriendlyByteBuf buffer) {
        this.oldUnitIds = buffer.m_130100_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130089_(this.oldUnitIds);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            UnitClientEvents.syncIdleWorkers(this.oldUnitIds);
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

