/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.FirewallShot;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.BlazeUnitFireball;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BlazeUnit
extends Blaze
implements Unit,
AttackerUnit,
RangedAttackerUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    public MountGoal mountGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private UnitBowAttackGoal<? extends LivingEntity> attackGoal;
    public static final float attackDamage = 0.5f;
    public static final float attacksPerSecond = 1.0f;
    public static final float attackRange = 14.0f;
    public static final float aggroRange = 14.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public static final float maxHealth = 35.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public int maxResources = 100;
    public int fogRevealDuration = 0;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public MountGoal getMountGoal() {
        return this.mountGoal;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 35.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.BLAZE;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 20;
    }

    @Override
    public float getAttacksPerSecond() {
        return 1.0f;
    }

    @Override
    public float getAggroRange() {
        return 14.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 14.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 0.5f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    @Override
    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    public BlazeUnit(EntityType<? extends Blaze> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(false);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    public boolean m_6126_() {
        return false;
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new UnitBowAttackGoal<BlazeUnit>(this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void performUnitRangedAttack(LivingEntity pTarget, float velocity) {
        FirewallShot firewallShot;
        Ability ability;
        if (!this.abilities.isEmpty() && (ability = this.abilities.get().get(0)) instanceof FirewallShot && !(firewallShot = (FirewallShot)ability).isOffCooldown(this)) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20227_(0.5) - this.m_20227_(0.5);
            double z = target.m_20189_() - this.m_20189_();
            double distSqr = this.m_20280_((Entity)target);
            double dist = Math.sqrt(Math.sqrt(distSqr)) * 0.5;
            BlazeUnitFireball fireball = new BlazeUnitFireball(this.m_9236_(), (LivingEntity)this, this.m_217043_().m_216328_(x, 2.297 * dist), y, this.m_217043_().m_216328_(z, 2.297 * dist), false);
            fireball.m_6034_(fireball.m_20185_(), this.m_20227_(0.5) + 0.5, fireball.m_20189_());
            this.m_5496_(SoundEvents.f_11705_, 3.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)fireball);
            if (!this.m_9236_().m_5776_() && target instanceof Unit) {
                Unit unit = (Unit)target;
                FogOfWarClientboundPacket.revealRangedUnit(unit.getOwnerName(), this.m_19879_());
            }
        }
    }

    public void shootFirewallShot(BlockPos bp) {
        double x = (double)bp.m_123341_() - this.m_20185_();
        double y = (double)bp.m_123342_() - this.m_20227_(0.5) + 1.5;
        double z = (double)bp.m_123343_() - this.m_20189_();
        BlazeUnitFireball fireball = new BlazeUnitFireball(this.m_9236_(), (LivingEntity)this, x, y, z, true);
        fireball.m_6034_(fireball.m_20185_(), this.m_20227_(0.5) + 0.5, fireball.m_20189_());
        this.m_5496_(SoundEvents.f_11705_, 3.0f, 1.0f);
        this.m_9236_().m_7967_((Entity)fireball);
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    static {
        ABILITIES.add(new FirewallShot(), Keybindings.keyQ);
        ownerDataAccessor = SynchedEntityData.m_135353_(BlazeUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

