/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.tps.TPSClientEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Ability {
    public final UnitAction action;
    public final Level level;
    public float cooldownMax;
    private float cooldown = 0.0f;
    public final float range;
    public final float radius;
    public final boolean canTargetEntities;
    public boolean oneClickOneUse;
    public UnitAction autocastEnableAction = null;
    public UnitAction autocastDisableAction = null;
    public int maxCharges = 1;
    public int charges = 1;
    private boolean autocast = false;

    public void setAutocast(boolean value) {
        this.autocast = value;
    }

    public boolean getAutocast() {
        return this.autocast;
    }

    public Ability(UnitAction action, Level level, int cooldownMax, float range, float radius, boolean canTargetEntities) {
        this.action = action;
        this.level = level;
        this.cooldownMax = cooldownMax;
        this.range = range;
        this.radius = radius;
        this.canTargetEntities = canTargetEntities;
        this.oneClickOneUse = false;
    }

    public Ability(UnitAction action, Level level, int cooldownMax, float range, float radius, boolean canTargetEntities, boolean oneClickOneUse) {
        this.action = action;
        this.level = level;
        this.cooldownMax = cooldownMax;
        this.range = range;
        this.radius = radius;
        this.canTargetEntities = canTargetEntities;
        this.oneClickOneUse = oneClickOneUse;
    }

    public boolean usesCharges() {
        return this.maxCharges > 1;
    }

    protected void toggleAutocast() {
        if (!this.level.m_5776_()) {
            return;
        }
        if (this.autocast && this.autocastDisableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastDisableAction);
        } else if (!this.autocast && this.autocastEnableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastEnableAction);
        }
    }

    public void tickCooldown() {
        if (this.cooldown > 0.0f || this.charges < this.maxCharges) {
            this.cooldown = this.level.m_5776_() ? (float)((double)this.cooldown - TPSClientEvents.getCappedTPS() / 20.0) : (this.cooldown -= 1.0f);
            if (this.cooldown <= 0.0f && this.usesCharges() && this.charges < this.maxCharges) {
                ++this.charges;
                if (this.charges < this.maxCharges) {
                    this.cooldown = this.cooldownMax;
                }
                if (this.charges > this.maxCharges) {
                    this.charges = this.maxCharges;
                }
            }
        }
    }

    public boolean isChanneling() {
        return false;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public boolean isOffCooldown() {
        return this.cooldown <= 0.0f || this.usesCharges() && this.charges > 0;
    }

    public void setToMaxCooldown() {
        this.cooldown = this.cooldownMax;
        if (this.usesCharges() && this.charges > 0) {
            --this.charges;
        }
    }

    public void setCooldown(float cooldown) {
        this.setCooldown(cooldown, true);
    }

    public void setCooldown(float cooldown, boolean useCharge) {
        if (this.level.m_5776_() && cooldown > 0.0f) {
            HudClientEvents.setLowestCdHudEntity();
        }
        this.cooldown = Math.min(cooldown, this.cooldownMax);
        if (useCharge && this.usesCharges() && this.charges > 0) {
            --this.charges;
        }
    }

    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
    }

    public void use(Level level, Building buildingUsing, LivingEntity targetEntity) {
    }

    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
    }

    public void use(Level level, Building buildingUsing, BlockPos targetBp) {
    }

    public AbilityButton getButton(Keybinding hotkey) {
        return null;
    }

    public boolean canBypassCooldown() {
        return this.usesCharges() && this.charges > 0;
    }

    public boolean shouldResetBehaviours() {
        return true;
    }
}

