/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class EnchantAbility
extends Ability {
    public static final int CD_MAX = 1;
    public static final int RANGE = 12;
    public final Library library;
    public final ResourceCost cost;

    public EnchantAbility(UnitAction action, Library library, ResourceCost cost) {
        super(action, library.getLevel(), 1, 12.0f, 0.0f, true, true);
        this.library = library;
        this.cost = cost;
    }

    public boolean canAfford(Building buildingUsing) {
        Resources res = null;
        if (buildingUsing.getLevel().m_5776_()) {
            res = ResourcesClientEvents.getOwnResources();
        } else {
            for (Resources resources : ResourcesServerEvents.resourcesList) {
                if (!resources.ownerName.equals(buildingUsing.ownerName)) continue;
                res = resources;
            }
        }
        if (res != null) {
            return res.food >= this.cost.food && res.wood >= this.cost.wood && res.ore >= this.cost.ore;
        }
        return false;
    }

    public boolean isCorrectUnitAndEquipment(LivingEntity entity) {
        return false;
    }

    public boolean hasAnyEnchant(LivingEntity entity) {
        return false;
    }

    protected boolean hasSameEnchant(LivingEntity entity) {
        return false;
    }

    protected void doEnchant(LivingEntity entity) {
    }

    private void playSound(Level level, LivingEntity te) {
        level.m_7785_(te.m_20185_(), te.m_20186_(), te.m_20189_(), SoundEvents.f_11887_, te.m_5720_(), 1.0f + te.m_217043_().m_188501_(), te.m_217043_().m_188501_() * 0.7f + 0.3f, false);
    }

    @Override
    public void use(Level level, Building buildingUsing, LivingEntity te) {
        Unit unit;
        if (!level.m_5776_() && te instanceof Unit && (unit = (Unit)te).getOwnerName().equals(buildingUsing.ownerName) && this.isCorrectUnitAndEquipment(te) && !this.hasSameEnchant(te) && this.canAfford(buildingUsing) && te.m_20238_(Vec3.m_82512_((Vec3i)buildingUsing.centrePos)) < 144.0) {
            this.doEnchant(te);
            ResourcesServerEvents.addSubtractResources(new Resources(this.library.ownerName, -this.cost.food, -this.cost.wood, -this.cost.ore));
            this.setToMaxCooldown();
            this.playSound(level, te);
        } else if (level.m_5776_()) {
            Unit unit2;
            if (!(te instanceof Unit) || !(unit2 = (Unit)te).getOwnerName().equals(buildingUsing.ownerName)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"ability.reignofnether.enchant.error1", (Object[])new Object[0]));
            } else if (te.m_20238_(Vec3.m_82512_((Vec3i)buildingUsing.centrePos)) >= 144.0) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"ability.reignofnether.enchant.error2", (Object[])new Object[0]));
            } else if (!this.isCorrectUnitAndEquipment(te)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"ability.reignofnether.enchant.error3", (Object[])new Object[0]));
            } else if (this.hasSameEnchant(te)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"ability.reignofnether.enchant.error4", (Object[])new Object[0]));
            } else if (!this.canAfford(buildingUsing)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"ability.reignofnether.enchant.error5", (Object[])new Object[0]));
            } else {
                this.setToMaxCooldown();
                this.playSound(level, te);
            }
        }
    }
}

