/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.EnchantAbility;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class EnchantAbilityServerboundPacket {
    UnitAction abilityAction;
    BlockPos buildingPos;

    public static void setAutocastEnchant(UnitAction ability, BlockPos buildingPos) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new EnchantAbilityServerboundPacket(ability, buildingPos));
        }
    }

    public EnchantAbilityServerboundPacket(UnitAction ability, BlockPos buildingPos) {
        this.abilityAction = ability;
        this.buildingPos = buildingPos;
    }

    public EnchantAbilityServerboundPacket(FriendlyByteBuf buffer) {
        this.abilityAction = (UnitAction)buffer.m_130066_(UnitAction.class);
        this.buildingPos = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.abilityAction);
        buffer.m_130064_(this.buildingPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("EnchantAbilityServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            Building building = BuildingUtils.findBuilding(false, this.buildingPos);
            if (building instanceof Library) {
                Library library = (Library)building;
                if (!player.m_7755_().getString().equals(library.ownerName)) {
                    ReignOfNether.LOGGER.warn("EnchantAbilityServerboundPacket: Tried to process packet from " + player.m_7755_() + " for: " + library.ownerName);
                    success.set(false);
                    return;
                }
                Ability ability = null;
                for (Ability abl : library.getAbilities()) {
                    if (abl.action != this.abilityAction) continue;
                    ability = abl;
                }
                if (ability instanceof EnchantAbility) {
                    EnchantAbility enchantAbility = (EnchantAbility)ability;
                    library.autoCastEnchant = library.autoCastEnchant == enchantAbility ? null : enchantAbility;
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

