/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Bloodlust
extends Ability {
    private static final int HEALTH_COST = 12;
    private static final int DURATION_SECONDS = 10;
    private final Unit unit;

    public Bloodlust(Unit unit) {
        super(UnitAction.BLOOD_LUST, ((Entity)unit).m_9236_(), 0, 0.0f, 0.0f, false, false);
        this.unit = unit;
    }

    private static int getDurationLeft(Unit unit) {
        if (unit instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)unit;
            return headhunterUnit.bloodlustTicks;
        }
        if (unit instanceof BruteUnit) {
            BruteUnit bruteUnit = (BruteUnit)unit;
            return bruteUnit.bloodlustTicks;
        }
        return 0;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Bloodlust", new ResourceLocation("minecraft", "textures/block/redstone_block.png"), hotkey, () -> Bloodlust.getDurationLeft(this.unit) > 0, () -> !ResearchClient.hasResearch("Bloodlust"), () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.BLOOD_LUST), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.bloodlust", (Object[])new Object[0]), true), FormattedCharSequence.m_13714_((String)"\ue007  12", (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip1", (Object[])new Object[]{12}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip2", (Object[])new Object[]{10}), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        int duration = 200;
        if (((LivingEntity)this.unit).m_21223_() <= 12.0f) {
            return;
        }
        ((LivingEntity)this.unit).m_6469_(level.m_269111_().m_269425_(), 12.0f);
        Unit unit = this.unit;
        if (unit instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)unit;
            headhunterUnit.bloodlustTicks = duration;
            headhunterUnit.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, 0));
            headhunterUnit.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 640, 0));
        } else {
            unit = this.unit;
            if (unit instanceof BruteUnit) {
                BruteUnit bruteUnit = (BruteUnit)unit;
                bruteUnit.bloodlustTicks = duration;
                bruteUnit.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, 0));
                bruteUnit.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 640, 0));
            }
        }
    }

    @Override
    public boolean shouldResetBehaviours() {
        return false;
    }
}

