/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;

public class CallLightning
extends Ability {
    private static final int CD_MAX = 1200;
    public static final int RANGE = 25;
    private final Laboratory lab;

    public CallLightning(Laboratory lab) {
        super(UnitAction.CALL_LIGHTNING, lab.getLevel(), 1200, 25.0f, 0.0f, false, true);
        this.lab = lab;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Call Lightning", new ResourceLocation("reignofnether", "textures/icons/items/lightbulb_on.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.CALL_LIGHTNING, () -> this.lab.getUpgradeLevel() == 0, () -> this.lab.getLightningRodPos() != null, () -> CursorClientEvents.setLeftClickAction(UnitAction.CALL_LIGHTNING), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_lightning", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_lightning.tooltip1", (Object[])new Object[]{60, 25}), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_lightning.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_lightning.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, Building buildingUsing, BlockPos targetBp) {
        if (!level.m_5776_() && buildingUsing instanceof Laboratory) {
            Laboratory lab = (Laboratory)buildingUsing;
            BlockPos rodPos = lab.getLightningRodPos();
            if (lab.isAbilityOffCooldown(UnitAction.CALL_LIGHTNING) && rodPos != null) {
                LightningBolt bolt2;
                BlockPos limitedBp = MyMath.getXZRangeLimitedBlockPos(buildingUsing.centrePos, targetBp, this.range);
                limitedBp = MiscUtil.getHighestNonAirBlock(level, limitedBp);
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (bolt != null) {
                    bolt.m_6027_((double)limitedBp.m_123341_(), (double)limitedBp.m_123342_(), (double)limitedBp.m_123343_());
                    level.m_7967_((Entity)bolt);
                }
                if ((bolt2 = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
                    bolt2.m_6027_((double)rodPos.m_123341_(), (double)rodPos.m_123342_(), (double)rodPos.m_123343_());
                    level.m_7967_((Entity)bolt2);
                }
            }
        }
        this.setToMaxCooldown();
    }
}

