/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;

public class ConnectPortal
extends Ability {
    private static final int CD_MAX = 0;
    private static final int RANGE = 0;
    Building building;

    public ConnectPortal(Building building) {
        super(UnitAction.CONNECT_PORTAL, building.getLevel(), 0, 0.0f, 0.0f, true);
        this.building = building;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Connect Portal", new ResourceLocation("reignofnether", "textures/icons/blocks/portal.png"), hotkey, () -> false, () -> {
            Building patt1698$temp = this.building;
            if (patt1698$temp instanceof Portal) {
                Portal portal = (Portal)patt1698$temp;
                return portal.portalType != Portal.PortalType.TRANSPORT;
            }
            return true;
        }, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.CONNECT_PORTAL), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void use(Level level, Building buildingUsing, BlockPos targetBp) {
        Building building = this.building;
        if (!(building instanceof Portal)) return;
        Portal portal = (Portal)building;
        if (portal.portalType != Portal.PortalType.TRANSPORT) return;
        portal.disconnectPortal();
        Building targetBuilding = BuildingUtils.findBuilding(level.m_5776_(), targetBp);
        if (targetBuilding instanceof Portal) {
            Portal targetPortal = (Portal)targetBuilding;
            if (targetPortal.portalType == Portal.PortalType.TRANSPORT && targetBuilding != this.building && targetBuilding.isBuilt && (targetBuilding.ownerName.equals(this.building.ownerName) || targetBuilding instanceof NeutralTransportPortal && this.building instanceof NeutralTransportPortal)) {
                targetPortal.disconnectPortal();
                targetPortal.destination = portal.centrePos;
                portal.destination = targetPortal.centrePos;
                return;
            }
        }
        if (!level.m_5776_()) return;
        HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.connect_portal.error1", (Object[])new Object[0]));
    }
}

