/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.BlazeUnit;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FirewallShot
extends Ability {
    public static final int CD_MAX_SECONDS = 20;
    public static final int RANGE = 15;
    private final BlazeUnit blazeUnit;

    public FirewallShot(BlazeUnit blazeUnit) {
        super(UnitAction.SHOOT_FIREWALL, blazeUnit.m_9236_(), 400, 15.0f, 0.0f, true, true);
        this.blazeUnit = blazeUnit;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Fire Wall Shot", new ResourceLocation("reignofnether", "textures/icons/blocks/fire.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.SHOOT_FIREWALL, () -> !ResearchClient.hasResearch("Walls of Fire"), () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.SHOOT_FIREWALL), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.fire_wall_shot", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"abilities.reignofnether.fire_wall_shot.tooltip1", (Object[])new Object[]{20}) + "15"), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.fire_wall_shot.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.fire_wall_shot.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        BlockPos bp = targetEntity.m_20097_();
        this.use(level, unitUsing, bp);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        this.blazeUnit.shootFirewallShot(targetBp);
        this.setToMaxCooldown();
        if (!level.m_5776_()) {
            AbilityClientboundPacket.sendSetCooldownPacket(this.blazeUnit.m_19879_(), this.action, this.cooldownMax);
        }
    }
}

