/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;

public class GotoPortal
extends Ability {
    private static final int CD_MAX = 0;
    private static final int RANGE = 0;
    Building building;

    public GotoPortal(Building building) {
        super(UnitAction.GOTO_PORTAL, building.getLevel(), 0, 0.0f, 0.0f, true);
        this.building = building;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Go to connected portal", new ResourceLocation("reignofnether", "textures/icons/items/map.png"), hotkey, () -> false, () -> {
            Building patt1839$temp = this.building;
            if (patt1839$temp instanceof Portal) {
                Portal portal = (Portal)patt1839$temp;
                return !portal.hasDestination();
            }
            return true;
        }, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.GOTO_PORTAL), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.go_to_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true)))), this);
    }

    @Override
    public void use(Level level, Building buildingUsing, BlockPos targetBp) {
        Building targetBuilding;
        Portal portal;
        Building building;
        if (level.m_5776_() && (building = this.building) instanceof Portal && (portal = (Portal)building).hasDestination() && (targetBuilding = BuildingUtils.findBuilding(level.m_5776_(), portal.destination)) instanceof Portal) {
            Portal targetPortal = (Portal)targetBuilding;
            if (portal.portalType == Portal.PortalType.TRANSPORT) {
                OrthoviewClientEvents.centreCameraOnPos(targetPortal.centrePos);
            }
        }
    }
}

