/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.SonicBoomGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.WardenUnit;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SonicBoom
extends Ability {
    public static final int CD_MAX_SECONDS = 60;
    private final WardenUnit wardenUnit;

    public SonicBoom(WardenUnit wardenUnit) {
        super(UnitAction.CAST_SONIC_BOOM, wardenUnit.m_9236_(), 1200, 10.0f, 0.0f, true, true);
        this.wardenUnit = wardenUnit;
    }

    @Override
    public boolean isChanneling() {
        SonicBoomGoal goal = this.wardenUnit.getSonicBoomGoal();
        if (goal == null) {
            return false;
        }
        return goal.isCasting() || goal.getMoveTarget() != null || goal.getTargetEntity() != null;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Sonic Boom", new ResourceLocation("minecraft", "textures/block/note_block.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.CAST_SONIC_BOOM, () -> false, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.CAST_SONIC_BOOM), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sonic_boom", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"abilities.reignofnether.sonic_boom.tooltip1", (Object[])new Object[]{Float.valueOf(75.0f), 60}) + "10"), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sonic_boom.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sonic_boom.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        Unit unit;
        if (targetEntity instanceof Unit && (unit = (Unit)targetEntity).equals(this.wardenUnit)) {
            return;
        }
        ((WardenUnit)unitUsing).getSonicBoomGoal().setAbility(this);
        ((WardenUnit)unitUsing).getSonicBoomGoal().setTarget(targetEntity);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        Building targetBuilding = BuildingUtils.findBuilding(level.m_5776_(), targetBp);
        if (targetBuilding != null) {
            ((WardenUnit)unitUsing).getSonicBoomGoal().setAbility(this);
            ((WardenUnit)unitUsing).getSonicBoomGoal().setTarget(targetBuilding);
        } else if (level.m_5776_()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sonic_boom.error1", (Object[])new Object[0]));
        }
    }
}

