/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ThrowTNT
extends HeroAbility {
    public static final int RANGE = 12;
    private static float explosionPower = 2.0f;
    private static int LESS_COOLDOWN_PER_100_RESOURCES = 100;

    public ThrowTNT(HeroUnit hero) {
        super(hero, 3, UnitAction.THROW_TNT, 500, 12.0f, 0.0f, true);
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            explosionPower = 2.0f;
        } else if (this.rank == 2) {
            explosionPower = 3.0f;
        } else if (this.rank == 3) {
            explosionPower = 4.0f;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Throw TNT", new ResourceLocation("reignofnether", "textures/icons/blocks/tnt.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.THROW_TNT, () -> this.rank == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.THROW_TNT), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Throw TNT", new ResourceLocation("reignofnether", "textures/icons/blocks/tnt.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.stats", (Object[])new Object[]{Math.round(explosionPower * 6.67f), Float.valueOf(this.cooldownMax / 20.0f), 12})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip2", (Object[])new Object[]{LESS_COOLDOWN_PER_100_RESOURCES / 20})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.tooltip2", (Object[])new Object[]{LESS_COOLDOWN_PER_100_RESOURCES / 20})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.throw_tnt.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setTarget(targetBp);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastTNTGoal().setTarget(targetEntity);
    }
}

