/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.villager;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MaceSlam
extends HeroAbility {
    public static final float RANGE = 4.0f;
    private static float damage = 15.0f;
    private static float stunDuration = 40.0f;

    public MaceSlam(HeroUnit hero) {
        super(hero, 3, UnitAction.MACE_SLAM, 400, 4.0f, 0.0f, true);
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            damage = 15.0f;
            stunDuration = 40.0f;
        } else if (this.rank == 2) {
            damage = 20.0f;
            stunDuration = 60.0f;
        } else if (this.rank == 3) {
            damage = 25.0f;
            stunDuration = 80.0f;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Mace Slam", new ResourceLocation("reignofnether", "textures/icons/items/mace.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.MACE_SLAM, () -> this.rank == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.MACE_SLAM), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Mace Slam", new ResourceLocation("reignofnether", "textures/icons/items/mace.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.stats", (Object[])new Object[]{Float.valueOf(damage), Float.valueOf(this.cooldownMax / 20.0f)})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip2", (Object[])new Object[]{Float.valueOf(stunDuration / 20.0f)})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip2", (Object[])new Object[]{Float.valueOf(stunDuration / 20.0f)})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setTarget(targetEntity);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setTarget(targetBp);
    }
}

