/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.villager;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TauntingCry
extends HeroAbility {
    private static final int CD_MAX_SECONDS = 100;
    private static int duration = 80;

    public TauntingCry(HeroUnit hero) {
        super(hero, 3, UnitAction.TAUNTING_CRY, 100, 0.0f, 0.0f, false);
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            duration = 80;
        } else if (this.rank == 2) {
            duration = 120;
        } else if (this.rank == 3) {
            duration = 160;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Taunting Cry", new ResourceLocation("reignofnether", "textures/icons/items/ominous_banner.png"), hotkey, () -> false, () -> this.rank <= 0, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.TAUNTING_CRY), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Taunting Cry", new ResourceLocation("reignofnether", "textures/icons/items/ominous_banner.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.stats", (Object[])new Object[]{5})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.tooltip2", (Object[])new Object[]{duration / 20})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.tooltip3", (Object[])new Object[0])));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.tooltip2", (Object[])new Object[]{duration / 20})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.taunting_cry.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((RoyalGuardUnit)unitUsing).getCastTauntingCryGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastTauntingCryGoal().startCasting();
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((RoyalGuardUnit)unitUsing).getCastTauntingCryGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastTauntingCryGoal().startCasting();
    }
}

