/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.solegendary.reignofnether.alliance.AllianceClientboundAddPacket;
import com.solegendary.reignofnether.alliance.AllianceClientboundRemovePacket;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class AlliancesServerEvents {
    private static final Map<String, Set<String>> alliances = new HashMap<String, Set<String>>();

    public static void addAlliance(String owner1, String owner2) {
        if (!owner1.equals(owner2)) {
            alliances.computeIfAbsent(owner1, k -> new HashSet()).add(owner2);
            alliances.computeIfAbsent(owner2, k -> new HashSet()).add(owner1);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundAddPacket(owner1, owner2));
        }
    }

    public static void removeAlliance(String owner1, String owner2) {
        Set<String> alliesOfOwner2;
        Set<String> alliesOfOwner1 = alliances.get(owner1);
        if (alliesOfOwner1 != null) {
            alliesOfOwner1.remove(owner2);
            if (alliesOfOwner1.isEmpty()) {
                alliances.remove(owner1);
            }
        }
        if ((alliesOfOwner2 = alliances.get(owner2)) != null) {
            alliesOfOwner2.remove(owner1);
            if (alliesOfOwner2.isEmpty()) {
                alliances.remove(owner2);
            }
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundRemovePacket(owner1, owner2));
    }

    public static boolean isAllied(String owner1, String owner2) {
        return alliances.getOrDefault(owner1, Collections.emptySet()).contains(owner2);
    }

    public static Set<String> getAllAllies(String owner) {
        return alliances.getOrDefault(owner, Collections.emptySet());
    }

    public static Set<String> getAllConnectedAllies(String owner) {
        HashSet<String> allAllies = new HashSet<String>();
        AlliancesServerEvents.findAllConnectedAllies(owner, allAllies);
        return allAllies;
    }

    private static void findAllConnectedAllies(String owner, Set<String> visited) {
        if (!visited.contains(owner)) {
            visited.add(owner);
            for (String ally : AlliancesServerEvents.getAllAllies(owner)) {
                AlliancesServerEvents.findAllConnectedAllies(ally, visited);
            }
        }
    }

    public static void resetAllAlliances() {
        alliances.clear();
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundRemovePacket());
    }

    public static void syncAlliances() {
        for (String player1 : alliances.keySet()) {
            for (String player2 : alliances.get(player1)) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundAddPacket(player1, player2));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        AlliancesServerEvents.syncAlliances();
    }
}

