/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class AllyCommand {
    public static final Map<String, String> pendingAlliances = new HashMap<String, String>();
    public static final Set<UUID> pendingDisbands = new HashSet<UUID>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ally").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(AllyCommand::ally)));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"allyconfirm").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(AllyCommand::allyConfirm)));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"disband").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(AllyCommand::disband)));
    }

    private static int ally(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer allyPlayer = EntityArgument.m_91474_(context, (String)"player");
        String playerName = player.m_7755_().getString();
        String allyPlayerName = allyPlayer.m_7755_().getString();
        if (player.equals((Object)allyPlayer)) {
            player.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.ally_self", (Object[])new Object[]{playerName}));
            return 0;
        }
        pendingAlliances.put(allyPlayerName, playerName);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"alliance.reignofnether.sent_request", (Object[])new Object[]{allyPlayerName}), false);
        SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, allyPlayerName);
        allyPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.ally_confirm", (Object[])new Object[]{playerName, playerName}));
        SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, playerName);
        return 1;
    }

    private static int allyConfirm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer requesterPlayer = EntityArgument.m_91474_(context, (String)"player");
        String playerName = player.m_7755_().getString();
        String requesterPlayerName = requesterPlayer.m_7755_().getString();
        if (pendingAlliances.getOrDefault(playerName, "").equals(requesterPlayerName)) {
            AlliancesServerEvents.addAlliance(playerName, requesterPlayerName);
            pendingAlliances.remove(playerName);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"alliance.reignofnether.now_allied", (Object[])new Object[]{requesterPlayerName}), false);
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ALLY, requesterPlayerName);
            requesterPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.ally_accepted", (Object[])new Object[]{playerName}));
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ALLY, playerName);
            for (ServerPlayer serverPlayer : PlayerServerEvents.players) {
                if (serverPlayer.equals((Object)player) || serverPlayer.equals((Object)requesterPlayer)) continue;
                serverPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.now_allied_third_party", (Object[])new Object[]{playerName, requesterPlayerName}));
                SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, playerName);
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"alliance.reignofnether.no_request", (Object[])new Object[]{requesterPlayerName}));
        }
        return 1;
    }

    private static int disband(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer allyPlayer = EntityArgument.m_91474_(context, (String)"player");
        String playerName = player.m_7755_().getString();
        String allyPlayerName = allyPlayer.m_7755_().getString();
        if (player.equals((Object)allyPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"alliance.reignofnether.disband_self"));
            return 0;
        }
        UUID playerId = player.m_20148_();
        if (pendingDisbands.contains(playerId)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"alliance.reignofnether.disband_pending", (Object[])new Object[]{allyPlayerName}));
            return 0;
        }
        pendingDisbands.add(playerId);
        scheduler.schedule(() -> {
            if (pendingDisbands.remove(playerId)) {
                AlliancesServerEvents.removeAlliance(playerName, allyPlayerName);
                player.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.disbanded", (Object[])new Object[]{allyPlayerName}));
                SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, playerName);
                allyPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.disbanded", (Object[])new Object[]{playerName}));
                SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, allyPlayerName);
                for (ServerPlayer serverPlayer : PlayerServerEvents.players) {
                    if (serverPlayer.equals((Object)player) || serverPlayer.equals((Object)allyPlayer)) continue;
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.disbanded_third_party", (Object[])new Object[]{playerName, allyPlayerName}));
                    SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, playerName);
                }
            }
        }, 30L, TimeUnit.SECONDS);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"alliance.reignofnether.disbanding", (Object[])new Object[]{allyPlayerName}), false);
        SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, playerName);
        allyPlayer.m_213846_((Component)Component.m_237110_((String)"alliance.reignofnether.disbanding", (Object[])new Object[]{playerName}));
        SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, allyPlayerName);
        return 1;
    }
}

