/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.buildings.monsters.SculkCatalyst;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class BuildingBlock {
    private BlockPos blockPos;
    private BlockState blockState;
    private List<Predicate<BlockState>> materialsThatIgnoreState = List.of(s -> SculkCatalyst.isSculk(s.m_60734_()), s -> s.m_204336_(Tags.Blocks.GLASS), s -> s.m_204336_(BlockTags.f_13035_));

    private boolean isIgnored(BlockState state) {
        for (Predicate<BlockState> predicate : this.materialsThatIgnoreState) {
            if (!predicate.test(state)) continue;
            return true;
        }
        return false;
    }

    public BuildingBlock(BlockPos blockPos, BlockState blockState) {
        this.blockPos = blockPos;
        this.blockState = blockState;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockPos(BlockPos bp) {
        this.blockPos = bp;
    }

    public void setBlockState(BlockState bs) {
        this.blockState = bs;
    }

    public BuildingBlock rotate(LevelAccessor level, Rotation rotation) {
        return new BuildingBlock(this.blockPos.m_7954_(rotation), this.blockState.rotate(level, this.blockPos, rotation));
    }

    public BuildingBlock move(LevelAccessor level, BlockPos offset) {
        return new BuildingBlock(this.blockPos.m_121955_((Vec3i)offset), this.blockState);
    }

    public boolean isPlaced(Level level) {
        boolean isMatchingWallBlock;
        BlockState bs = level.m_5776_() ? Minecraft.m_91087_().f_91073_.m_8055_(this.blockPos) : level.m_8055_(this.blockPos);
        boolean bl = isMatchingWallBlock = this.blockState.m_60734_() instanceof WallBlock && bs.m_60734_() == this.blockState.m_60734_();
        if (this.isIgnored(this.blockState) && this.isIgnored(bs)) {
            return true;
        }
        Block block1 = this.blockState.m_60734_();
        Block block2 = bs.m_60734_();
        if (block1 instanceof StairBlock && block2 instanceof StairBlock || block1 instanceof FenceBlock && block2 instanceof FenceBlock || block1 instanceof WallBlock && block2 instanceof WallBlock || block1 instanceof IronBarsBlock && block2 instanceof IronBarsBlock) {
            return true;
        }
        return !this.blockState.m_60795_() && (bs == this.blockState || isMatchingWallBlock);
    }
}

