/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingAction;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BuildingClientboundPacket {
    public BuildingAction action;
    public BlockPos buildingPos;
    public String itemName;
    public Rotation rotation;
    public String ownerName;
    public int blocksPlaced;
    public int numQueuedBlocks;
    public boolean isDiagonalBridge;
    public int upgradeLevel;
    public boolean isBuilt;
    public Portal.PortalType portalType;
    public BlockPos portalDestination;
    public boolean forPlayerLoggingIn;

    public static void placeBuilding(BlockPos buildingPos, String itemName, Rotation rotation, String ownerName, int numQueuedBlocks, boolean isDiagonalBridge, int upgradeLevel, boolean isBuilt, Portal.PortalType portalType, BlockPos portalDestination, boolean forPlayerLoggingIn) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.PLACE, itemName, buildingPos, rotation, ownerName, 0, numQueuedBlocks, isDiagonalBridge, upgradeLevel, isBuilt, portalType, portalDestination, forPlayerLoggingIn));
    }

    public static void syncBuilding(BlockPos buildingPos, int blocksPlaced, String ownerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.SYNC_BLOCKS_AND_OWNER, "", buildingPos, Rotation.NONE, ownerName, blocksPlaced, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void startProduction(BlockPos buildingPos, String itemName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.START_PRODUCTION, itemName, buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void cancelProduction(BlockPos buildingPos, String itemName, boolean frontItem) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(frontItem ? BuildingAction.CANCEL_PRODUCTION : BuildingAction.CANCEL_BACK_PRODUCTION, itemName, buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void changePortal(BlockPos buildingPos, String portalType) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.CHANGE_PORTAL, portalType, buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void clearQueue(BlockPos buildingPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.CLEAR_PRODUCTION, "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public static void completeProduction(BlockPos buildingPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new BuildingClientboundPacket(BuildingAction.COMPLETE_PRODUCTION, "", buildingPos, Rotation.NONE, "", 0, 0, false, 0, false, Portal.PortalType.BASIC, new BlockPos(0, 0, 0), false));
    }

    public BuildingClientboundPacket(BuildingAction action, String itemName, BlockPos buildingPos, Rotation rotation, String ownerName, int blocksPlaced, int numQueuedBlocks, boolean isDiagonalBridge, int upgradeLevel, boolean isBuilt, Portal.PortalType portalType, BlockPos portalDestination, boolean forPlayerLoggingIn) {
        this.action = action;
        this.itemName = itemName;
        this.buildingPos = buildingPos;
        this.rotation = rotation;
        this.ownerName = ownerName;
        this.blocksPlaced = blocksPlaced;
        this.numQueuedBlocks = numQueuedBlocks;
        this.isDiagonalBridge = isDiagonalBridge;
        this.isBuilt = isBuilt;
        this.upgradeLevel = upgradeLevel;
        this.portalType = portalType;
        this.portalDestination = portalDestination;
        this.forPlayerLoggingIn = forPlayerLoggingIn;
    }

    public BuildingClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (BuildingAction)buffer.m_130066_(BuildingAction.class);
        this.itemName = buffer.m_130277_();
        this.buildingPos = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.ownerName = buffer.m_130277_();
        this.blocksPlaced = buffer.readInt();
        this.numQueuedBlocks = buffer.readInt();
        this.isDiagonalBridge = buffer.readBoolean();
        this.isBuilt = buffer.readBoolean();
        this.upgradeLevel = buffer.readInt();
        this.portalType = (Portal.PortalType)buffer.m_130066_(Portal.PortalType.class);
        this.portalDestination = buffer.m_130135_();
        this.forPlayerLoggingIn = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.itemName);
        buffer.m_130064_(this.buildingPos);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130070_(this.ownerName);
        buffer.writeInt(this.blocksPlaced);
        buffer.writeInt(this.numQueuedBlocks);
        buffer.writeBoolean(this.isDiagonalBridge);
        buffer.writeBoolean(this.isBuilt);
        buffer.writeInt(this.upgradeLevel);
        buffer.m_130068_((Enum)this.portalType);
        buffer.m_130064_(this.portalDestination);
        buffer.writeBoolean(this.forPlayerLoggingIn);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Building building = null;
            if (this.action != BuildingAction.PLACE && (building = BuildingUtils.findBuilding(true, this.buildingPos)) == null) {
                if (this.action == BuildingAction.SYNC_BLOCKS_AND_OWNER) {
                    BuildingServerboundPacket.requestReplacement(this.buildingPos);
                    ReignOfNether.LOGGER.warn("Missing building");
                }
                return;
            }
            switch (this.action) {
                case PLACE: {
                    BuildingClientEvents.placeBuilding(this.itemName, this.buildingPos, this.rotation, this.ownerName, this.numQueuedBlocks, this.isDiagonalBridge, this.upgradeLevel, this.isBuilt, this.portalType, this.portalDestination, this.forPlayerLoggingIn);
                    break;
                }
                case SYNC_BLOCKS_AND_OWNER: {
                    BuildingClientEvents.syncBuilding(building, this.blocksPlaced, this.ownerName);
                    break;
                }
                case START_PRODUCTION: {
                    ProductionBuilding.startProductionItem((ProductionBuilding)building, this.itemName, this.buildingPos);
                    break;
                }
                case CANCEL_PRODUCTION: {
                    ProductionBuilding.cancelProductionItem((ProductionBuilding)building, this.itemName, this.buildingPos, true);
                    break;
                }
                case CANCEL_BACK_PRODUCTION: {
                    ProductionBuilding.cancelProductionItem((ProductionBuilding)building, this.itemName, this.buildingPos, false);
                    break;
                }
                case CHANGE_PORTAL: {
                    if (!(building instanceof Portal)) break;
                    Portal portal = (Portal)building;
                    portal.changeStructure(Portal.PortalType.valueOf(this.itemName));
                    break;
                }
                case CLEAR_PRODUCTION: {
                    if (!(building instanceof ProductionBuilding)) break;
                    ProductionBuilding pBuilding = (ProductionBuilding)building;
                    if (pBuilding.productionQueue.isEmpty()) break;
                    ProductionItem pItem = pBuilding.productionQueue.get(0);
                    if (!pItem.completed) {
                        pItem.completed = true;
                        pItem.onComplete.accept(pBuilding.level);
                    }
                    pBuilding.productionQueue.clear();
                    break;
                }
                case COMPLETE_PRODUCTION: {
                    if (!(building instanceof ProductionBuilding)) break;
                    ProductionBuilding pBuilding = (ProductionBuilding)building;
                    if (pBuilding.productionQueue.isEmpty()) break;
                    ProductionItem pItem = pBuilding.productionQueue.get(0);
                    if (!pItem.completed) {
                        pItem.completed = true;
                        pItem.onComplete.accept(pBuilding.level);
                    }
                    pBuilding.productionQueue.remove(pItem);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

