/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingSave;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BuildingSaveData
extends SavedData {
    public final ArrayList<BuildingSave> buildings = new ArrayList();

    private static BuildingSaveData create() {
        return new BuildingSaveData();
    }

    @Nonnull
    public static BuildingSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return BuildingSaveData.create();
        }
        return (BuildingSaveData)server.m_129783_().m_8895_().m_164861_(BuildingSaveData::load, BuildingSaveData::create, "saved-building-data");
    }

    public static BuildingSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("BuildingSaveData.load");
        BuildingSaveData data = BuildingSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("buildings");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag btag = (CompoundTag)ctag;
                BlockPos pos = new BlockPos(btag.m_128451_("x"), btag.m_128451_("y"), btag.m_128451_("z"));
                ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
                String name = btag.m_128461_("buildingName");
                String ownerName = btag.m_128461_("ownerName");
                Rotation rotation = Rotation.valueOf((String)btag.m_128461_("rotation"));
                BlockPos rallyPoint = new BlockPos(btag.m_128451_("rallyX"), btag.m_128451_("rallyY"), btag.m_128451_("rallyZ"));
                boolean isDiagonalBridge = btag.m_128471_("isDiagonalBridge");
                boolean isBuilt = btag.m_128471_("isBuilt");
                int upgradeLevel = btag.m_128451_("upgradeLevel");
                Portal.PortalType portalType = Portal.PortalType.valueOf(btag.m_128461_("portalType"));
                BlockPos portalDestination = new BlockPos(btag.m_128451_("xp"), btag.m_128451_("yp"), btag.m_128451_("zp"));
                data.buildings.add(new BuildingSave(pos, (Level)level, name, ownerName, rotation, rallyPoint, isDiagonalBridge, isBuilt, upgradeLevel, portalType, portalDestination));
                ReignOfNether.LOGGER.info("BuildingSaveData.load: " + ownerName + "|" + name);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.buildings.forEach(b -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("buildingName", b.name);
            cTag.m_128405_("x", b.originPos.m_123341_());
            cTag.m_128405_("y", b.originPos.m_123342_());
            cTag.m_128405_("z", b.originPos.m_123343_());
            cTag.m_128359_("rotation", b.rotation.name());
            cTag.m_128405_("rallyX", b.rallyPoint != null ? b.rallyPoint.m_123341_() : b.originPos.m_123341_());
            cTag.m_128405_("rallyY", b.rallyPoint != null ? b.rallyPoint.m_123342_() : b.originPos.m_123342_());
            cTag.m_128405_("rallyZ", b.rallyPoint != null ? b.rallyPoint.m_123343_() : b.originPos.m_123343_());
            cTag.m_128359_("ownerName", b.ownerName);
            cTag.m_128379_("isDiagonalBridge", b.isDiagonalBridge);
            cTag.m_128379_("isBuilt", b.isBuilt);
            cTag.m_128405_("upgradeLevel", b.upgradeLevel);
            cTag.m_128359_("portalType", b.portalType != null ? b.portalType.name() : Portal.PortalType.BASIC.name());
            cTag.m_128405_("xp", b.portalDestination != null ? b.portalDestination.m_123341_() : 0);
            cTag.m_128405_("yp", b.portalDestination != null ? b.portalDestination.m_123342_() : 0);
            cTag.m_128405_("zp", b.portalDestination != null ? b.portalDestination.m_123343_() : 0);
            list.add((Object)cTag);
        });
        tag.m_128365_("buildings", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

