/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingSave;
import com.solegendary.reignofnether.building.BuildingSaveData;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.NetherZoneSaveData;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.buildings.monsters.Dungeon;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.building.buildings.villagers.Castle;
import com.solegendary.reignofnether.building.buildings.villagers.IronGolemBuilding;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.fogofwar.FrozenChunkClientboundPacket;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BuildingServerEvents {
    private static final int BUILDING_SYNC_TICKS_MAX = 20;
    private static int buildingSyncTicks = 20;
    private static final int TNT_BUILDING_BASE_DAMAGE = 20;
    private static final int MAX_SCAFFOLD_DEPTH = 5;
    private static ServerLevel serverLevel = null;
    private static final ArrayList<Building> buildings = new ArrayList();
    public static final ArrayList<NetherZone> netherZones = new ArrayList();
    public static final Random random = new Random();
    private static final int SAVE_TICKS_MAX = 1200;
    private static int saveTicks = 0;
    private static final float MIN_NETHER_BLOCKS_PERCENT = 0.8f;

    public static ArrayList<Building> getBuildings() {
        return buildings;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        ServerLevel level;
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (++saveTicks >= 1200 && (level = evt.getServer().m_129880_(Level.f_46428_)) != null) {
            BuildingServerEvents.saveBuildings(level);
            saveTicks = 0;
        }
    }

    public static void saveBuildings(ServerLevel level) {
        BuildingSaveData buildingData = BuildingSaveData.getInstance((LevelAccessor)serverLevel);
        buildingData.buildings.clear();
        BuildingServerEvents.getBuildings().forEach(b -> {
            BlockPos blockPos;
            Portal portal;
            Portal.PortalType portalType = null;
            if (b instanceof Portal) {
                portal = (Portal)b;
                if (portal.portalType != Portal.PortalType.BASIC) {
                    portalType = portal.portalType;
                }
            }
            ArrayList<BuildingSave> arrayList = buildingData.buildings;
            BlockPos blockPos2 = b.originPos;
            String string = b.name;
            String string2 = b.ownerName;
            Rotation rotation = b.rotation;
            if (b instanceof ProductionBuilding) {
                ProductionBuilding pb = (ProductionBuilding)b;
                blockPos = pb.getRallyPoint();
            } else {
                blockPos = b.originPos;
            }
            arrayList.add(new BuildingSave(blockPos2, (Level)level, string, string2, rotation, blockPos, b.isDiagonalBridge, b.isBuilt, b.getUpgradeLevel(), portalType, b instanceof Portal && (portal = (Portal)b).hasDestination() ? ((Portal)b).destination : new BlockPos(0, 0, 0)));
        });
        buildingData.save();
        level.m_8895_().m_78151_();
    }

    public static void saveNetherZones(ServerLevel level) {
        NetherZoneSaveData netherData = NetherZoneSaveData.getInstance((LevelAccessor)level);
        netherData.netherZones.clear();
        netherData.netherZones.addAll(netherZones);
        netherData.save();
        level.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void loadBuildingsAndNetherZones(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            BuildingSaveData buildingData = BuildingSaveData.getInstance((LevelAccessor)level);
            NetherZoneSaveData netherData = NetherZoneSaveData.getInstance((LevelAccessor)level);
            ArrayList placedNZs = new ArrayList();
            BuildingServerEvents.getBuildings().clear();
            buildingData.buildings.forEach(b -> {
                Building building = BuildingUtils.getNewBuilding(b.name, (Level)level, b.originPos, b.rotation, b.ownerName, b.isDiagonalBridge);
                if (building != null) {
                    building.isBuilt = b.isBuilt;
                    BuildingServerEvents.getBuildings().add(building);
                    if (building instanceof ProductionBuilding) {
                        ProductionBuilding pb = (ProductionBuilding)building;
                        pb.setRallyPoint(b.rallyPoint);
                    }
                    if (b.upgradeLevel > 0) {
                        if (building instanceof Castle) {
                            Castle castle = (Castle)building;
                            castle.changeStructure("castle_with_flag");
                        } else if (building instanceof Laboratory) {
                            Laboratory lab = (Laboratory)building;
                            lab.changeStructure("laboratory_lightning");
                        } else if (building instanceof Portal) {
                            Portal portal = (Portal)building;
                            if (!(building instanceof NeutralTransportPortal)) {
                                portal.changeStructure(b.portalType);
                            }
                            if (b.portalDestination != null && !b.portalDestination.equals((Object)new BlockPos(0, 0, 0))) {
                                portal.destination = b.portalDestination;
                            }
                        } else if (building instanceof Library) {
                            Library library = (Library)building;
                            library.changeStructure("library_grand");
                        } else if (building instanceof Beacon) {
                            Beacon beacon = (Beacon)building;
                            beacon.changeStructure(b.upgradeLevel);
                        }
                    }
                    if (building instanceof NetherConvertingBuilding) {
                        NetherConvertingBuilding ncb = (NetherConvertingBuilding)((Object)building);
                        for (NetherZone nz : netherData.netherZones) {
                            if (!building.isPosInsideBuilding(nz.getOrigin())) continue;
                            ncb.setNetherZone(nz);
                            placedNZs.add(nz.getOrigin());
                            ReignOfNether.LOGGER.info("loaded netherzone for: " + b.name + "|" + b.originPos);
                            break;
                        }
                    }
                    ReignOfNether.LOGGER.info("loaded building in serverevents: " + b.name + "|" + b.originPos);
                }
            });
            netherData.netherZones.forEach(nz -> {
                if (!placedNZs.contains(nz.getOrigin())) {
                    netherZones.add((NetherZone)nz);
                    ReignOfNether.LOGGER.info("loaded orphaned netherzone: " + nz.getOrigin());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            BuildingServerEvents.saveNetherZones(level);
            BuildingServerEvents.saveBuildings(level);
        }
    }

    @Nullable
    public static Building placeBuilding(String buildingName, BlockPos pos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean queue, boolean isDiagonalBridge) {
        Building newBuilding = BuildingUtils.getNewBuilding(buildingName, (Level)serverLevel, pos, rotation, ownerName, isDiagonalBridge);
        boolean buildingExists = buildings.stream().anyMatch(b -> b.originPos.equals((Object)pos));
        if (newBuilding != null && !buildingExists) {
            if (newBuilding instanceof IronGolemBuilding) {
                int currentPop = UnitServerEvents.getCurrentPopulation(serverLevel, ownerName);
                int popSupply = BuildingServerEvents.getTotalPopulationSupply(ownerName);
                boolean canAffordPop = ResourcesServerEvents.resourcesList.stream().anyMatch(r -> r.ownerName.equals(ownerName) && currentPop + ResourceCosts.IRON_GOLEM.population <= popSupply);
                if (!canAffordPop) {
                    ResourcesClientboundPacket.warnInsufficientPopulation(ownerName);
                    return null;
                }
            }
            if (newBuilding.canAfford(ownerName)) {
                if (((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRuleRegistrar.SLANTED_BUILDING)).m_46223_() && !(newBuilding instanceof AbstractBridge)) {
                    BuildingUtils.clearBuildingArea(newBuilding);
                }
                buildings.add(newBuilding);
                newBuilding.forceChunk(true);
                int minY = BuildingUtils.getMinCorner(newBuilding.blocks).m_123342_();
                if (!(newBuilding instanceof AbstractBridge)) {
                    for (BuildingBlock block2 : newBuilding.blocks) {
                        if (block2.getBlockPos().m_123342_() != minY || block2.getBlockState().m_60795_()) continue;
                        BuildingServerEvents.placeScaffoldingUnder(block2, newBuilding);
                    }
                }
                newBuilding.blocks.stream().filter(block -> block.getBlockPos().m_123342_() == minY && newBuilding.startingBlockTypes.contains(block.getBlockState().m_60734_())).forEach(newBuilding::addToBlockPlaceQueue);
                BuildingClientboundPacket.placeBuilding(pos, buildingName, rotation, ownerName, newBuilding.blockPlaceQueue.size(), isDiagonalBridge, 0, false, Portal.PortalType.BASIC, pos, false);
                ResourcesServerEvents.addSubtractResources(new Resources(ownerName, -newBuilding.foodCost, -newBuilding.woodCost, -newBuilding.oreCost));
                if (ownerName.isEmpty() || ownerName.equals("Enemy")) {
                    newBuilding.selfBuilding = true;
                }
                BuildingServerEvents.assignBuilderUnits(builderUnitIds, queue, newBuilding);
                UnitServerEvents.getAllUnits().stream().filter(entity -> {
                    Unit unit;
                    return entity instanceof Unit && (unit = (Unit)entity).getOwnerName().equals(ownerName) && newBuilding.isPosInsideBuilding(entity.m_20097_().m_7494_().m_7494_());
                }).forEach(entity -> BuildingServerEvents.moveNonBuildersAwayFromBuildingFoundations(entity, builderUnitIds, newBuilding));
            } else if (!PlayerServerEvents.isBot(ownerName)) {
                BuildingServerEvents.warnInsufficientResources(newBuilding);
            }
            if (SandboxServer.isAnyoneASandboxPlayer() && builderUnitIds.length == 0) {
                newBuilding.shouldDestroyOnReset = false;
            }
            return newBuilding;
        }
        return null;
    }

    private static void placeScaffoldingUnder(BuildingBlock block, Building newBuilding) {
        BlockPos bpBelow;
        BlockPos basePos = block.getBlockPos();
        int yBelow = 0;
        while (yBelow > -5 && !MiscUtil.isSolidBlocking(newBuilding.level, bpBelow = basePos.m_7918_(0, --yBelow, 0))) {
        }
        if (yBelow <= -5) {
            return;
        }
        for (int y = yBelow + 1; y < 0; ++y) {
            BlockPos scaffoldPos = basePos.m_7918_(0, y, 0);
            BuildingBlock scaffold = new BuildingBlock(scaffoldPos, Blocks.f_50616_.m_49966_());
            newBuilding.getScaffoldBlocks().add(scaffold);
            newBuilding.addToBlockPlaceQueue(scaffold);
        }
    }

    private static void assignBuilderUnits(int[] builderUnitIds, boolean queue, Building newBuilding) {
        for (int id : builderUnitIds) {
            Entity entity = serverLevel.m_6815_(id);
            if (!(entity instanceof WorkerUnit)) continue;
            WorkerUnit workerUnit = (WorkerUnit)entity;
            if (queue) {
                if (workerUnit.getBuildRepairGoal().queuedBuildings.isEmpty()) {
                    ((Unit)entity).resetBehaviours();
                    WorkerUnit.resetBehaviours(workerUnit);
                }
                workerUnit.getBuildRepairGoal().queuedBuildings.add(newBuilding);
                if (workerUnit.getBuildRepairGoal().getBuildingTarget() != null) continue;
                workerUnit.getBuildRepairGoal().startNextQueuedBuilding();
                continue;
            }
            ((Unit)entity).resetBehaviours();
            WorkerUnit.resetBehaviours(workerUnit);
            workerUnit.getBuildRepairGoal().setBuildingTarget(newBuilding);
        }
    }

    private static void warnInsufficientResources(Building newBuilding) {
        ResourcesClientboundPacket.warnInsufficientResources(newBuilding.ownerName, ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.FOOD, newBuilding.foodCost), ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.WOOD, newBuilding.woodCost), ResourcesServerEvents.canAfford(newBuilding.ownerName, ResourceName.ORE, newBuilding.oreCost));
    }

    private static void moveNonBuildersAwayFromBuildingFoundations(LivingEntity entity, int[] builderUnitIds, Building newBuilding) {
        if (Arrays.stream(builderUnitIds).noneMatch(id -> id == entity.m_19879_())) {
            UnitServerEvents.addActionItem(((Unit)entity).getOwnerName(), UnitAction.MOVE, -1, new int[]{entity.m_19879_()}, newBuilding.getClosestGroundPos(entity.m_20097_(), 2), new BlockPos(0, 0, 0));
        }
    }

    public static void cancelBuilding(Building building, String playerName) {
        NetherConvertingBuilding nb;
        if (building == null) {
            return;
        }
        if (building.isBuilt && !SandboxServer.isSandboxPlayer(playerName) && BuildingUtils.getTotalCompletedBuildingsOwned(false, building.ownerName) == 1) {
            return;
        }
        buildings.remove(building);
        if (building instanceof NetherConvertingBuilding && (nb = (NetherConvertingBuilding)((Object)building)).getZone() != null) {
            nb.getZone().startRestoring();
            BuildingServerEvents.saveNetherZones(serverLevel);
        }
        FrozenChunkClientboundPacket.setBuildingDestroyedServerside(building.originPos);
        if (!building.isBuilt || SurvivalServerEvents.isEnabled()) {
            float buildPercent = building.getBlocksPlacedPercent();
            int food = Math.round((float)building.foodCost * (1.0f - buildPercent));
            int wood = Math.round((float)building.woodCost * (1.0f - buildPercent));
            int ore = Math.round((float)building.oreCost * (1.0f - buildPercent));
            if (building.isBuilt && SurvivalServerEvents.isEnabled()) {
                food = Math.round((float)building.foodCost * 0.5f * buildPercent);
                wood = Math.round((float)building.woodCost * 0.5f * buildPercent);
                ore = Math.round((float)building.oreCost * 0.5f * buildPercent);
            }
            if (food > 0 || wood > 0 || ore > 0) {
                ResourcesServerEvents.addSubtractResources(new Resources(building.ownerName, food, wood, ore));
                Resources res = new Resources(building.ownerName, food, wood, ore);
                ResourcesServerEvents.addSubtractResources(res);
                ResourcesClientboundPacket.showFloatingText(res, building.centrePos);
            }
        }
        building.destroy((ServerLevel)building.getLevel());
    }

    public static int getTotalPopulationSupply(String ownerName) {
        if (ResearchServerEvents.playerHasCheat(ownerName, "foodforthought")) {
            return UnitServerEvents.maxPopulation;
        }
        int totalPopulationSupply = 0;
        for (Building building : buildings) {
            if (!building.ownerName.equals(ownerName) || !building.isBuilt) continue;
            totalPopulationSupply += building.popSupply;
        }
        return Math.min(UnitServerEvents.maxPopulation, totalPopulationSupply);
    }

    public static Relationship getUnitToBuildingRelationship(Unit unit, Building building) {
        if (unit.getOwnerName().equals(building.ownerName)) {
            return Relationship.OWNED;
        }
        return Relationship.HOSTILE;
    }

    public static boolean playerHasFinishedBuilding(String playerName, String buildingName) {
        for (Building building : buildings) {
            if (!building.name.equals(buildingName) || !building.isBuilt || !building.ownerName.equals(playerName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static void syncBuildings() {
        for (Building building : BuildingServerEvents.buildings) {
            v0 = building.originPos;
            v1 = building.name;
            v2 = building.rotation;
            v3 = building.ownerName;
            v4 = building.blockPlaceQueue.size();
            if (!(building instanceof AbstractBridge)) ** GOTO lbl-1000
            bridge = (AbstractBridge)building;
            if (bridge.isDiagonalBridge) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v6 = building.getUpgradeLevel();
            v7 = building.isBuilt;
            if (building instanceof Portal) {
                p = (Portal)building;
                v8 = p.portalType;
            } else {
                v8 = Portal.PortalType.BASIC;
            }
            BuildingClientboundPacket.placeBuilding(v0, v1, v2, v3, v4, v5, v6, v7, v8, building instanceof Portal != false && (p = (Portal)building).hasDestination() != false ? p.destination : new BlockPos(0, 0, 0), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
        if (server == null || !server.m_6982_()) {
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(BuildingServerEvents::syncBuildings);
        } else {
            BuildingServerEvents.syncBuildings();
        }
    }

    @SubscribeEvent
    public static void onPlayerBlockBreak(BlockEvent.BreakEvent evt) {
        if (!evt.getLevel().m_5776_()) {
            for (Building building : buildings) {
                if (!building.isPosPartOfBuilding(evt.getPos(), true)) continue;
                building.onBlockBreak((ServerLevel)evt.getLevel(), evt.getPos(), true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(MobSpawnEvent.FinalizeSpawn evt) {
        if (evt.getSpawnType() == MobSpawnType.SPAWNER && evt.getSpawner() != null && evt.getSpawner().getSpawnerBlockEntity() != null) {
            BlockEntity be = evt.getSpawner().getSpawnerBlockEntity();
            BlockPos bp = evt.getSpawner().getSpawnerBlockEntity().m_58899_();
            if (BuildingUtils.findBuilding(false, bp) instanceof Dungeon || BuildingUtils.findBuilding(false, bp) instanceof FlameSanctuary) {
                evt.getEntity().m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        serverLevel = (ServerLevel)evt.level;
        if (--buildingSyncTicks <= 0) {
            buildingSyncTicks = 20;
            for (Building building : buildings) {
                BuildingClientboundPacket.syncBuilding(building.originPos, building.getBlocksPlaced(), building.ownerName);
            }
        }
        List<Building> buildingsToDestroy = buildings.stream().filter(Building::shouldBeDestroyed).toList();
        buildings.removeIf(b -> {
            if (b.shouldBeDestroyed()) {
                NetherConvertingBuilding nb;
                if (b instanceof NetherConvertingBuilding && (nb = (NetherConvertingBuilding)((Object)b)).getZone() != null) {
                    nb.getZone().startRestoring();
                    BuildingServerEvents.saveNetherZones(serverLevel);
                }
                FrozenChunkClientboundPacket.setBuildingDestroyedServerside(b.originPos);
                return true;
            }
            return false;
        });
        for (Building building : buildingsToDestroy) {
            building.destroy(serverLevel);
        }
        for (Building building : buildings) {
            building.tick((Level)serverLevel);
        }
        for (NetherZone netherConversionZone : netherZones) {
            netherConversionZone.tick(serverLevel);
        }
        int n = netherZones.size();
        netherZones.removeIf(NetherZone::isDone);
        int nzSizeAfter = netherZones.size();
        if (n != nzSizeAfter) {
            BuildingServerEvents.saveNetherZones(serverLevel);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate evt) {
        PillagerUnit pUnit;
        Object object;
        Explosion exp = evt.getExplosion();
        GhastUnit ghastUnit = null;
        CreeperUnit creeperUnit = null;
        PillagerUnit pillagerUnit = null;
        Entity entity = evt.getExplosion().getExploder();
        if (entity instanceof CreeperUnit) {
            CreeperUnit cUnit;
            creeperUnit = cUnit = (CreeperUnit)entity;
        } else {
            entity = evt.getExplosion().getExploder();
            if (entity instanceof PillagerUnit) {
                PillagerUnit pUnit2;
                pillagerUnit = pUnit2 = (PillagerUnit)entity;
            } else {
                LargeFireball fireball;
                entity = evt.getExplosion().getExploder();
                if (entity instanceof LargeFireball && (entity = (fireball = (LargeFireball)entity).m_19749_()) instanceof GhastUnit) {
                    GhastUnit gUnit;
                    ghastUnit = gUnit = (GhastUnit)entity;
                }
            }
        }
        if (exp.getExploder() == null && exp.getExploder() == null && ghastUnit == null) {
            evt.getAffectedEntities().clear();
        }
        if ((object = exp.getExploder()) instanceof PillagerUnit && (pUnit = (PillagerUnit)object).m_20159_()) {
            for (Entity entity2 : evt.getAffectedEntities()) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity2;
                le.m_21153_(le.m_21223_() - 1.0f);
            }
        }
        if (creeperUnit != null || ghastUnit != null || pillagerUnit != null || exp.getExploder() instanceof PrimedTnt) {
            HashSet<Building> affectedBuildings = new HashSet<Building>();
            for (BlockPos bp2 : evt.getAffectedBlocks()) {
                Building building = BuildingUtils.findBuilding(false, bp2);
                if (building == null || SurvivalServerEvents.isEnabled() && ghastUnit != null && "Enemy".equals(ghastUnit.getOwnerName()) && "Enemy".equals(building.ownerName)) continue;
                affectedBuildings.add(building);
            }
            for (Building building : affectedBuildings) {
                int atkDmg = 0;
                if (ghastUnit != null) {
                    atkDmg = (int)ghastUnit.getUnitAttackDamage();
                } else if (creeperUnit != null) {
                    atkDmg = (int)creeperUnit.getUnitAttackDamage();
                    if (creeperUnit.m_7090_()) {
                        atkDmg = (int)((float)atkDmg * 1.7f);
                    }
                } else if (pillagerUnit != null) {
                    atkDmg = (int)pillagerUnit.getUnitAttackDamage() / 2;
                } else if (exp.getExploder() instanceof PrimedTnt) {
                    atkDmg = 20;
                }
                if (atkDmg <= 0) continue;
                if (building instanceof GarrisonableBuilding) {
                    GarrisonableBuilding garr = (GarrisonableBuilding)((Object)building);
                    for (LivingEntity le : garr.getOccupants()) {
                        le.m_6469_(exp.m_46077_(), (float)random.nextInt(atkDmg + 1) / 2.0f);
                    }
                }
                if (building instanceof AbstractBridge) {
                    atkDmg /= 2;
                }
                building.destroyRandomBlocks(atkDmg);
            }
        }
        if (!((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRuleRegistrar.DO_UNIT_GRIEFING)).m_46223_()) {
            evt.getAffectedBlocks().removeIf(bp -> {
                BlockState bs = evt.getLevel().m_8055_(bp);
                return !(bs.m_60734_() instanceof LeavesBlock) && !(bs.m_60734_() instanceof TntBlock);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent evt) {
        Building building = BuildingUtils.findBuilding(evt.getEntity().m_9236_().m_5776_(), evt.getEntity().m_20097_());
        if (building != null) {
            Portal portal;
            Player player;
            evt.setCanceled(true);
            Entity entity = evt.getEntity();
            if (entity instanceof Player && !(player = (Player)entity).m_5833_() && (AlliancesServerEvents.isAllied(player.m_7755_().getString(), building.ownerName) || building instanceof NeutralTransportPortal) && building instanceof Portal && (portal = (Portal)building).hasDestination()) {
                player.m_20219_(Vec3.m_82512_((Vec3i)portal.destination));
                building.level.m_5594_(null, building.centrePos, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                building.level.m_5594_(null, portal.destination, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent evt) {
        if (BuildingUtils.isPosInsideAnyBuilding(evt.getEntity().m_9236_().m_5776_(), evt.getPos())) {
            evt.setCanceled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void replaceClientBuilding(BlockPos buildingPos) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        for (Building building : BuildingServerEvents.buildings) {
            if (!building.originPos.equals((Object)buildingPos)) continue;
            v0 = building.originPos;
            v1 = building.name;
            v2 = building.rotation;
            v3 = building.ownerName;
            v4 = building.blockPlaceQueue.size();
            if (!(building instanceof AbstractBridge)) ** GOTO lbl-1000
            bridge = (AbstractBridge)building;
            if (bridge.isDiagonalBridge) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v6 = building.getUpgradeLevel();
            v7 = building.isBuilt;
            if (building instanceof Portal) {
                p = (Portal)building;
                v8 = p.portalType;
            } else {
                v8 = Portal.PortalType.BASIC;
            }
            if (!(building instanceof Portal)) ** GOTO lbl-1000
            p = (Portal)building;
            if (p.portalType == Portal.PortalType.TRANSPORT) {
                v9 = p.destination;
            } else lbl-1000:
            // 2 sources

            {
                v9 = new BlockPos(0, 0, 0);
            }
            BuildingClientboundPacket.placeBuilding(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, false);
            return;
        }
    }

    public static boolean isOnNetherBlocks(List<BuildingBlock> blocks, BlockPos originPos, ServerLevel level) {
        int netherBlocksBelow = 0;
        int blocksBelow = 0;
        for (BuildingBlock block : blocks) {
            if (block.getBlockPos().m_123342_() != originPos.m_123342_() + 1 || level == null) continue;
            BlockPos bp = block.getBlockPos();
            BlockState bs = block.getBlockState();
            if (!bs.m_280296_()) continue;
            ++blocksBelow;
            if (!NetherBlocks.isNetherBlock((Level)level, bp.m_7495_())) continue;
            ++netherBlocksBelow;
        }
        if (blocksBelow <= 0) {
            return false;
        }
        return (float)netherBlocksBelow / (float)blocksBelow > 0.8f;
    }
}

