/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingAction;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.building.buildings.shared.AbstractStockpile;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.network.NetworkEvent;

public class BuildingServerboundPacket {
    public String itemName;
    public BlockPos buildingPos;
    public BlockPos rallyPos;
    public Rotation rotation;
    public String ownerName;
    public int[] builderUnitIds;
    public BuildingAction action;
    public Boolean isDiagonalBridge;
    private static final List<BuildingAction> newBuildingAuthActions = List.of(BuildingAction.PLACE, BuildingAction.PLACE_AND_QUEUE);
    private static final List<BuildingAction> existingBuildingAuthActions = List.of(BuildingAction.DESTROY, BuildingAction.SET_RALLY_POINT, BuildingAction.SET_RALLY_POINT_ENTITY, BuildingAction.START_PRODUCTION, BuildingAction.CANCEL_PRODUCTION, BuildingAction.CANCEL_BACK_PRODUCTION, BuildingAction.CHANGE_PORTAL);

    public static void placeBuilding(String itemName, BlockPos originPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.PLACE, itemName, originPos, BlockPos.f_121853_, rotation, ownerName, builderUnitIds, isDiagonalBridge));
    }

    public static void placeAndQueueBuilding(String itemName, BlockPos originPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.PLACE_AND_QUEUE, itemName, originPos, BlockPos.f_121853_, rotation, ownerName, builderUnitIds, isDiagonalBridge));
    }

    public static void cancelBuilding(BlockPos buildingPos, String ownerName) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.DESTROY, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, ownerName, new int[0], false));
    }

    public static void setRallyPoint(BlockPos buildingPos, BlockPos rallyPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.SET_RALLY_POINT, "", buildingPos, rallyPos, Rotation.NONE, "", new int[0], false));
    }

    public static void setRallyPointEntity(BlockPos buildingPos, int entityId) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.SET_RALLY_POINT_ENTITY, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[]{entityId}, false));
    }

    public static void startProduction(BlockPos buildingPos, String itemName) {
        BuildingClientEvents.switchHudToIdlestBuilding();
        if (HudClientEvents.hudSelectedBuilding != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.START_PRODUCTION, itemName, HudClientEvents.hudSelectedBuilding.originPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
        }
    }

    public static void cancelProduction(BlockPos buildingPos, String itemName, boolean frontItem) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(frontItem ? BuildingAction.CANCEL_PRODUCTION : BuildingAction.CANCEL_BACK_PRODUCTION, itemName, buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public static void checkStockpileChests(BlockPos chestPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.CHECK_STOCKPILE_CHEST, "", chestPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public static void requestReplacement(BlockPos buildingPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.REQUEST_REPLACEMENT, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public BuildingServerboundPacket(BuildingAction action, String itemName, BlockPos buildingPos, BlockPos rallyPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        this.action = action;
        this.itemName = itemName;
        this.buildingPos = buildingPos;
        this.rallyPos = rallyPos;
        this.rotation = rotation;
        this.ownerName = ownerName;
        this.builderUnitIds = builderUnitIds;
        this.isDiagonalBridge = isDiagonalBridge;
    }

    public BuildingServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (BuildingAction)buffer.m_130066_(BuildingAction.class);
        this.itemName = buffer.m_130277_();
        this.buildingPos = buffer.m_130135_();
        this.rallyPos = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.ownerName = buffer.m_130277_();
        this.builderUnitIds = buffer.m_130100_();
        this.isDiagonalBridge = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.itemName);
        buffer.m_130064_(this.buildingPos);
        buffer.m_130064_(this.rallyPos);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130070_(this.ownerName);
        buffer.m_130089_(this.builderUnitIds);
        buffer.writeBoolean(this.isDiagonalBridge.booleanValue());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            Building building = null;
            if (!List.of(BuildingAction.PLACE, BuildingAction.PLACE_AND_QUEUE).contains((Object)this.action) && (building = BuildingUtils.findBuilding(false, this.buildingPos)) == null) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("Sender for unit action packet was null");
                success.set(false);
                return;
            }
            if ((newBuildingAuthActions.contains((Object)this.action) && !player.m_7755_().getString().equals(this.ownerName) || existingBuildingAuthActions.contains((Object)this.action) && building != null && !player.m_7755_().getString().equals(building.ownerName)) && !SandboxServer.isAnyoneASandboxPlayer()) {
                ReignOfNether.LOGGER.warn("BuildingServerboundPacket: Tried to process packet from " + player.m_7755_() + " for " + this.ownerName);
                success.set(false);
                return;
            }
            switch (this.action) {
                case PLACE: {
                    BuildingServerEvents.placeBuilding(this.itemName, this.buildingPos, this.rotation, this.ownerName, this.builderUnitIds, false, this.isDiagonalBridge);
                    break;
                }
                case PLACE_AND_QUEUE: {
                    BuildingServerEvents.placeBuilding(this.itemName, this.buildingPos, this.rotation, this.ownerName, this.builderUnitIds, true, this.isDiagonalBridge);
                    break;
                }
                case DESTROY: {
                    BuildingServerEvents.cancelBuilding(building, this.ownerName);
                    break;
                }
                case SET_RALLY_POINT: {
                    if (!(building instanceof ProductionBuilding)) break;
                    ProductionBuilding productionBuilding = (ProductionBuilding)building;
                    productionBuilding.setRallyPoint(this.rallyPos);
                    break;
                }
                case SET_RALLY_POINT_ENTITY: {
                    if (!(building instanceof ProductionBuilding)) break;
                    ProductionBuilding productionBuilding = (ProductionBuilding)building;
                    Entity e = building.level.m_6815_(this.builderUnitIds[0]);
                    if (!(e instanceof LivingEntity)) break;
                    LivingEntity le = (LivingEntity)e;
                    productionBuilding.setRallyPointEntity(le);
                    break;
                }
                case START_PRODUCTION: {
                    boolean prodSuccess = ProductionBuilding.startProductionItem((ProductionBuilding)building, this.itemName, this.buildingPos);
                    if (!prodSuccess) break;
                    BuildingClientboundPacket.startProduction(this.buildingPos, this.itemName);
                    break;
                }
                case CANCEL_PRODUCTION: {
                    ProductionBuilding pBuilding;
                    boolean cancelSuccess;
                    if (!(building instanceof ProductionBuilding) || !(cancelSuccess = ProductionBuilding.cancelProductionItem(pBuilding = (ProductionBuilding)building, this.itemName, this.buildingPos, true)) && !pBuilding.productionQueue.isEmpty()) break;
                    BuildingClientboundPacket.cancelProduction(this.buildingPos, this.itemName, true);
                    break;
                }
                case CANCEL_BACK_PRODUCTION: {
                    ProductionBuilding pBuilding;
                    boolean cancelSuccess;
                    if (!(building instanceof ProductionBuilding) || !(cancelSuccess = ProductionBuilding.cancelProductionItem(pBuilding = (ProductionBuilding)building, this.itemName, this.buildingPos, false)) && !pBuilding.productionQueue.isEmpty()) break;
                    BuildingClientboundPacket.cancelProduction(this.buildingPos, this.itemName, false);
                    break;
                }
                case CHECK_STOCKPILE_CHEST: {
                    if (!(building instanceof AbstractStockpile)) {
                        if (!(building instanceof Portal)) break;
                        Portal portal = (Portal)building;
                        if (portal.portalType != Portal.PortalType.CIVILIAN) break;
                    }
                    AbstractStockpile.checkAndConsumeChestItems(building);
                    break;
                }
                case REQUEST_REPLACEMENT: {
                    BuildingServerEvents.replaceClientBuilding(this.buildingPos);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

