/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.buildings.monsters.DarkWatchtower;
import com.solegendary.reignofnether.building.buildings.monsters.Dungeon;
import com.solegendary.reignofnether.building.buildings.monsters.Graveyard;
import com.solegendary.reignofnether.building.buildings.monsters.HauntedHouse;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.building.buildings.monsters.Mausoleum;
import com.solegendary.reignofnether.building.buildings.monsters.PumpkinFarm;
import com.solegendary.reignofnether.building.buildings.monsters.SculkCatalyst;
import com.solegendary.reignofnether.building.buildings.monsters.SlimePit;
import com.solegendary.reignofnether.building.buildings.monsters.SpiderLair;
import com.solegendary.reignofnether.building.buildings.monsters.SpruceBridge;
import com.solegendary.reignofnether.building.buildings.monsters.SpruceStockpile;
import com.solegendary.reignofnether.building.buildings.monsters.Stronghold;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.neutral.CapturableBeacon;
import com.solegendary.reignofnether.building.buildings.neutral.EndPortal;
import com.solegendary.reignofnether.building.buildings.neutral.HealingFountain;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.piglins.BasaltSprings;
import com.solegendary.reignofnether.building.buildings.piglins.Bastion;
import com.solegendary.reignofnether.building.buildings.piglins.BlackstoneBridge;
import com.solegendary.reignofnether.building.buildings.piglins.CentralPortal;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.buildings.piglins.Fortress;
import com.solegendary.reignofnether.building.buildings.piglins.HoglinStables;
import com.solegendary.reignofnether.building.buildings.piglins.NetherwartFarm;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.building.buildings.piglins.WitherShrine;
import com.solegendary.reignofnether.building.buildings.villagers.ArcaneTower;
import com.solegendary.reignofnether.building.buildings.villagers.Barracks;
import com.solegendary.reignofnether.building.buildings.villagers.Blacksmith;
import com.solegendary.reignofnether.building.buildings.villagers.Castle;
import com.solegendary.reignofnether.building.buildings.villagers.IronGolemBuilding;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.building.buildings.villagers.OakBridge;
import com.solegendary.reignofnether.building.buildings.villagers.OakStockpile;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.building.buildings.villagers.VillagerHouse;
import com.solegendary.reignofnether.building.buildings.villagers.Watchtower;
import com.solegendary.reignofnether.building.buildings.villagers.WheatFarm;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BuildingUtils {
    public static int getTotalCompletedBuildingsOwned(boolean isClientSide, String ownerName) {
        List<Building> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        return buildings.stream().filter(b -> b.isBuilt && b.ownerName.equals(ownerName)).toList().size();
    }

    public static boolean isBuildingBuildable(boolean isClientSide, Building building) {
        if (isClientSide) {
            return BuildingClientEvents.getBuildings().stream().map(b -> b.originPos).toList().contains(building.originPos) && building.getBlocksPlaced() < building.getBlocksTotal();
        }
        return BuildingServerEvents.getBuildings().stream().map(b -> b.originPos).toList().contains(building.originPos) && building.getBlocksPlaced() < building.getBlocksTotal();
    }

    public static ArrayList<BlockPos> getUniqueChunkBps(Building building) {
        AABB aabb = new AABB(building.minCorner, building.maxCorner.m_7918_(1, 1, 1));
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        double x = aabb.f_82288_;
        double z = aabb.f_82290_;
        while (true) {
            bps.add(new BlockPos((int)x, (int)aabb.f_82289_, (int)z));
            if ((x += 16.0) <= aabb.f_82291_) continue;
            x = aabb.f_82288_;
            if (!((z += 16.0) <= aabb.f_82293_)) break;
        }
        bps.add(new BlockPos((int)aabb.f_82291_, (int)aabb.f_82289_, (int)aabb.f_82290_));
        bps.add(new BlockPos((int)aabb.f_82288_, (int)aabb.f_82289_, (int)aabb.f_82293_));
        bps.add(new BlockPos((int)aabb.f_82291_, (int)aabb.f_82289_, (int)aabb.f_82293_));
        return bps;
    }

    public static Building getNewBuilding(String buildingName, Level level, BlockPos pos, Rotation rotation, String ownerName, boolean isDiagonalBridge) {
        if (buildingName.toLowerCase().contains("bridge")) {
            ownerName = "";
        }
        if (buildingName.equals("Beacon") && BuildingUtils.getBeacon(level.f_46443_) != null) {
            return null;
        }
        Building building = null;
        switch (buildingName) {
            case "Oak Bridge": {
                building = new OakBridge(level, pos, rotation, ownerName, isDiagonalBridge);
                break;
            }
            case "Spruce Bridge": {
                building = new SpruceBridge(level, pos, rotation, ownerName, isDiagonalBridge);
                break;
            }
            case "Blackstone Bridge": {
                building = new BlackstoneBridge(level, pos, rotation, ownerName, isDiagonalBridge);
                break;
            }
            case "Stockpile": {
                building = new OakStockpile(level, pos, rotation, ownerName);
                break;
            }
            case "Dark Stockpile": {
                building = new SpruceStockpile(level, pos, rotation, ownerName);
                break;
            }
            case "Villager House": {
                building = new VillagerHouse(level, pos, rotation, ownerName);
                break;
            }
            case "Graveyard": {
                building = new Graveyard(level, pos, rotation, ownerName);
                break;
            }
            case "Wheat Farm": {
                building = new WheatFarm(level, pos, rotation, ownerName);
                break;
            }
            case "Laboratory": {
                building = new Laboratory(level, pos, rotation, ownerName);
                break;
            }
            case "Barracks": {
                building = new Barracks(level, pos, rotation, ownerName);
                break;
            }
            case "Pumpkin Farm": {
                building = new PumpkinFarm(level, pos, rotation, ownerName);
                break;
            }
            case "Haunted House": {
                building = new HauntedHouse(level, pos, rotation, ownerName);
                break;
            }
            case "Blacksmith": {
                building = new Blacksmith(level, pos, rotation, ownerName);
                break;
            }
            case "Town Centre": {
                building = new TownCentre(level, pos, rotation, ownerName);
                break;
            }
            case "Iron Golem": {
                building = new IronGolemBuilding(level, pos, rotation, ownerName);
                break;
            }
            case "Mausoleum": {
                building = new Mausoleum(level, pos, rotation, ownerName);
                break;
            }
            case "Sculk Catalyst": {
                building = new SculkCatalyst(level, pos, rotation, ownerName);
                break;
            }
            case "Spider Lair": {
                building = new SpiderLair(level, pos, rotation, ownerName);
                break;
            }
            case "Slime Pit": {
                building = new SlimePit(level, pos, rotation, ownerName);
                break;
            }
            case "Arcane Tower": {
                building = new ArcaneTower(level, pos, rotation, ownerName);
                break;
            }
            case "Library": {
                building = new Library(level, pos, rotation, ownerName);
                break;
            }
            case "Dungeon": {
                building = new Dungeon(level, pos, rotation, ownerName);
                break;
            }
            case "Watchtower": {
                building = new Watchtower(level, pos, rotation, ownerName);
                break;
            }
            case "Dark Watchtower": {
                building = new DarkWatchtower(level, pos, rotation, ownerName);
                break;
            }
            case "Castle": {
                building = new Castle(level, pos, rotation, ownerName);
                break;
            }
            case "Stronghold": {
                building = new Stronghold(level, pos, rotation, ownerName);
                break;
            }
            case "Central Portal": {
                building = new CentralPortal(level, pos, rotation, ownerName);
                break;
            }
            case "Basic Portal": 
            case "Military Portal": 
            case "Civilian Portal": 
            case "Transport Portal": {
                building = new Portal(level, pos, rotation, ownerName, false);
                break;
            }
            case "Netherwart Farm": {
                building = new NetherwartFarm(level, pos, rotation, ownerName);
                break;
            }
            case "Bastion": {
                building = new Bastion(level, pos, rotation, ownerName);
                break;
            }
            case "Hoglin Stables": {
                building = new HoglinStables(level, pos, rotation, ownerName);
                break;
            }
            case "Flame Sanctuary": {
                building = new FlameSanctuary(level, pos, rotation, ownerName);
                break;
            }
            case "Wither Shrine": {
                building = new WitherShrine(level, pos, rotation, ownerName);
                break;
            }
            case "Basalt Springs": {
                building = new BasaltSprings(level, pos, rotation, ownerName);
                break;
            }
            case "Fortress": {
                building = new Fortress(level, pos, rotation, ownerName);
                break;
            }
            case "Beacon": {
                building = new Beacon(level, pos, rotation, ownerName);
                break;
            }
            case "The Beacon": {
                building = new CapturableBeacon(level, pos, rotation, ownerName);
                break;
            }
            case "End Portal": {
                building = new EndPortal(level, pos, rotation, ownerName);
                break;
            }
            case "Healing Fountain": {
                building = new HealingFountain(level, pos, rotation, ownerName);
                break;
            }
            case "Neutral Transport Portal": {
                building = new NeutralTransportPortal(level, pos, rotation, ownerName);
            }
        }
        if (building != null) {
            building.setLevel(level);
        }
        return building;
    }

    public static Building findBuilding(boolean isClientSide, BlockPos pos) {
        List<Building> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (Building building : buildings) {
            if (!building.originPos.equals((Object)pos) && !building.isPosInsideBuilding(pos)) continue;
            return building;
        }
        return null;
    }

    public static BlockPos getMinCorner(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos(minMax.minX, minMax.minY, minMax.minZ);
    }

    public static BlockPos getMaxCorner(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos(minMax.maxX, minMax.maxY, minMax.maxZ);
    }

    public static BlockPos getCentrePos(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos((minMax.minX + minMax.maxX) / 2, (minMax.minY + minMax.maxY) / 2, (minMax.minZ + minMax.maxZ) / 2);
    }

    private static MinMaxValues calculateMinMax(ArrayList<BuildingBlock> blocks) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BuildingBlock block : blocks) {
            BlockPos pos = block.getBlockPos();
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        return new MinMaxValues(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Vec3i getBuildingSize(ArrayList<BuildingBlock> blocks) {
        BlockPos min = BuildingUtils.getMinCorner(blocks);
        BlockPos max = BuildingUtils.getMaxCorner(blocks);
        return new Vec3i(max.m_123341_() - min.m_123341_(), max.m_123342_() - min.m_123342_(), max.m_123343_() - min.m_123343_());
    }

    public static ArrayList<BuildingBlock> getAbsoluteBlockData(ArrayList<BuildingBlock> staticBlocks, LevelAccessor level, BlockPos originPos, Rotation rotation) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        for (BuildingBlock block : staticBlocks) {
            block = block.rotate(level, rotation);
            BlockPos bp = block.getBlockPos();
            block.setBlockPos(new BlockPos(bp.m_123341_() + originPos.m_123341_(), bp.m_123342_() + originPos.m_123342_() + 1, bp.m_123343_() + originPos.m_123343_()));
            blocks.add(block);
        }
        return blocks;
    }

    public static boolean isPosPartOfAnyBuilding(boolean isClientSide, BlockPos bp, boolean onlyPlacedBlocks, int range) {
        List<Building> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        int rangeSquared = range * range;
        return buildings.stream().anyMatch(building -> (range == 0 || bp.m_123331_((Vec3i)building.centrePos) < (double)rangeSquared) && building.isPosPartOfBuilding(bp, onlyPlacedBlocks));
    }

    public static boolean isPosInsideAnyBuilding(boolean isClientSide, BlockPos bp) {
        List<Building> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (Building building : buildings) {
            if (!building.isPosInsideBuilding(bp)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Building findClosestBuilding(boolean isClientSide, Vec3 pos, Predicate<Building> condition) {
        List<Building> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        double closestDist = 9999.0;
        Building closestBuilding = null;
        for (Building building : buildings) {
            BlockPos bp;
            Vec3 bpVec3;
            double dist;
            if (!condition.test(building) || !((dist = (bpVec3 = new Vec3((double)(bp = building.centrePos).m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_())).m_82557_(pos)) < closestDist)) continue;
            closestDist = dist;
            closestBuilding = building;
        }
        return closestBuilding;
    }

    public static boolean isInNetherRange(boolean isClientSide, BlockPos bp) {
        List<Building> buildings = BuildingUtils.getBuildingsList(isClientSide);
        for (Building building : buildings) {
            if (!(building instanceof NetherConvertingBuilding)) continue;
            NetherConvertingBuilding netherBuilding = (NetherConvertingBuilding)((Object)building);
            double maxRangeSquared = Math.pow(netherBuilding.getMaxRange(), 2.0);
            if (!(bp.m_123331_((Vec3i)building.centrePos) <= maxRangeSquared)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWithinRangeOfMaxedCatalyst(LivingEntity entity) {
        List<Building> buildings = BuildingUtils.getBuildingsList(entity.m_9236_().m_5776_());
        double maxCatalystRangeSquared = 100.0;
        for (Building building : buildings) {
            if (!(building instanceof SculkCatalyst)) continue;
            SculkCatalyst sc = (SculkCatalyst)building;
            if (!(entity.m_20238_(Vec3.m_82512_((Vec3i)sc.centrePos)) < maxCatalystRangeSquared) || !((float)sc.getUncappedNightRange() >= 75.0f)) continue;
            return true;
        }
        return false;
    }

    private static List<Building> getBuildingsList(boolean isClientSide) {
        return isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
    }

    public static Beacon getBeacon(boolean isClientSide) {
        List<Building> buildings = BuildingUtils.getBuildingsList(isClientSide);
        for (Building building : buildings) {
            if (!(building instanceof Beacon)) continue;
            Beacon beacon = (Beacon)building;
            return beacon;
        }
        return null;
    }

    public static void clearBuildingArea(Building building) {
        if (building != null) {
            for (int x = building.minCorner.m_123341_() - 1; x < building.maxCorner.m_123341_() + 2; ++x) {
                for (int y = building.minCorner.m_123342_(); y < building.maxCorner.m_123342_() + 2; ++y) {
                    for (int z = building.minCorner.m_123343_() - 1; z < building.maxCorner.m_123343_() + 2; ++z) {
                        if (BuildingUtils.isPosInsideAnyBuilding(building.level.m_5776_(), new BlockPos(x, y, z))) continue;
                        building.getLevel().m_46597_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    private static class MinMaxValues {
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;

        public MinMaxValues(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }
    }
}

