/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface GarrisonableBuilding {
    public int getAttackRange();

    public int getExternalAttackRangeBonus();

    public BlockPos getEntryPosition();

    public BlockPos getExitPosition();

    public boolean isFull();

    default public List<LivingEntity> getOccupants() {
        GarrisonableBuilding garrisonableBuilding = this;
        if (garrisonableBuilding instanceof Building) {
            Building building = (Building)((Object)garrisonableBuilding);
            if (building.level.m_5776_()) {
                return UnitClientEvents.getAllUnits().stream().filter(le -> {
                    Unit u;
                    return le instanceof Unit && GarrisonableBuilding.getGarrison(u = (Unit)le) == this;
                }).toList();
            }
            return UnitServerEvents.getAllUnits().stream().filter(le -> {
                Unit u;
                return le instanceof Unit && GarrisonableBuilding.getGarrison(u = (Unit)le) == this;
            }).toList();
        }
        return List.of();
    }

    public static GarrisonableBuilding getGarrison(Unit unit) {
        List<Building> buildings = ((Entity)unit).m_9236_().m_5776_() ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (Building building : buildings) {
            boolean isAllied = ((Entity)unit).m_9236_().m_5776_() ? AlliancesClient.isAllied(unit.getOwnerName(), building.ownerName) : AlliancesServerEvents.isAllied(unit.getOwnerName(), building.ownerName);
            if (!unit.getOwnerName().equals(building.ownerName) && !isAllied && (!unit.getOwnerName().isEmpty() || !building.ownerName.isEmpty()) || !(building instanceof GarrisonableBuilding)) continue;
            GarrisonableBuilding garr = (GarrisonableBuilding)((Object)building);
            if (!building.isBuilt || !building.isPosInsideBuilding(((LivingEntity)unit).m_20097_()) || ((LivingEntity)unit).m_20097_().m_123342_() <= building.originPos.m_123342_() + 2) continue;
            return garr;
        }
        return null;
    }

    public static int getNumOccupants(Building building) {
        ArrayList<LivingEntity> entities = building.getLevel().m_5776_() ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        int numOccupants = 0;
        for (LivingEntity entity : entities) {
            if (!building.isPosInsideBuilding(entity.m_20097_()) || entity.m_20097_().m_123342_() <= building.originPos.m_123342_() + 2) continue;
            ++numOccupants;
        }
        return numOccupants;
    }
}

