/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.researchItems.ResearchAdvancedPortals;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel1;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel2;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel3;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel4;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel5;
import com.solegendary.reignofnether.research.researchItems.ResearchBlazeFirewall;
import com.solegendary.reignofnether.research.researchItems.ResearchBloodlust;
import com.solegendary.reignofnether.research.researchItems.ResearchBruteShields;
import com.solegendary.reignofnether.research.researchItems.ResearchCastleFlag;
import com.solegendary.reignofnether.research.researchItems.ResearchCubeMagma;
import com.solegendary.reignofnether.research.researchItems.ResearchDrowned;
import com.solegendary.reignofnether.research.researchItems.ResearchEvokerVexes;
import com.solegendary.reignofnether.research.researchItems.ResearchFireResistance;
import com.solegendary.reignofnether.research.researchItems.ResearchGolemSmithing;
import com.solegendary.reignofnether.research.researchItems.ResearchGrandLibrary;
import com.solegendary.reignofnether.research.researchItems.ResearchHealingPotions;
import com.solegendary.reignofnether.research.researchItems.ResearchHeavyTridents;
import com.solegendary.reignofnether.research.researchItems.ResearchHoglinCavalry;
import com.solegendary.reignofnether.research.researchItems.ResearchHusks;
import com.solegendary.reignofnether.research.researchItems.ResearchLabLightningRod;
import com.solegendary.reignofnether.research.researchItems.ResearchLingeringPotions;
import com.solegendary.reignofnether.research.researchItems.ResearchPillagerCrossbows;
import com.solegendary.reignofnether.research.researchItems.ResearchPoisonSpiders;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForCivilian;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForMilitary;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForTransport;
import com.solegendary.reignofnether.research.researchItems.ResearchRavagerCavalry;
import com.solegendary.reignofnether.research.researchItems.ResearchResourceCapacity;
import com.solegendary.reignofnether.research.researchItems.ResearchSculkAmplifiers;
import com.solegendary.reignofnether.research.researchItems.ResearchSilverfish;
import com.solegendary.reignofnether.research.researchItems.ResearchSlimeConversion;
import com.solegendary.reignofnether.research.researchItems.ResearchSoulFireballs;
import com.solegendary.reignofnether.research.researchItems.ResearchSpiderJockeys;
import com.solegendary.reignofnether.research.researchItems.ResearchSpiderWebs;
import com.solegendary.reignofnether.research.researchItems.ResearchStrays;
import com.solegendary.reignofnether.research.researchItems.ResearchVindicatorAxes;
import com.solegendary.reignofnether.research.researchItems.ResearchWaterPotions;
import com.solegendary.reignofnether.research.researchItems.ResearchWitherClouds;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperProd;
import com.solegendary.reignofnether.unit.units.monsters.DrownedProd;
import com.solegendary.reignofnether.unit.units.monsters.HuskProd;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerProd;
import com.solegendary.reignofnether.unit.units.monsters.PoisonSpiderProd;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonProd;
import com.solegendary.reignofnether.unit.units.monsters.SlimeProd;
import com.solegendary.reignofnether.unit.units.monsters.SpiderProd;
import com.solegendary.reignofnether.unit.units.monsters.StrayProd;
import com.solegendary.reignofnether.unit.units.monsters.WardenProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerProd;
import com.solegendary.reignofnether.unit.units.neutral.EndermanProd;
import com.solegendary.reignofnether.unit.units.piglins.BlazeProd;
import com.solegendary.reignofnether.unit.units.piglins.BruteProd;
import com.solegendary.reignofnether.unit.units.piglins.GhastProd;
import com.solegendary.reignofnether.unit.units.piglins.GruntProd;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterProd;
import com.solegendary.reignofnether.unit.units.piglins.HoglinProd;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeProd;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantProd;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonProd;
import com.solegendary.reignofnether.unit.units.villagers.EvokerProd;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemProd;
import com.solegendary.reignofnether.unit.units.villagers.PillagerProd;
import com.solegendary.reignofnether.unit.units.villagers.RavagerProd;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardProd;
import com.solegendary.reignofnether.unit.units.villagers.VillagerProd;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorProd;
import com.solegendary.reignofnether.unit.units.villagers.WitchProd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public abstract class ProductionBuilding
extends Building {
    public List<Button> productionButtons = new ArrayList<Button>();
    public final List<ProductionItem> productionQueue = new ArrayList<ProductionItem>();
    private BlockPos rallyPoint;
    private LivingEntity rallyPointEntity;
    public boolean canSetRallyPoint = true;
    protected float spawnRadiusOffset = 1.0f;

    public ProductionBuilding(Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(level, originPos, rotation, ownerName, blocks, isCapitol);
    }

    public BlockPos getRallyPoint() {
        return this.rallyPoint;
    }

    public LivingEntity getRallyPointEntity() {
        if (this.rallyPointEntity == null) {
            return null;
        }
        if (!this.rallyPointEntity.m_6084_()) {
            this.rallyPointEntity = null;
            return null;
        }
        return this.rallyPointEntity;
    }

    public void setRallyPoint(BlockPos rallyPoint) {
        if (!this.canSetRallyPoint) {
            return;
        }
        this.rallyPoint = this.isPosInsideBuilding(rallyPoint) ? null : rallyPoint;
        this.rallyPointEntity = null;
    }

    public void setRallyPointEntity(LivingEntity entity) {
        Unit unit;
        if (!this.canSetRallyPoint || entity == null) {
            return;
        }
        if (!(entity instanceof Unit) || (unit = (Unit)entity).getOwnerName().equals(this.ownerName)) {
            this.rallyPointEntity = entity;
        }
        this.rallyPoint = null;
    }

    private boolean isProducing() {
        return this.productionQueue.size() > 0;
    }

    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        BlockPos spawnPoint = this.centrePos;
        while (level.m_8055_(spawnPoint.m_7495_()).m_60795_()) {
            spawnPoint = spawnPoint.m_7918_(0, -1, 0);
        }
        return spawnPoint;
    }

    public BlockPos getDefaultOutdoorSpawnPoint() {
        return BuildingUtils.getMinCorner(this.blocks).m_7918_((int)(-this.spawnRadiusOffset), 0, (int)(-this.spawnRadiusOffset));
    }

    public Entity produceUnit(ServerLevel level, EntityType<? extends Unit> entityType, String ownerName, boolean spawnIndoors) {
        BlockPos rallyPoint;
        BlockPos spawnPoint;
        LivingEntity rallyEntity = this.getRallyPointEntity();
        if (spawnIndoors) {
            spawnPoint = this.getIndoorSpawnPoint(level);
            if (entityType == EntityRegistrar.GHAST_UNIT.get()) {
                spawnPoint = spawnPoint.m_7918_(0, 5, 0);
            }
        } else {
            spawnPoint = this.rallyPoint != null ? this.getClosestGroundPos(this.rallyPoint, (int)this.spawnRadiusOffset) : (this.rallyPointEntity != null ? this.getClosestGroundPos(this.rallyPointEntity.m_20097_(), (int)this.spawnRadiusOffset) : this.getDefaultOutdoorSpawnPoint());
        }
        Entity entity = entityType.m_262455_(level, (CompoundTag)null, null, spawnPoint, MobSpawnType.SPAWNER, true, false);
        BlockPos defaultRallyPoint = this.getDefaultOutdoorSpawnPoint();
        BlockPos blockPos = rallyPoint = this.rallyPoint == null ? defaultRallyPoint : this.rallyPoint;
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            unit.setOwnerName(ownerName);
            unit.setupEquipmentAndUpgradesServer();
            if (rallyEntity != null) {
                if (ResourceSources.isHuntableAnimal(rallyEntity)) {
                    CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.ATTACK, rallyEntity.m_19879_(), new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
                } else {
                    CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.FOLLOW, rallyEntity.m_19879_(), new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
                }
            } else {
                CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.MOVE, -1, new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
            }
        }
        return entity;
    }

    public static boolean startProductionItem(ProductionBuilding building, String itemName, BlockPos pos) {
        boolean success = false;
        if (building != null) {
            ProductionItem prodItem = null;
            switch (itemName) {
                case "Creeper": {
                    prodItem = new CreeperProd(building);
                    break;
                }
                case "Skeleton": {
                    prodItem = new SkeletonProd(building);
                    break;
                }
                case "Zombie": {
                    prodItem = new ZombieProd(building);
                    break;
                }
                case "Stray": {
                    prodItem = new StrayProd(building);
                    break;
                }
                case "Husk": {
                    prodItem = new HuskProd(building);
                    break;
                }
                case "Drowned": {
                    prodItem = new DrownedProd(building);
                    break;
                }
                case "Spider": {
                    prodItem = new SpiderProd(building);
                    break;
                }
                case "Poison Spider": {
                    prodItem = new PoisonSpiderProd(building);
                    break;
                }
                case "Villager": {
                    prodItem = new VillagerProd(building);
                    break;
                }
                case "Zombie Villager": {
                    prodItem = new ZombieVillagerProd(building);
                    break;
                }
                case "Vindicator": {
                    prodItem = new VindicatorProd(building);
                    break;
                }
                case "Pillager": {
                    prodItem = new PillagerProd(building);
                    break;
                }
                case "Iron Golem": {
                    prodItem = new IronGolemProd(building);
                    break;
                }
                case "Witch": {
                    prodItem = new WitchProd(building);
                    break;
                }
                case "Evoker": {
                    prodItem = new EvokerProd(building);
                    break;
                }
                case "Slime": {
                    prodItem = new SlimeProd(building);
                    break;
                }
                case "Warden": {
                    prodItem = new WardenProd(building);
                    break;
                }
                case "Ravager": {
                    prodItem = new RavagerProd(building);
                    break;
                }
                case "Grunt": {
                    prodItem = new GruntProd(building);
                    break;
                }
                case "Brute": {
                    prodItem = new BruteProd(building);
                    break;
                }
                case "Headhunter": {
                    prodItem = new HeadhunterProd(building);
                    break;
                }
                case "Hoglin": {
                    prodItem = new HoglinProd(building);
                    break;
                }
                case "Blaze": {
                    prodItem = new BlazeProd(building);
                    break;
                }
                case "Wither Skeleton": {
                    prodItem = new WitherSkeletonProd(building);
                    break;
                }
                case "Magma Cube": {
                    prodItem = new MagmaCubeProd(building);
                    break;
                }
                case "Ghast": {
                    prodItem = new GhastProd(building);
                    break;
                }
                case "Necromancer": {
                    prodItem = new NecromancerProd(building);
                    break;
                }
                case "piglin_merchant": {
                    prodItem = new PiglinMerchantProd(building);
                    break;
                }
                case "royal_guard": {
                    prodItem = new RoyalGuardProd(building);
                    break;
                }
                case "Enderman": {
                    prodItem = new EndermanProd(building);
                    break;
                }
                case "Diamond Axes": {
                    prodItem = new ResearchVindicatorAxes(building);
                    break;
                }
                case "Multishot Crossbows": {
                    prodItem = new ResearchPillagerCrossbows(building);
                    break;
                }
                case "Lightning Rod": {
                    prodItem = new ResearchLabLightningRod(building);
                    break;
                }
                case "Worker Carry Bags": {
                    prodItem = new ResearchResourceCapacity(building);
                    break;
                }
                case "Spider Jockeys": {
                    prodItem = new ResearchSpiderJockeys(building);
                    break;
                }
                case "Poison Spiders": {
                    prodItem = new ResearchPoisonSpiders(building);
                    break;
                }
                case "Husk Zombies": {
                    prodItem = new ResearchHusks(building);
                    break;
                }
                case "Drowned Zombies": {
                    prodItem = new ResearchDrowned(building);
                    break;
                }
                case "Stray Skeletons": {
                    prodItem = new ResearchStrays(building);
                    break;
                }
                case "Slimy Conversion": {
                    prodItem = new ResearchSlimeConversion(building);
                    break;
                }
                case "Lingering Potions": {
                    prodItem = new ResearchLingeringPotions(building);
                    break;
                }
                case "Water Potions": {
                    prodItem = new ResearchWaterPotions(building);
                    break;
                }
                case "Healing Potions": {
                    prodItem = new ResearchHealingPotions(building);
                    break;
                }
                case "Vexing Summons": {
                    prodItem = new ResearchEvokerVexes(building);
                    break;
                }
                case "Golem Smithing": {
                    prodItem = new ResearchGolemSmithing(building);
                    break;
                }
                case "Infested Defences": {
                    prodItem = new ResearchSilverfish(building);
                    break;
                }
                case "Sculk Amplifiers": {
                    prodItem = new ResearchSculkAmplifiers(building);
                    break;
                }
                case "Officer's Quarters": {
                    prodItem = new ResearchCastleFlag(building);
                    break;
                }
                case "Ravager Artillery": {
                    prodItem = new ResearchRavagerCavalry(building);
                    break;
                }
                case "Shield Tactics": {
                    prodItem = new ResearchBruteShields(building);
                    break;
                }
                case "Hoglin Cavalry": {
                    prodItem = new ResearchHoglinCavalry(building);
                    break;
                }
                case "Heavy Tridents": {
                    prodItem = new ResearchHeavyTridents(building);
                    break;
                }
                case "Walls of Fire": {
                    prodItem = new ResearchBlazeFirewall(building);
                    break;
                }
                case "Wither Death Clouds": {
                    prodItem = new ResearchWitherClouds(building);
                    break;
                }
                case "Advanced Portals": {
                    prodItem = new ResearchAdvancedPortals(building);
                    break;
                }
                case "Fire Resistance": {
                    prodItem = new ResearchFireResistance(building);
                    break;
                }
                case "Grand Library": {
                    prodItem = new ResearchGrandLibrary(building);
                    break;
                }
                case "Sticky Webbing": {
                    prodItem = new ResearchSpiderWebs(building);
                    break;
                }
                case "Bloodlust": {
                    prodItem = new ResearchBloodlust(building);
                    break;
                }
                case "Cube Magma": {
                    prodItem = new ResearchCubeMagma(building);
                    break;
                }
                case "Soul Fireballs": {
                    prodItem = new ResearchSoulFireballs(building);
                    break;
                }
                case "Civilian Portal": {
                    prodItem = new ResearchPortalForCivilian(building);
                    break;
                }
                case "Military Portal": {
                    prodItem = new ResearchPortalForMilitary(building);
                    break;
                }
                case "Transport Portal": {
                    prodItem = new ResearchPortalForTransport(building);
                    break;
                }
                case "Iron Beacon": {
                    prodItem = new ResearchBeaconLevel1(building);
                    break;
                }
                case "Gold Beacon": {
                    prodItem = new ResearchBeaconLevel2(building);
                    break;
                }
                case "Emerald Beacon": {
                    prodItem = new ResearchBeaconLevel3(building);
                    break;
                }
                case "Diamond Beacon": {
                    prodItem = new ResearchBeaconLevel4(building);
                    break;
                }
                case "Netherite Beacon": {
                    prodItem = new ResearchBeaconLevel5(building);
                }
            }
            if (prodItem != null) {
                if (building.getLevel().m_5776_()) {
                    building.productionQueue.add(prodItem);
                    success = true;
                } else if (prodItem.canAfford(building.ownerName)) {
                    building.productionQueue.add(prodItem);
                    ResourcesServerEvents.addSubtractResources(new Resources(building.ownerName, -prodItem.foodCost, -prodItem.woodCost, -prodItem.oreCost));
                    success = true;
                } else if (!prodItem.isBelowMaxPopulation()) {
                    ResourcesClientboundPacket.warnMaxPopulation(building.ownerName);
                } else if (!prodItem.canAffordPopulation()) {
                    ResourcesClientboundPacket.warnInsufficientPopulation(building.ownerName);
                } else {
                    ResourcesClientboundPacket.warnInsufficientResources(building.ownerName, ResourcesServerEvents.canAfford(building.ownerName, ResourceName.FOOD, prodItem.foodCost), ResourcesServerEvents.canAfford(building.ownerName, ResourceName.WOOD, prodItem.woodCost), ResourcesServerEvents.canAfford(building.ownerName, ResourceName.ORE, prodItem.oreCost));
                }
            }
        }
        return success;
    }

    public static boolean cancelProductionItem(ProductionBuilding building, String itemName, BlockPos pos, boolean frontItem) {
        boolean success = false;
        if (building != null && building.productionQueue.size() > 0) {
            if (frontItem) {
                ProductionItem prodItem = building.productionQueue.get(0);
                building.productionQueue.remove(0);
                if (!building.getLevel().m_5776_()) {
                    ResourcesServerEvents.addSubtractResources(new Resources(building.ownerName, prodItem.foodCost, prodItem.woodCost, prodItem.oreCost));
                }
                success = true;
            } else {
                for (int i = 0; i < building.productionQueue.size(); ++i) {
                    ProductionItem prodItem = building.productionQueue.get(i);
                    if (!prodItem.getItemName().equals(itemName) || !(prodItem.ticksLeft >= prodItem.ticksToProduce)) continue;
                    building.productionQueue.remove(prodItem);
                    if (!building.getLevel().m_5776_()) {
                        ResourcesServerEvents.addSubtractResources(new Resources(building.ownerName, prodItem.foodCost, prodItem.woodCost, prodItem.oreCost));
                    }
                    success = true;
                    break;
                }
            }
        }
        return success;
    }

    @Override
    public void tick(Level tickLevel) {
        ProductionItem nextItem;
        super.tick(tickLevel);
        if (this.productionQueue.size() >= 1 && (nextItem = this.productionQueue.get(0)).tick(tickLevel) && !tickLevel.m_5776_()) {
            this.productionQueue.remove(0);
            if (this.productionQueue.isEmpty()) {
                BuildingClientboundPacket.clearQueue(this.originPos);
            } else {
                BuildingClientboundPacket.completeProduction(this.originPos);
            }
        }
    }
}

