/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.tps.TPSClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class ProductionItem {
    public static String itemName;
    public int foodCost = 0;
    public int woodCost = 0;
    public int oreCost = 0;
    public int popCost = 0;
    public float ticksToProduce;
    public float ticksLeft;
    public boolean canDuplicate;
    protected ProductionBuilding building;
    protected Consumer<Level> onComplete;
    public boolean completed = false;

    public ProductionItem(ProductionBuilding building, int ticksToProduce) {
        this.building = building;
        this.ticksToProduce = ticksToProduce;
        this.ticksLeft = ticksToProduce;
    }

    public String getItemName() {
        return itemName;
    }

    public EntityType<? extends Unit> getEntityType() {
        return null;
    }

    public boolean canAfford(String ownerName) {
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            return resources.food >= this.foodCost && resources.wood >= this.woodCost && resources.ore >= this.oreCost && this.canAffordPopulation();
        }
        return false;
    }

    public boolean canAffordPopulation() {
        if (this.popCost == 0) {
            return true;
        }
        int currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)this.building.getLevel(), this.building.ownerName);
        int popSupply = BuildingServerEvents.getTotalPopulationSupply(this.building.ownerName);
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(this.building.ownerName)) continue;
            return currentPop + this.popCost <= popSupply;
        }
        return false;
    }

    public boolean isBelowPopulationSupply() {
        int popSupply;
        int currentPop;
        if (this.popCost == 0) {
            return true;
        }
        if (this.building.getLevel().m_5776_()) {
            currentPop = UnitClientEvents.getCurrentPopulation(this.building.ownerName);
            popSupply = BuildingClientEvents.getTotalPopulationSupply(this.building.ownerName);
        } else {
            currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)this.building.getLevel(), this.building.ownerName);
            popSupply = BuildingServerEvents.getTotalPopulationSupply(this.building.ownerName);
        }
        return currentPop <= popSupply;
    }

    public boolean isBelowMaxPopulation() {
        if (this.popCost == 0) {
            return true;
        }
        int currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)this.building.getLevel(), this.building.ownerName);
        int popSupply = BuildingServerEvents.getTotalPopulationSupply(this.building.ownerName);
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(this.building.ownerName)) continue;
            if (this.building.level.m_5776_()) {
                return currentPop + this.popCost <= GameruleClient.maxPopulation;
            }
            return currentPop + this.popCost <= UnitServerEvents.maxPopulation;
        }
        return false;
    }

    public static boolean itemIsBeingProduced(String itemName, String ownerName) {
        for (Building building : BuildingClientEvents.getBuildings()) {
            if (!building.ownerName.equals(ownerName) || !(building instanceof ProductionBuilding)) continue;
            ProductionBuilding prodBuilding = (ProductionBuilding)building;
            for (ProductionItem prodItem : prodBuilding.productionQueue) {
                if (!prodItem.getItemName().equals(itemName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemIsBeingProduced(String itemName, ProductionBuilding pBuilding) {
        for (ProductionItem prodItem : pBuilding.productionQueue) {
            if (!prodItem.getItemName().equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding) {
        return null;
    }

    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return null;
    }

    public boolean tick(Level level) {
        if (this.ticksLeft > 0.0f && this.isBelowPopulationSupply()) {
            this.ticksLeft = level.m_5776_() && ResearchClient.hasCheat("warpten") || !level.m_5776_() && ResearchServerEvents.playerHasCheat(this.building.ownerName, "warpten") ? (level.m_5776_() ? (float)((double)this.ticksLeft - TPSClientEvents.getCappedTPS() / 20.0 * 20.0) : (this.ticksLeft -= 20.0f)) : (level.m_5776_() ? (float)((double)this.ticksLeft - TPSClientEvents.getCappedTPS() / 20.0) : (this.ticksLeft -= 1.0f));
            if (this.ticksLeft < 0.0f) {
                this.ticksLeft = 0.0f;
            }
        }
        if (this.ticksLeft <= 0.0f && this.isBelowPopulationSupply() && !this.completed) {
            this.onComplete.accept(level);
            this.completed = true;
            return true;
        }
        return false;
    }
}

