/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class DarkWatchtower
extends Building
implements GarrisonableBuilding {
    public static final String buildingName = "Dark Watchtower";
    public static final String structureName = "dark_watchtower";
    public static final ResourceCost cost = ResourceCosts.DARK_WATCHTOWER;
    private static final int MAX_OCCUPANTS = 3;

    public DarkWatchtower(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(DarkWatchtower.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_152589_;
        this.icon = new ResourceLocation("minecraft", "textures/block/deepslate_bricks.png");
        this.foodCost = DarkWatchtower.cost.food;
        this.woodCost = DarkWatchtower.cost.wood;
        this.oreCost = DarkWatchtower.cost.ore;
        this.popSupply = DarkWatchtower.cost.population;
        this.buildTimeModifier = 1.0f;
        this.startingBlockTypes.add(Blocks.f_152589_);
        this.startingBlockTypes.add(Blocks.f_152591_);
        this.startingBlockTypes.add(Blocks.f_152594_);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public int getAttackRange() {
        return 24;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 10;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 10 && relativeBp.m_123342_() != 11;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/deepslate_bricks.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == DarkWatchtower.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(DarkWatchtower.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dark_watchtower", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dark_watchtower.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dark_watchtower.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dark_watchtower.tooltip3", (Object[])new Object[]{3}), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 11, -2);
        }
        return new BlockPos(2, 11, -2);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 1, -2);
        }
        return new BlockPos(2, 1, -2);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 3;
    }
}

