/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.monsters.DrownedProd;
import com.solegendary.reignofnether.unit.units.monsters.HuskProd;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonProd;
import com.solegendary.reignofnether.unit.units.monsters.StrayProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Graveyard
extends ProductionBuilding {
    public static final String buildingName = "Graveyard";
    public static final String structureName = "graveyard";
    public static final ResourceCost cost = ResourceCosts.GRAVEYARD;

    public Graveyard(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Graveyard.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50223_;
        this.icon = new ResourceLocation("minecraft", "textures/block/mossy_stone_bricks.png");
        this.foodCost = Graveyard.cost.food;
        this.woodCost = Graveyard.cost.wood;
        this.oreCost = Graveyard.cost.ore;
        this.popSupply = Graveyard.cost.population;
        this.startingBlockTypes.add(Blocks.f_152589_);
        this.explodeChance = 0.2f;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ZombieProd.getStartButton(this, Keybindings.keyQ), HuskProd.getStartButton(this, Keybindings.keyQ), DrownedProd.getStartButton(this, Keybindings.keyW), SkeletonProd.getStartButton(this, Keybindings.keyE), StrayProd.getStartButton(this, Keybindings.keyE));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/mossy_stone_bricks.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Graveyard.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Graveyard.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.graveyard", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.graveyard.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

