/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class HauntedHouse
extends Building {
    public static final String buildingName = "Haunted House";
    public static final String structureName = "haunted_house";
    public static final ResourceCost cost = ResourceCosts.HAUNTED_HOUSE;

    public HauntedHouse(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(HauntedHouse.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50004_;
        this.icon = new ResourceLocation("minecraft", "textures/block/dark_oak_log.png");
        this.foodCost = HauntedHouse.cost.food;
        this.woodCost = HauntedHouse.cost.wood;
        this.oreCost = HauntedHouse.cost.ore;
        this.popSupply = HauntedHouse.cost.population;
        this.buildTimeModifier = 0.8f;
        this.startingBlockTypes.add(Blocks.f_50741_);
        this.startingBlockTypes.add(Blocks.f_50004_);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/dark_oak_log.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == HauntedHouse.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(HauntedHouse.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.haunted_house", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.haunted_house.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

