/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.CallLightning;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchDrowned;
import com.solegendary.reignofnether.research.researchItems.ResearchHusks;
import com.solegendary.reignofnether.research.researchItems.ResearchLabLightningRod;
import com.solegendary.reignofnether.research.researchItems.ResearchPoisonSpiders;
import com.solegendary.reignofnether.research.researchItems.ResearchSculkAmplifiers;
import com.solegendary.reignofnether.research.researchItems.ResearchSilverfish;
import com.solegendary.reignofnether.research.researchItems.ResearchSlimeConversion;
import com.solegendary.reignofnether.research.researchItems.ResearchSpiderJockeys;
import com.solegendary.reignofnether.research.researchItems.ResearchSpiderWebs;
import com.solegendary.reignofnether.research.researchItems.ResearchStrays;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Laboratory
extends ProductionBuilding
implements RangeIndicator {
    public static final String buildingName = "Laboratory";
    public static final String structureName = "laboratory";
    public static final String upgradedStructureName = "laboratory_lightning";
    public static final ResourceCost cost = ResourceCosts.LABORATORY;
    private final Set<BlockPos> lightningBorderBps = new HashSet<BlockPos>();

    public Laboratory(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Laboratory.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50255_;
        this.icon = new ResourceLocation("minecraft", "textures/block/brewing_stand.png");
        this.foodCost = Laboratory.cost.food;
        this.woodCost = Laboratory.cost.wood;
        this.oreCost = Laboratory.cost.ore;
        this.popSupply = Laboratory.cost.population;
        this.buildTimeModifier = 0.85f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50741_);
        this.startingBlockTypes.add(Blocks.f_50730_);
        this.abilities.add(new CallLightning(this));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchHusks.getStartButton(this, Keybindings.keyQ), ResearchDrowned.getStartButton(this, Keybindings.keyW), ResearchStrays.getStartButton(this, Keybindings.keyE), ResearchSpiderJockeys.getStartButton(this, Keybindings.keyR), ResearchPoisonSpiders.getStartButton(this, Keybindings.keyT), ResearchSpiderWebs.getStartButton(this, Keybindings.keyY), ResearchSlimeConversion.getStartButton(this, Keybindings.keyU), ResearchLabLightningRod.getStartButton(this, Keybindings.keyI), ResearchSilverfish.getStartButton(this, Keybindings.keyO), ResearchSculkAmplifiers.getStartButton(this, Keybindings.keyP));
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyL));
        }
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    private int getLightningRange() {
        return this.getUpgradeLevel() > 0 && this.isBuilt ? 25 : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.lightningBorderBps.clear();
        this.lightningBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getLightningRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.lightningBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public BlockPos getLightningRodPos() {
        for (BuildingBlock block : this.blocks) {
            if (this.getLevel().m_8055_(block.getBlockPos()).m_60734_() != Blocks.f_152587_ || this.getLevel().m_8055_(block.getBlockPos().m_7495_()).m_60734_() != Blocks.f_152571_) continue;
            return block.getBlockPos();
        }
        return null;
    }

    @Override
    public int getUpgradeLevel() {
        for (BuildingBlock block : this.blocks) {
            if (block.getBlockState().m_60734_() != Blocks.f_152587_) continue;
            return 1;
        }
        return 0;
    }

    public void changeStructure(String newStructureName) {
        ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocks(newStructureName, (LevelAccessor)this.getLevel());
        this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
        super.refreshBlocks();
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/brewing_stand.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Laboratory.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Mausoleum") && BuildingClientEvents.hasFinishedBuilding("Graveyard") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Laboratory.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

