/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerProd;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Mausoleum
extends ProductionBuilding
implements NightSource,
RangeIndicator {
    public static final String buildingName = "Mausoleum";
    public static final String structureName = "mausoleum";
    public static final ResourceCost cost = ResourceCosts.MAUSOLEUM;
    public static final int nightRange = 70;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();

    public Mausoleum(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Mausoleum.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), true);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.blocks = BuildingUtils.getAbsoluteBlockData(Mausoleum.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation);
        this.portraitBlock = Blocks.f_152559_;
        this.icon = new ResourceLocation("minecraft", "textures/block/deepslate_tiles.png");
        this.foodCost = Mausoleum.cost.food;
        this.woodCost = Mausoleum.cost.wood;
        this.oreCost = Mausoleum.cost.ore;
        this.popSupply = Mausoleum.cost.population;
        this.buildTimeModifier = 0.274f;
        this.canAcceptResources = true;
        this.startingBlockTypes.add(Blocks.f_50069_);
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.updateButtons();
        this.updateBorderBps();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = List.of(ZombieVillagerProd.getStartButton(this, Keybindings.keyQ));
        }
    }

    @Override
    public int getNightRange() {
        return this.isBuilt || this.isBuiltServerside ? 70 : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.nightBorderBps.clear();
        this.nightBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getNightRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.nightBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return false;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/deepslate_tiles.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Mausoleum.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(Mausoleum.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.mausoleum.tooltip2", (Object[])new Object[]{70}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_)), null);
    }
}

